/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.unit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;
import rasmus.interpreter.metadata.MetaData;
import rasmus.interpreter.metadata.MetaDataProvider;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitFactory;
import rasmus.interpreter.unit.UnitInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Unit
extends ListPart {
    ArrayList instances = new ArrayList();
    ListPartListener rlistlistener = new ListPartListener(){

        public void objectAdded(ListPart source, Object object) {
            if (object instanceof UnitFactory) {
                Unit.this.addFactory((UnitFactory)object);
            }
        }

        public void objectRemoved(ListPart source, Object object) {
            if (object instanceof UnitFactory) {
                Unit.this.removeFactory((UnitFactory)object);
            }
        }

        public void objectsAdded(ListPart source, List objects) {
            for (Object object : objects) {
                if (!(object instanceof UnitFactory)) continue;
                Unit.this.addFactory((UnitFactory)object);
            }
        }

        public void objectsRemoved(ListPart source, List objects) {
            for (Object object : objects) {
                if (!(object instanceof UnitFactory)) continue;
                Unit.this.removeFactory((UnitFactory)object);
            }
        }
    };
    static /* synthetic */ Class class$0;

    public List<MetaData> getMetaData() {
        ArrayList<MetaData> list = null;
        for (UnitFactory element : this.getObjects()) {
            if (!(element instanceof MetaDataProvider)) continue;
            if (list == null) {
                list = new ArrayList<MetaData>();
            }
            list.add(((MetaDataProvider)((Object)element)).getMetaData());
        }
        return list;
    }

    public static Variable asVariable(UnitFactory value) {
        Variable variable = new Variable();
        Unit runit = (Unit)variable.get(Unit.class);
        runit.addObject(value);
        return variable;
    }

    public static UnitInstance newInstance(Variable unit, Parameters parameter) {
        UnitInstance ret = Unit.getInstance(unit).newInstance(parameter);
        return ret;
    }

    public static UnitInstance newInstance(Variable unit, NameSpace namespace, Variable ... arguments) {
        Parameters p = new Parameters(namespace);
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i] != null) {
                p.setParameter(i, arguments[i]);
            }
            ++i;
        }
        return Unit.newInstance(unit, p);
    }

    public UnitInstance newInstance(Parameters parameters) {
        UnitInstance unitinstance = new UnitInstance(this, parameters, this.getObjects().toArray());
        this.instances.add(unitinstance);
        return unitinstance;
    }

    public static Unit getInstance(Variable variable) {
        return (Unit)variable.get(Unit.class);
    }

    public void addFactory(UnitFactory factory) {
        Iterator iterator = this.instances.iterator();
        while (iterator.hasNext()) {
            ((UnitInstance)iterator.next()).addFactory(factory);
        }
    }

    public void removeFactory(UnitFactory factory) {
        Iterator iterator = this.instances.iterator();
        while (iterator.hasNext()) {
            ((UnitInstance)iterator.next()).removeFactory(factory);
        }
    }

    public Unit() {
        this.forceAddListener(this.rlistlistener);
    }
}

