/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.unit;

import rasmus.interpreter.Closeable;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.Unit;
import rasmus.interpreter.unit.UnitFactory;
import rasmus.interpreter.unit.UnitInstancePart;

public class UnitInstance
implements Closeable {
    private Parameters parameters;
    private Unit runit;
    private boolean updateable = true;
    private UnitFactory[] instances_factory = new UnitFactory[0];
    private UnitInstancePart[] instances_object = new UnitInstancePart[0];

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    public UnitInstance(Unit runit, Parameters parameters, Object[] factories) {
        this.parameters = parameters;
        this.runit = runit;
        parameters.getNameSpace().addToCommitStack(new InitTask(factories));
    }

    public void addFactory(UnitFactory factory) {
        if (!this.updateable) {
            return;
        }
        this.parameters.getNameSpace().addToCommitStack(new AddFactoryTask(factory));
    }

    public void removeFactory(UnitFactory factory) {
        if (!this.updateable) {
            return;
        }
        this.parameters.getNameSpace().addToCommitStack(new RemoveFactoryTask(factory));
    }

    public void close() {
        this.parameters.getNameSpace().addToCommitStack(new Commitable(){

            public int getRunLevel() {
                return 0;
            }

            public void commit() {
                if (UnitInstance.this.instances_object != null) {
                    int i = 0;
                    while (i < UnitInstance.this.instances_object.length) {
                        UnitInstance.this.instances_object[i].close();
                        ++i;
                    }
                }
                UnitInstance.this.instances_object = null;
                UnitInstance.this.instances_factory = null;
            }
        });
        this.runit.instances.remove(this);
    }

    private class InitTask
    implements Commitable {
        Object[] factories;

        public InitTask(Object[] factories) {
            this.factories = factories;
        }

        public int getRunLevel() {
            return 0;
        }

        public void commit() {
            UnitInstance.this.instances_factory = new UnitFactory[this.factories.length];
            UnitInstance.this.instances_object = new UnitInstancePart[this.factories.length];
            int i = 0;
            while (i < UnitInstance.this.instances_factory.length) {
                UnitFactory factory;
                ((UnitInstance)UnitInstance.this).instances_factory[i] = factory = (UnitFactory)this.factories[i];
                ((UnitInstance)UnitInstance.this).instances_object[i] = factory.newInstance(UnitInstance.this.parameters);
                ++i;
            }
        }
    }

    private class AddFactoryTask
    implements Commitable {
        UnitFactory factory;

        public AddFactoryTask(UnitFactory factory) {
            this.factory = factory;
        }

        public int getRunLevel() {
            return 0;
        }

        public void commit() {
            if (UnitInstance.this.instances_factory == null) {
                UnitInstance.this.instances_factory = new UnitFactory[1];
                UnitInstance.this.instances_object = new UnitInstancePart[1];
            } else {
                UnitFactory[] new_instances_factory = new UnitFactory[UnitInstance.this.instances_factory.length + 1];
                UnitInstancePart[] new_instances_object = new UnitInstancePart[UnitInstance.this.instances_object.length + 1];
                int i = 0;
                while (i < UnitInstance.this.instances_object.length) {
                    new_instances_factory[i + 1] = UnitInstance.this.instances_factory[i];
                    new_instances_object[i + 1] = UnitInstance.this.instances_object[i];
                    ++i;
                }
                UnitInstance.this.instances_factory = new_instances_factory;
                UnitInstance.this.instances_object = new_instances_object;
            }
            ((UnitInstance)UnitInstance.this).instances_factory[0] = this.factory;
            ((UnitInstance)UnitInstance.this).instances_object[0] = this.factory.newInstance(UnitInstance.this.parameters);
        }
    }

    private class RemoveFactoryTask
    implements Commitable {
        UnitFactory factory;

        public RemoveFactoryTask(UnitFactory factory) {
            this.factory = factory;
        }

        public int getRunLevel() {
            return 0;
        }

        public void commit() {
            if (UnitInstance.this.instances_factory == null) {
                return;
            }
            if (UnitInstance.this.instances_factory.length == 1) {
                if (UnitInstance.this.instances_factory[0] == this.factory) {
                    UnitInstance.this.instances_object[0].close();
                    UnitInstance.this.instances_factory = null;
                    UnitInstance.this.instances_object = null;
                }
                return;
            }
            int fcount = 0;
            int i = 0;
            while (i < UnitInstance.this.instances_factory.length) {
                if (UnitInstance.this.instances_factory[i] == this.factory) {
                    UnitInstance.this.instances_object[i].close();
                    ++fcount;
                }
                ++i;
            }
            if (fcount == 0) {
                return;
            }
            UnitFactory[] new_instances_factory = new UnitFactory[UnitInstance.this.instances_factory.length - fcount];
            UnitInstancePart[] new_instances_object = new UnitInstancePart[UnitInstance.this.instances_object.length - fcount];
            int j = 0;
            int i2 = 0;
            while (i2 < UnitInstance.this.instances_factory.length) {
                if (UnitInstance.this.instances_factory[i2] != this.factory) {
                    new_instances_factory[j] = UnitInstance.this.instances_factory[i2];
                    new_instances_object[j] = UnitInstance.this.instances_object[i2];
                    ++j;
                }
                ++i2;
            }
            UnitInstance.this.instances_factory = new_instances_factory;
            UnitInstance.this.instances_object = new_instances_object;
        }
    }
}

