/*
 * Decompiled with CFR 0.152.
 */
package rasmus.midi.provider;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Transmitter;
import rasmus.midi.provider.MultiMidiCastDevice;

class MultiMidiCastTransmitter
implements Transmitter {
    MultiMidiCastDevice dev;
    Receiver recv = null;
    int port;
    boolean isOpen = true;
    InetAddress ia;
    MultiMidiCastServerThread mthread = null;
    boolean started = false;

    public MidiMessage encodeMidiBuffer(byte[] data, int offset, int len) {
        try {
            byte statusbyte = data[0];
            if (statusbyte == -9) {
                SysexMessage sysex = new SysexMessage();
                byte[] mydata = new byte[len];
                int i = 0;
                while (i < len) {
                    mydata[i] = data[i + offset];
                    ++i;
                }
                try {
                    sysex.setMessage(statusbyte, mydata, mydata.length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return sysex;
            }
            ShortMessage shortmsg = new ShortMessage();
            if (len == 1) {
                shortmsg.setMessage(data[offset] & 0xFF);
            } else if (len == 2) {
                shortmsg.setMessage(data[offset] & 0xFF, data[offset + 1] & 0xFF, 0);
            } else {
                shortmsg.setMessage(data[offset] & 0xFF, data[offset + 1] & 0xFF, data[offset + 2] & 0xFF);
            }
            return shortmsg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void send(MidiMessage midimessage) {
        if (midimessage == null) {
            return;
        }
        if (this.recv != null) {
            this.recv.send(midimessage, -1L);
        }
    }

    public void encodeMidiBuffer(byte[] data, int len) {
        int lasti = 0;
        boolean sysex = false;
        int i = 0;
        while (i < len) {
            byte d = data[i];
            if (sysex) {
                if (d == -9) {
                    if (i - lasti > 0) {
                        this.send(this.encodeMidiBuffer(data, lasti, i - lasti));
                    }
                    sysex = false;
                    lasti = i;
                }
            } else if (d < 0) {
                if (i - lasti > 0) {
                    this.send(this.encodeMidiBuffer(data, lasti, i - lasti));
                }
                if (d == 240) {
                    sysex = true;
                }
                lasti = i;
            }
            ++i;
        }
        if (len - lasti > 0) {
            this.send(this.encodeMidiBuffer(data, lasti, len - lasti));
        }
    }

    public MultiMidiCastTransmitter(MultiMidiCastDevice dev) {
        this.dev = dev;
        this.port = dev.info.port;
        dev.transmitters.add(this);
    }

    public void start() {
        if (this.started) {
            return;
        }
        try {
            this.ia = this.dev.multicasthost;
            this.mthread = new MultiMidiCastServerThread();
            this.mthread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.started = true;
    }

    public void setReceiver(Receiver recv) {
        this.start();
        this.recv = recv;
    }

    public Receiver getReceiver() {
        return this.recv;
    }

    public void close() {
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        this.dev.transmitters.remove(this);
        if (this.mthread != null) {
            this.mthread.stopServer();
            this.mthread = null;
        }
    }

    class MultiMidiCastServerThread
    extends Thread {
        MulticastSocket ms;
        boolean active = true;

        MultiMidiCastServerThread() {
        }

        public void stopServer() {
            this.active = false;
            this.interrupt();
            try {
                this.ms.leaveGroup(MultiMidiCastTransmitter.this.ia);
                this.ms.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void run() {
            try {
                this.ms = new MulticastSocket(21928 + MultiMidiCastTransmitter.this.port);
                this.ms.setInterface(MultiMidiCastTransmitter.this.dev.localhost);
                this.ms.joinGroup(MultiMidiCastTransmitter.this.ia);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.ms = null;
            }
            DatagramPacket dp = new DatagramPacket(new byte[1280], 1280);
            while (this.active) {
                try {
                    this.ms.receive(dp);
                    if (dp.getLength() == 0) continue;
                    MultiMidiCastTransmitter.this.encodeMidiBuffer(dp.getData(), dp.getLength());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.ms = null;
        }
    }
}

