/*
 * Decompiled with CFR 0.152.
 */
package rasmus.testing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.midi.MidiKeyListener;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.sf2.SF2SoundFont;
import rasmus.interpreter.sf2.SF2SoundFontManager;
import rasmus.interpreter.ui.RegisterUnit;

public class SoundFontTester
extends JFrame {
    private static final long serialVersionUID = 1L;
    Interpreter interpreter;
    Interpreter presetinterpreter = null;
    Interpreter effectinterpreter = null;
    JList jlist;
    JComboBox jefectlist;
    int curindex = -1;
    String filename;
    String[] presets;
    MidiKeyListener midikeylistener;
    String title = "";
    int listmode = 0;
    File currentfile = null;
    File[] filelist;
    String[] effectpresets = new String[]{"Dry", "Large Reverb", "Small Reverb", "Pure Reverb", "DelayLine 120 bpm", "DelayLine 180 bpm", "DelayLine 180 bpm Stereo", "Flanger", "Distortion", "Distortion+Flanger", "Vocoder using Mic/Line In"};
    boolean exitonclose = true;
    Thread t2 = null;

    public static void main(String[] args) {
        SoundFontTester sft = new SoundFontTester();
        sft.setVisible(true);
    }

    public void selectPreset(int index) {
        this.midikeylistener.allNotesOff();
        if (index != this.curindex) {
            this.curindex = index;
            this.jlist.setEnabled(false);
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    SoundFontTester soundFontTester = SoundFontTester.this;
                    synchronized (soundFontTester) {
                        SoundFontTester.this.setTitle("Loading Preset...");
                        if (SoundFontTester.this.presetinterpreter != null) {
                            SoundFontTester.this.presetinterpreter.close();
                            SoundFontTester.this.presetinterpreter.commit();
                        }
                        if (SoundFontTester.this.curindex != -1) {
                            String preset = SoundFontTester.this.presets[SoundFontTester.this.curindex];
                            SoundFontTester.this.presetinterpreter = new Interpreter(SoundFontTester.this.interpreter);
                            SoundFontTester.this.presetinterpreter.setAutoCommit(false);
                            SoundFontTester.this.presetinterpreter.add("filename", (Object)SoundFontTester.this.filename);
                            try {
                                SoundFontTester.this.presetinterpreter.eval("preset <- SF2Preset(filename, " + preset + ");");
                            }
                            catch (ScriptParserException e1) {
                                e1.printStackTrace();
                            }
                            try {
                                SoundFontTester.this.presetinterpreter.eval("preset_output <- clip(-3, 3) <- Synthesizer(preset) <- input;");
                            }
                            catch (ScriptParserException e) {
                                e.printStackTrace();
                            }
                            SoundFontTester.this.presetinterpreter.commit();
                        }
                        SoundFontTester.this.setTitle(SoundFontTester.this.title);
                    }
                    SoundFontTester.this.jlist.setEnabled(true);
                }
            };
            Thread t = new Thread(runnable);
            t.setPriority(1);
            t.start();
        }
    }

    public void loadSoundFont(String filename) {
        this.midikeylistener.allNotesOff();
        Thread t2 = this.t2;
        if (t2 != null) {
            try {
                t2.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.filename = filename;
        SF2SoundFont soundfont = SF2SoundFontManager.getSF2SoundFont(filename);
        NodeList presetlist = soundfont.getDocument().getElementsByTagName("preset");
        String[] listdata = new String[presetlist.getLength()];
        this.presets = new String[presetlist.getLength()];
        Element[] elementlist = new Element[presetlist.getLength()];
        int i = 0;
        while (i < presetlist.getLength()) {
            elementlist[i] = (Element)presetlist.item(i);
            ++i;
        }
        Arrays.sort(elementlist, new Comparator<Element>(){

            @Override
            public int compare(Element arg0, Element arg1) {
                int preset1 = Integer.parseInt(arg0.getAttribute("preset"));
                int bank1 = Integer.parseInt(arg0.getAttribute("bank"));
                int preset2 = Integer.parseInt(arg1.getAttribute("preset"));
                int bank2 = Integer.parseInt(arg1.getAttribute("bank"));
                if (bank1 != bank2) {
                    return bank1 - bank2;
                }
                return preset1 - preset2;
            }
        });
        i = 0;
        while (i < elementlist.length) {
            Element element = elementlist[i];
            listdata[i] = String.valueOf(element.getAttribute("preset")) + "," + element.getAttribute("bank") + " = " + element.getAttribute("name");
            this.presets[i] = String.valueOf(element.getAttribute("preset")) + "," + element.getAttribute("bank");
            ++i;
        }
        this.listmode = 1;
        this.jlist.setListData(listdata);
    }

    public void selectEffectPreset(int id) {
        this.effectinterpreter.close();
        this.effectinterpreter = new Interpreter(this.interpreter);
        this.effectinterpreter.setAutoCommit(false);
        try {
            switch (id) {
                case 1: {
                    this.effectinterpreter.eval("effect_output <- reverb(dry=0.7, wet=0.3) <- preset_output;");
                    break;
                }
                case 2: {
                    this.effectinterpreter.eval("effect_output <- reverb(dry=0.7, wet=0.3, scale=0.1, damp=0.1) <- preset_output;");
                    break;
                }
                case 3: {
                    this.effectinterpreter.eval("effect_output <- reverb() <- preset_output;");
                    break;
                }
                case 4: {
                    this.effectinterpreter.eval("effect_output <- gain(0.5) <- delayline(60/120, 0.5) <- preset_output;");
                    this.effectinterpreter.eval("effect_output <- preset_output;");
                    break;
                }
                case 5: {
                    this.effectinterpreter.eval("effect_output <- gain(0.5) <- delayline(60/180, 0.5) <- preset_output;");
                    this.effectinterpreter.eval("effect_output <- preset_output;");
                    break;
                }
                case 6: {
                    this.effectinterpreter.eval("effect_output <- ChannelGain(0.5,0) <- delayline(60/90, 0.5) <- preset_output;");
                    this.effectinterpreter.eval("effect_output <- ChannelGain(0,0.5) <- delayline(60/180) <- preset_output + (delayline(60/90, 0.5) <- preset_output);");
                    this.effectinterpreter.eval("effect_output <- preset_output;");
                    break;
                }
                case 7: {
                    this.effectinterpreter.eval("effect_output <- agc() <- flanger() <- preset_output;");
                    break;
                }
                case 8: {
                    this.effectinterpreter.eval("effect_output <- bw_lowpass(3000/srate()) <- gain(0.1) <- atan() <- gain(1000) <- bw_lowpass(8000/srate()) <- preset_output;");
                    break;
                }
                case 9: {
                    this.effectinterpreter.eval("effect_output <- flanger() <- bw_lowpass(3000/srate()) <- gain(0.1) <- atan() <- gain(1000) <- bw_lowpass(8000/srate()) <- preset_output;");
                    break;
                }
                case 10: {
                    this.effectinterpreter.eval("mic <- agc() <- AudioInput()*2;");
                    this.effectinterpreter.eval("mono <- vocoder(mic) <- preset_output;");
                    this.effectinterpreter.eval("effect_output <- agc() <- channelmux(mono, mono);");
                    break;
                }
                default: {
                    this.effectinterpreter.eval("effect_output <- preset_output;");
                    break;
                }
            }
        }
        catch (ScriptParserException e) {
            e.printStackTrace();
        }
        this.effectinterpreter.commit();
    }

    public void selectFile(File file) {
        int i;
        this.midikeylistener.allNotesOff();
        this.currentfile = file;
        try {
            this.title = file == null ? "SoundFont Tester" : "SoundFont Tester - " + file.getCanonicalPath();
            this.setTitle(this.title);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (file != null && file.isFile()) {
            this.loadSoundFont(file.getPath());
            return;
        }
        this.listmode = 0;
        if (file == null) {
            this.filelist = File.listRoots();
        } else {
            this.filelist = file.listFiles();
            ArrayList<File> alist = new ArrayList<File>();
            i = 0;
            while (i < this.filelist.length) {
                if (this.filelist[i].isDirectory()) {
                    alist.add(this.filelist[i]);
                }
                ++i;
            }
            i = 0;
            while (i < this.filelist.length) {
                if (this.filelist[i].toString().toLowerCase().endsWith(".sf2")) {
                    alist.add(this.filelist[i]);
                }
                ++i;
            }
            this.filelist = new File[alist.size()];
            alist.toArray(this.filelist);
        }
        String[] listdata = new String[this.filelist.length];
        i = 0;
        while (i < this.filelist.length) {
            listdata[i] = file == null ? String.valueOf(this.filelist[i].toString()) + " <ROOT>" : (this.filelist[i].isDirectory() ? String.valueOf(this.filelist[i].getName()) + " <DIR>" : this.filelist[i].getName());
            ++i;
        }
        this.jlist.setListData(listdata);
    }

    public void setExitOnClose(boolean value) {
        this.exitonclose = value;
    }

    public SoundFontTester() {
        this.setSize(640, 400);
        this.setLocationByPlatform(true);
        this.setTitle("RasmusDSP - SoundFont Tester");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent arg0) {
                SoundFontTester.this.setVisible(false);
                System.out.println("Close interpreter...");
                Thread t2 = SoundFontTester.this.t2;
                if (t2 != null) {
                    try {
                        t2.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                SoundFontTester.this.interpreter.close();
                SoundFontTester.this.interpreter.commit();
                System.out.println("OK");
                if (SoundFontTester.this.exitonclose) {
                    System.exit(0);
                }
            }
        });
        this.midikeylistener = new MidiKeyListener();
        this.jefectlist = new JComboBox<String>(this.effectpresets);
        this.jefectlist.setFocusable(false);
        this.jefectlist.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SoundFontTester.this.selectEffectPreset(SoundFontTester.this.jefectlist.getSelectedIndex());
            }
        });
        this.jefectlist.setEnabled(false);
        this.jlist = new JList(){
            private static final long serialVersionUID = 1L;

            protected boolean processKeyBinding(KeyStroke s, KeyEvent e, int arg2, boolean arg3) {
                if (e.getKeyCode() == 33 || e.getKeyCode() == 34) {
                    return false;
                }
                if (SoundFontTester.this.listmode == 0) {
                    return super.processKeyBinding(s, e, arg2, arg3);
                }
                if (e.getID() == 400) {
                    return false;
                }
                if (SoundFontTester.this.midikeylistener.isConsumed(e)) {
                    return false;
                }
                return super.processKeyBinding(s, e, arg2, arg3);
            }

            protected void processKeyEvent(KeyEvent e) {
                int id = e.getID();
                if (id == 401) {
                    int li;
                    if (e.getKeyCode() == 33) {
                        SoundFontTester.this.midikeylistener.setOctave(SoundFontTester.this.midikeylistener.getOctave() + 1);
                        return;
                    }
                    if (e.getKeyCode() == 34) {
                        SoundFontTester.this.midikeylistener.setOctave(SoundFontTester.this.midikeylistener.getOctave() - 1);
                        return;
                    }
                    if (e.getKeyCode() == 8) {
                        if (SoundFontTester.this.currentfile != null) {
                            SoundFontTester.this.selectFile(SoundFontTester.this.currentfile.getParentFile());
                        }
                        return;
                    }
                    if (e.getKeyCode() == 10 && SoundFontTester.this.listmode == 0 && (li = SoundFontTester.this.jlist.getSelectedIndex()) != -1) {
                        SoundFontTester.this.selectFile(SoundFontTester.this.filelist[li]);
                    }
                }
                if (SoundFontTester.this.listmode == 0) {
                    super.processKeyEvent(e);
                    return;
                }
                if (id == 400) {
                    return;
                }
                if (id == 401) {
                    SoundFontTester.this.midikeylistener.keyPressed(e);
                }
                if (id == 400) {
                    SoundFontTester.this.midikeylistener.keyTyped(e);
                }
                if (id == 402) {
                    SoundFontTester.this.midikeylistener.keyReleased(e);
                }
                if (!e.isConsumed()) {
                    super.processKeyEvent(e);
                }
            }
        };
        this.jlist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                if (SoundFontTester.this.listmode == 0) {
                    return;
                }
                SoundFontTester.this.selectPreset(SoundFontTester.this.jlist.getSelectedIndex());
            }
        });
        this.jlist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg0) {
                int li;
                if (SoundFontTester.this.listmode == 0 && arg0.getClickCount() == 2 && (li = SoundFontTester.this.jlist.getSelectedIndex()) != -1) {
                    SoundFontTester.this.selectFile(SoundFontTester.this.filelist[li]);
                }
            }
        });
        JPanel sp = new JPanel();
        sp.setLayout(new BorderLayout());
        sp.add((Component)this.jefectlist, "North");
        sp.add((Component)new JScrollPane(this.jlist), "Center");
        this.add(sp);
        this.selectFile(null);
        this.t2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                System.out.println("Initilize interpreter...");
                SoundFontTester.this.interpreter = new Interpreter();
                Object[] audioutputs = ObjectsPart.asObjects(SoundFontTester.this.interpreter.get("group_audio_dev_output"));
                int i = 0;
                while (i < audioutputs.length) {
                    audioutputs[i] = ((RegisterUnit.Record)audioutputs[i]).name;
                    ++i;
                }
                Object audiooutput = SoundFontTester.this.showInputDialog("Select Audio Output", audioutputs);
                Object[] bufferlens = new Object[]{"100", "90", "80", "70", "60", "50", "40", "30", "20", "10", "5", "1"};
                Object bufferlen = SoundFontTester.this.showInputDialog("Select Audio Buffer Length (ms)", bufferlens);
                if (bufferlen == null) {
                    bufferlen = "100";
                }
                bufferlen = Double.toString(Double.parseDouble((String)bufferlen) / 1000.0);
                Object[] midiinputs = ObjectsPart.asObjects(SoundFontTester.this.interpreter.get("group_midi_dev_input"));
                int i2 = 0;
                while (i2 < midiinputs.length) {
                    midiinputs[i2] = ((RegisterUnit.Record)midiinputs[i2]).name;
                    ++i2;
                }
                Object midiinput = SoundFontTester.this.showInputDialog("Select MIDI Input", midiinputs);
                SoundFontTester.this.midikeylistener.setReceiver(MidiSequence.getInstance(SoundFontTester.this.interpreter.get("input")));
                System.out.println("Create AudioOutput(\"" + audiooutput + "\", 44100hz, 2ch, 16bits)...");
                SoundFontTester.this.effectinterpreter = new Interpreter(SoundFontTester.this.interpreter);
                SoundFontTester.this.effectinterpreter.setAutoCommit(false);
                try {
                    SoundFontTester.this.effectinterpreter.eval("effect_output <- preset_output;");
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                if (audiooutput != null) {
                    try {
                        SoundFontTester.this.interpreter.eval("AudioOutput(\"" + audiooutput + "\", bufferlen=" + bufferlen + ", rate=44100, channels=2, bits=16, blocking=0) <- agc() <- gain(0.7) <- effect_output;");
                    }
                    catch (ScriptParserException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    try {
                        SoundFontTester.this.interpreter.eval("AudioOutput(bufferlen=" + bufferlen + ", rate=44100, channels=2, bits=16, blocking=0) <- agc() <- gain(0.7) <- effect_output;");
                    }
                    catch (ScriptParserException e1) {
                        e1.printStackTrace();
                    }
                }
                if (midiinput != null) {
                    System.out.println("Create MidiInput(\"" + midiinput + "\")...");
                    try {
                        SoundFontTester.this.interpreter.eval("input <- MidiInput(\"" + midiinput + "\");");
                    }
                    catch (ScriptParserException e) {
                        e.printStackTrace();
                    }
                }
                System.out.println("OK");
                SoundFontTester.this.interpreter.commit();
                SoundFontTester.this.jefectlist.setEnabled(true);
                Thread thread = SoundFontTester.this.t2;
                synchronized (thread) {
                    SoundFontTester.this.t2 = null;
                }
            }
        };
        this.t2.setPriority(1);
        this.t2.start();
    }

    public Object showInputDialog(String title, Object[] midioutputs) {
        SelectMidiRunner selectMidiRunner = new SelectMidiRunner();
        selectMidiRunner.midioutputs = midioutputs;
        selectMidiRunner.title = title;
        try {
            SwingUtilities.invokeAndWait(selectMidiRunner);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return selectMidiRunner.ret;
    }

    class SelectMidiRunner
    implements Runnable {
        Object[] midioutputs;
        Object ret;
        String title;

        SelectMidiRunner() {
        }

        public void run() {
            this.ret = JOptionPane.showInputDialog(SoundFontTester.this, this.title, this.title, 1, null, this.midioutputs, this.midioutputs[0]);
        }
    }
}

