/*
 * Decompiled with CFR 0.152.
 */
package rasmus.util;

import java.util.ArrayList;

public class Chord {
    public static int MAXCHORDSIZE = 15;
    public int root = 0;
    public int level = 5;
    public String chord = "";
    public String suspense = "";
    public String extension = "";
    public int bass = -1;
    String chordstr;

    private void pattSeat(boolean rev, int[] pattern, int seat, int addv) {
        if (rev) {
            pattern[(seat + addv) % 12] = seat % 12;
        } else {
            pattern[seat % 12] = (seat + addv) % 12;
        }
    }

    private int extractNums(String str) {
        String sstr = "";
        int i = 0;
        while (i < str.length()) {
            char n = str.charAt(i);
            if (Character.isDigit(n)) {
                sstr = String.valueOf(sstr) + n;
            }
            ++i;
        }
        if (sstr.length() == 0) {
            return 0;
        }
        return Integer.parseInt(sstr);
    }

    private String extractChars(String str) {
        String sstr = "";
        int i = 0;
        while (i < str.length()) {
            char n = str.charAt(i);
            if (!Character.isDigit(n)) {
                sstr = String.valueOf(sstr) + n;
            }
            ++i;
        }
        return sstr;
    }

    private String compactChordForm(String chordform) {
        int ii;
        ArrayList<Integer> usedseats = new ArrayList<Integer>();
        ArrayList<String> seats = new ArrayList<String>();
        String grp = "";
        int i = chordform.length() - 1;
        while (i >= 0) {
            char n = chordform.charAt(i);
            if (n == ' ') {
                if (grp.length() != 0) {
                    ii = this.extractNums(grp);
                    if (ii == 2) {
                        ii = 3;
                        grp = String.valueOf(grp) + "BB";
                    }
                    if (ii == 4) {
                        ii = 3;
                        grp = String.valueOf(grp) + "#";
                    }
                    if (ii == 6) {
                        ii = 7;
                        grp = String.valueOf(grp) + "BB";
                    }
                    if (usedseats.indexOf(new Integer(ii)) == -1) {
                        usedseats.add(new Integer(ii));
                        seats.add(String.valueOf(ii) + this.extractChars(grp));
                    }
                    grp = "";
                }
            } else {
                grp = String.valueOf(n) + grp;
            }
            --i;
        }
        String result = "";
        int i2 = 1;
        while (i2 <= MAXCHORDSIZE) {
            ii = usedseats.indexOf(new Integer(i2));
            if (ii != -1) {
                result = String.valueOf(result) + seats.get(ii) + " ";
            }
            ++i2;
        }
        return result;
    }

    public String toString() {
        return this.toForm();
    }

    public String toForm() {
        String suspense = this.suspense;
        String chord = this.chord;
        if (suspense.equals("S9")) {
            suspense = "SUS9";
        }
        if (suspense.equals("S4")) {
            suspense = "SUS4";
        }
        if (suspense.equals("S2")) {
            suspense = "SUS2";
        }
        if (suspense.equals("SUS")) {
            suspense = "SUS4";
        }
        if (suspense.equals("SUS9")) {
            suspense = "SUS2";
        }
        if (suspense.equals("S")) {
            suspense = "SUS4";
        }
        if (chord.equals("-MAJ")) {
            chord = "MIN";
        }
        if (chord.equals("MMAJ")) {
            chord = "MIN";
        }
        if (chord.equals("O")) {
            chord = "DIM";
        }
        if (chord.equals("+")) {
            chord = "AUG";
        }
        if (chord.equals("-")) {
            chord = "M";
        }
        String result = "";
        if (this.level >= 1) {
            result = String.valueOf(result) + "1 ";
        }
        if (this.level >= 3) {
            result = String.valueOf(result) + "3 ";
        }
        if (this.level >= 5) {
            result = String.valueOf(result) + "5 ";
        }
        if (this.level >= 7) {
            result = String.valueOf(result) + "7B ";
        }
        if (this.level >= 9) {
            result = String.valueOf(result) + "9 ";
        }
        if (this.level >= 11) {
            result = String.valueOf(result) + "11 ";
        }
        if (this.level >= 13) {
            result = String.valueOf(result) + "13 ";
        }
        if (this.level == 2) {
            result = String.valueOf(result) + "3BB ";
        }
        if (this.level == 4) {
            result = String.valueOf(result) + "3# ";
        }
        if (this.level == 6) {
            result = String.valueOf(result) + "7BB ";
        }
        if (chord.equals("M") && this.level >= 3) {
            result = String.valueOf(result) + "3B ";
        }
        if (chord.equals("MIN")) {
            if (this.level >= 3) {
                result = String.valueOf(result) + "3B ";
            }
            if (this.level >= 7) {
                result = String.valueOf(result) + "7 ";
            }
        }
        if (chord.equals("MAJ") && this.level >= 7) {
            result = String.valueOf(result) + "7 ";
        }
        if (chord.equals("AUG") && this.level >= 5) {
            result = String.valueOf(result) + "5# ";
        }
        if (chord.equals("DIM")) {
            if (this.level >= 3) {
                result = String.valueOf(result) + "3B ";
            }
            if (this.level >= 5) {
                result = String.valueOf(result) + "5B ";
            }
            if (this.level >= 7) {
                result = String.valueOf(result) + "5BB ";
            }
        }
        if (suspense.equals("SUS4") && this.level >= 3) {
            result = String.valueOf(result) + "3# ";
        }
        if (suspense.equals("SUS2") && this.level >= 3) {
            result = String.valueOf(result) + "3BB ";
        }
        result = this.compactChordForm(String.valueOf(result) + this.extension);
        return result;
    }

    public int[] getTransform(boolean rev) {
        int[] result = new int[12];
        int i = 0;
        while (i < result.length) {
            result[i] = i;
            ++i;
        }
        String fext = this.toForm();
        String grp = "";
        int gaddv = 0;
        char[] chars = fext.toCharArray();
        int seat = 0;
        int tseat = 0;
        int i2 = 0;
        while (i2 < chars.length) {
            char n = chars[i2];
            if (n == ' ') {
                if (grp.length() != 0) {
                    try {
                        seat = Integer.parseInt(grp);
                    }
                    finally {
                        tseat = 0;
                    }
                }
            } else if (n == 'B') {
                --gaddv;
            } else if (n == '#') {
                ++gaddv;
            } else if (Character.isDigit(n)) {
                grp = String.valueOf(grp) + n;
            }
            ++i2;
        }
        return result;
    }

    private String workOutExtPart(String data) {
        int stat = 0;
        String result = "";
        int i = 0;
        while (i < data.length()) {
            char n = data.charAt(i);
            if (n == '-') {
                n = 'B';
            }
            if (n == '+') {
                n = '#';
            }
            if (stat > 0 && n == ' ') {
                stat = 0;
                result = String.valueOf(result) + ' ';
            }
            if (Character.isDigit(n)) {
                if (stat == 0) {
                    stat = 1;
                } else if (stat == 2) {
                    stat = 101;
                } else if (stat == 102) {
                    stat = 1;
                    result = String.valueOf(result) + ' ';
                }
                result = String.valueOf(result) + n;
            } else if (n == 'B' || n == '#') {
                if (stat == 0) {
                    stat = 2;
                } else if (stat == 1) {
                    stat = 102;
                } else if (stat == 102) {
                    stat = 2;
                    result = String.valueOf(result) + ' ';
                }
                result = String.valueOf(result) + n;
            }
            ++i;
        }
        return result;
    }

    private int parseNote(String note) {
        int basevalue = 0;
        int octave = 0;
        int i = 0;
        while (i < note.length()) {
            char ch = note.charAt(i);
            if (ch == 'C' || ch == 'c') {
                basevalue += 0;
            }
            if (ch == 'D' || ch == 'd') {
                basevalue += 2;
            }
            if (ch == 'E' || ch == 'e') {
                basevalue += 4;
            }
            if (ch == 'F' || ch == 'f') {
                basevalue += 5;
            }
            if (ch == 'G' || ch == 'g') {
                basevalue += 7;
            }
            if (ch == 'A' || ch == 'a') {
                basevalue += 9;
            }
            if (ch == 'B' || ch == 'b') {
                basevalue += 11;
            }
            if (ch == '#') {
                ++basevalue;
            }
            if (ch >= '0' && ch <= '9') {
                octave *= 10;
                if (ch == '0') {
                    octave += 0;
                }
                if (ch == '1') {
                    ++octave;
                }
                if (ch == '2') {
                    octave += 2;
                }
                if (ch == '3') {
                    octave += 3;
                }
                if (ch == '4') {
                    octave += 4;
                }
                if (ch == '5') {
                    octave += 5;
                }
                if (ch == '6') {
                    octave += 6;
                }
                if (ch == '7') {
                    octave += 7;
                }
                if (ch == '8') {
                    octave += 8;
                }
                if (ch == '9') {
                    octave += 9;
                }
            }
            ++i;
        }
        return basevalue + octave * 12;
    }

    public Chord(String chordstr) {
        this.chordstr = chordstr;
        chordstr = chordstr.toUpperCase();
        char[] chars = chordstr.toCharArray();
        int lasti = chars.length - 1;
        String rootnote = "";
        String bassstr = "";
        String strlevel = "";
        int level = 0;
        int i = 0;
        while (i < chars.length) {
            char n = chars[i];
            int m = i == lasti ? 32 : chars[i + 1];
            if (n != ')') {
                switch (level) {
                    case 0: {
                        rootnote = String.valueOf(rootnote) + n;
                        if (m == 35 || m == 66 || n != 'C' && n != 'D' && n != 'E' && n != 'F' && n != 'G' && n != 'A' && n != 'B' && n != '#') break;
                        this.root = this.parseNote(rootnote);
                        level = 1;
                        break;
                    }
                    case 1: {
                        if (n == '\\' || n == '/') {
                            level = 5;
                            break;
                        }
                        if (n == '(') {
                            level = 4;
                            break;
                        }
                        if (n == 'B' || n == '#') {
                            this.extension = String.valueOf(this.extension) + n;
                            level = 4;
                            break;
                        }
                        if (n == 'S') {
                            level = 3;
                            this.suspense = String.valueOf(this.suspense) + n;
                            level = 3;
                            break;
                        }
                        if (Character.isDigit(n)) {
                            level = 2;
                            strlevel = String.valueOf(strlevel) + strlevel + n;
                            break;
                        }
                        this.chord = String.valueOf(this.chord) + n;
                        break;
                    }
                    case 2: {
                        if (n == '\\' || n == '/') {
                            level = 5;
                            break;
                        }
                        if (n == '(') {
                            level = 4;
                            break;
                        }
                        if (n == 'B' || n == '#' || n == '+' || n == '-') {
                            this.extension = String.valueOf(this.extension) + n;
                            level = 4;
                            break;
                        }
                        if (!Character.isDigit(n)) {
                            level = 3;
                            this.suspense = String.valueOf(this.suspense) + this.suspense + n;
                            break;
                        }
                        try {
                            if (Integer.parseInt(String.valueOf(strlevel) + n) > MAXCHORDSIZE) {
                                this.extension = String.valueOf(this.extension) + n;
                                level = 4;
                                break;
                            }
                            strlevel = String.valueOf(strlevel) + n;
                        }
                        catch (Throwable e) {
                            System.out.println(e.toString());
                            strlevel = String.valueOf(strlevel) + n;
                        }
                        break;
                    }
                    case 3: {
                        if (n == '\\' || n == '/') {
                            level = 5;
                            break;
                        }
                        if (n == '(') {
                            level = 4;
                            break;
                        }
                        if (n == 'B' || n == '#' || n == '+' || n == '-') {
                            this.extension = String.valueOf(this.extension) + n;
                            level = 4;
                            break;
                        }
                        this.suspense = String.valueOf(this.suspense) + n;
                        break;
                    }
                    case 4: {
                        if (n == 'S') {
                            if (this.suspense.length() != 0) break;
                            this.suspense = String.valueOf(this.suspense) + n;
                            level = 3;
                            break;
                        }
                        if (!Character.isDigit(n) && n != 'B' && n != '#' && n != '+' && n != '-' && n != ' ') {
                            if (this.chord.length() != 0) break;
                            this.chord = String.valueOf(this.chord) + n;
                            level = 1;
                            break;
                        }
                        if (n == '\\' || n == '/') {
                            level = 5;
                            break;
                        }
                        this.extension = String.valueOf(this.extension) + n;
                        break;
                    }
                    case 5: {
                        if (n == '(') {
                            level = 4;
                            break;
                        }
                        bassstr = String.valueOf(bassstr) + n;
                        break;
                    }
                }
            }
            ++i;
        }
        this.extension = this.workOutExtPart(this.extension);
        try {
            this.level = Integer.parseInt(strlevel);
        }
        catch (Throwable e) {
            this.level = 5;
        }
        if (bassstr.length() != 0) {
            this.bass = this.parseNote(bassstr);
        }
        if (this.bass == -1) {
            this.bass = this.root % 12;
        }
    }
}

