/*
 * Decompiled with CFR 0.152.
 */
package rasmus.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import rasmus.util.ThreadQueueWorker;

public class NonBlockingReadableByteChannel
implements Runnable,
ReadableByteChannel {
    private int buffersize = 2048;
    private ByteBuffer currentbuffer = null;
    private ByteBuffer nextbuffer = null;
    private FileChannel filechannel = null;
    private RandomAccessFile raf = null;
    private File file = null;
    private volatile boolean reading = false;
    private boolean notinited = true;
    private ThreadQueueWorker tworker;
    private long filepos;

    public NonBlockingReadableByteChannel(NonBlockingReadableByteChannel channel) throws InterruptedException {
        if (channel.notinited) {
            System.out.println("File was not inited, wait for init !");
            while (channel.notinited) {
                Thread.sleep(10L);
            }
        }
        this.buffersize = channel.buffersize;
        this.file = channel.file;
        this.filepos = channel.filepos;
        this.tworker = channel.tworker;
        this.reading = false;
        this.notinited = false;
        this.currentbuffer = channel.currentbuffer.asReadOnlyBuffer();
        this.nextbuffer = channel.nextbuffer.asReadOnlyBuffer();
    }

    public NonBlockingReadableByteChannel(File file, long pos, int buffersize) throws Exception {
        this.buffersize = buffersize;
        this.currentbuffer = ByteBuffer.allocate(buffersize);
        this.nextbuffer = ByteBuffer.allocate(buffersize);
        this.file = file;
        this.filepos = pos;
        this.tworker = ThreadQueueWorker.getInstance();
        Runnable r = new Runnable(){

            public void run() {
                NonBlockingReadableByteChannel.this.currentbuffer.rewind();
                NonBlockingReadableByteChannel.this.nextbuffer.rewind();
                try {
                    NonBlockingReadableByteChannel.this.raf = new RandomAccessFile(NonBlockingReadableByteChannel.this.file, "r");
                    NonBlockingReadableByteChannel.this.filechannel = NonBlockingReadableByteChannel.this.raf.getChannel();
                    NonBlockingReadableByteChannel.this.filechannel.position(NonBlockingReadableByteChannel.this.filepos);
                    long ret = NonBlockingReadableByteChannel.this.filechannel.read(NonBlockingReadableByteChannel.this.currentbuffer);
                    NonBlockingReadableByteChannel nonBlockingReadableByteChannel = NonBlockingReadableByteChannel.this;
                    nonBlockingReadableByteChannel.filepos = nonBlockingReadableByteChannel.filepos + ret;
                    ret = NonBlockingReadableByteChannel.this.filechannel.read(NonBlockingReadableByteChannel.this.nextbuffer);
                    NonBlockingReadableByteChannel nonBlockingReadableByteChannel2 = NonBlockingReadableByteChannel.this;
                    nonBlockingReadableByteChannel2.filepos = nonBlockingReadableByteChannel2.filepos + ret;
                    NonBlockingReadableByteChannel.this.raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                NonBlockingReadableByteChannel.this.filechannel = null;
                NonBlockingReadableByteChannel.this.raf = null;
                NonBlockingReadableByteChannel.this.currentbuffer.rewind();
                NonBlockingReadableByteChannel.this.nextbuffer.rewind();
                NonBlockingReadableByteChannel.this.notinited = false;
            }
        };
        this.tworker.invokeLater(r);
    }

    public void run() {
        try {
            if (this.filechannel == null) {
                this.raf = new RandomAccessFile(this.file, "r");
                this.filechannel = this.raf.getChannel();
                this.filechannel.position(this.filepos);
                Thread.yield();
            }
            if (this.nextbuffer.isReadOnly()) {
                this.nextbuffer = ByteBuffer.allocate(this.buffersize);
            }
            this.nextbuffer.rewind();
            long ret = this.filechannel.read(this.nextbuffer);
            if (ret == -1L) {
                this.nextbuffer = null;
                this.reading = false;
                return;
            }
            this.nextbuffer.limit((int)ret);
            this.filepos += ret;
            this.nextbuffer.rewind();
            this.reading = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean nextBuffer() {
        if (this.reading) {
            System.out.println("File I/O UnderFlow !");
            while (this.reading) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        ByteBuffer nextbuffer2 = this.currentbuffer;
        this.currentbuffer = this.nextbuffer;
        this.nextbuffer = nextbuffer2;
        this.reading = true;
        this.tworker.invokeLater(this);
        return this.currentbuffer != null;
    }

    /*
     * Unable to fully structure code
     */
    public int read(ByteBuffer buffer) {
        if (this.notinited) {
            System.out.println("File was not inited, wait for init !");
            while (this.notinited) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
        }
        ret = 0;
        if (this.currentbuffer != null) ** GOTO lbl22
        return -1;
lbl-1000:
        // 1 sources

        {
            if (buffer.remaining() <= this.currentbuffer.remaining()) {
                this.currentbuffer.get(buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.remaining());
                return ret += buffer.remaining();
            }
            ret += this.currentbuffer.remaining();
            buffer.put(this.currentbuffer);
            if (this.nextBuffer()) continue;
            return ret;
lbl22:
            // 2 sources

            ** while (buffer.hasRemaining())
        }
lbl23:
        // 1 sources

        return ret;
    }

    public boolean isOpen() {
        return true;
    }

    public void close() throws IOException {
        Runnable r = new Runnable(){

            public void run() {
                if (NonBlockingReadableByteChannel.this.filechannel != null) {
                    try {
                        Thread.yield();
                        NonBlockingReadableByteChannel.this.raf.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    NonBlockingReadableByteChannel.this.filechannel = null;
                    NonBlockingReadableByteChannel.this.raf = null;
                }
            }
        };
        this.tworker.invokeLater(r);
    }
}

