/*
 * Decompiled with CFR 0.152.
 */
package rasmus.util.riff;

import java.io.IOException;
import java.io.InputStream;
import rasmus.util.riff.RiffReader;

public class ChunkReader
extends InputStream {
    protected long ckSize = 0L;
    private InputStream stream;
    protected long avail;
    RiffReader lastiterator = null;

    public long getSize() {
        return this.ckSize;
    }

    public ChunkReader(InputStream stream) throws IOException {
        this.stream = stream;
        this.avail = stream.available();
        this.ckSize = stream.available();
    }

    public boolean hasNextChunk() throws IOException {
        if (this.lastiterator != null) {
            this.lastiterator.finish();
        }
        return this.avail != 0L;
    }

    public RiffReader nextChunk() throws IOException {
        if (this.lastiterator != null) {
            this.lastiterator.finish();
        }
        if (this.avail == 0L) {
            return null;
        }
        this.lastiterator = new RiffReader(this);
        return this.lastiterator;
    }

    public int read() throws IOException {
        if (this.avail == 0L) {
            return -1;
        }
        --this.avail;
        return this.stream.read();
    }

    public int read(byte[] b) throws IOException {
        if (this.avail == 0L) {
            return -1;
        }
        if ((long)b.length > this.avail) {
            int len = this.stream.read(b, 0, (int)this.avail);
            this.avail = 0L;
            return len;
        }
        this.avail -= (long)b.length;
        return this.stream.read(b);
    }

    public long skip(long n) throws IOException {
        if (this.avail == 0L) {
            return -1L;
        }
        if (n > this.avail) {
            long len = this.stream.skip(this.avail);
            this.avail = 0L;
            return len;
        }
        this.avail -= n;
        return this.stream.skip(n);
    }

    public int available() {
        return (int)this.avail;
    }

    public void finish() throws IOException {
        if (this.avail != 0L) {
            this.stream.skip(this.avail);
            this.avail = 0L;
        }
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

