/*
 * Decompiled with CFR 0.152.
 */
package rasmus.util.riff;

import java.io.IOException;
import java.io.InputStream;
import rasmus.util.ByteConversion;
import rasmus.util.riff.ChunkReader;

public class RiffReader
extends ChunkReader {
    private String fourcc;
    private String riff_type = null;

    public String getFormat() {
        return this.fourcc;
    }

    public String getType() {
        return this.riff_type;
    }

    public RiffReader(InputStream stream) throws IOException {
        super(stream);
        byte[] fourcc = new byte[4];
        stream.read(fourcc);
        if (fourcc[0] == 0) {
            fourcc[0] = fourcc[1];
            fourcc[1] = fourcc[2];
            fourcc[2] = fourcc[3];
            stream.read(fourcc, 3, 1);
        }
        this.fourcc = new String(fourcc, "latin1");
        byte[] ckSize = new byte[4];
        stream.read(ckSize);
        this.avail = this.ckSize = ByteConversion.dwordToLong(ckSize);
        if (this.getFormat().equals("RIFF") || this.getFormat().equals("LIST")) {
            byte[] format = new byte[4];
            this.read(format);
            this.riff_type = new String(format, "latin1");
        }
    }
}

