/*
 * Decompiled with CFR 0.152.
 */
package rasmus.util.riff.dls;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import rasmus.util.ByteConversion;
import rasmus.util.riff.RiffReader;

public class Collection {
    Document doc;
    InputStreamCounter isc;
    int sampleid = 0;
    HashMap mapinfo = new HashMap();

    public Collection() {
        this.mapinfo.put("IARL", "archival_location");
        this.mapinfo.put("IART", "artist");
        this.mapinfo.put("ICMS", "commissioned");
        this.mapinfo.put("ICMT", "comments");
        this.mapinfo.put("ICOP", "copyright");
        this.mapinfo.put("ICRD", "creationdate");
        this.mapinfo.put("IENG", "engineers");
        this.mapinfo.put("IGNR", "genre");
        this.mapinfo.put("IKEY", "keywords");
        this.mapinfo.put("IMED", "medium");
        this.mapinfo.put("INAM", "name");
        this.mapinfo.put("IPRD", "product");
        this.mapinfo.put("ISBJ", "subject");
        this.mapinfo.put("ISFT", "software");
        this.mapinfo.put("ISRC", "source");
        this.mapinfo.put("ISRF", "source_form");
        this.mapinfo.put("ITCH", "technician");
    }

    /*
     * Unable to fully structure code
     */
    public void read(InputStream inputstream) throws Exception {
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        collection_element = this.doc.createElement("Collection");
        this.doc.appendChild(collection_element);
        this.isc = new InputStreamCounter(inputstream);
        riffiterator = new RiffReader(this.isc);
        if (riffiterator.getFormat().equals("RIFF")) ** GOTO lbl50
        throw new Exception("Incorrect format");
lbl-1000:
        // 1 sources

        {
            subchunk = riffiterator.nextChunk();
            System.out.println(String.valueOf(subchunk.getFormat()) + " : " + subchunk.getType());
            if (subchunk.getFormat().equals("LIST")) {
                if (subchunk.getType().equals("lins")) {
                    while (subchunk.hasNextChunk()) {
                        subsubchunk = subchunk.nextChunk();
                        if (!subsubchunk.getFormat().equals("LIST") || !subsubchunk.getType().equals("ins ")) continue;
                        instrument_element = this.doc.createElement("preset");
                        collection_element.appendChild(instrument_element);
                        this.readInstrument(subsubchunk, instrument_element);
                    }
                }
                if (subchunk.getType().equals("wvpl")) {
                    while (subchunk.hasNextChunk()) {
                        subsubchunk = subchunk.nextChunk();
                        if (!subsubchunk.getFormat().equals("LIST") || !subsubchunk.getType().equals("wave")) continue;
                        sample_element = this.doc.createElement("sample");
                        sample_element.setAttribute("id", "" + this.sampleid);
                        ++this.sampleid;
                        collection_element.appendChild(sample_element);
                        this.readWave(subsubchunk, sample_element);
                    }
                }
                if (!subchunk.getType().equals("INFO")) continue;
                this.readINFO(subchunk, collection_element);
                continue;
            }
            if (subchunk.getFormat().equals("colh")) {
                bword = new byte[4];
                subchunk.read(bword);
                collection_element.setAttribute("instrument_count", Long.toString(ByteConversion.dwordToLong(bword)));
            }
            subchunk.getFormat().equals("colh");
            if (!subchunk.getFormat().equals("vers")) continue;
            bword = new byte[4];
            subchunk.read(bword);
            collection_element.setAttribute("version_major", Long.toString(ByteConversion.dwordToLong(bword)));
            subchunk.read(bword);
            collection_element.setAttribute("version_minor", Long.toString(ByteConversion.dwordToLong(bword)));
lbl50:
            // 5 sources

            ** while (riffiterator.hasNextChunk())
        }
lbl51:
        // 1 sources

    }

    public void readINFO(RiffReader chunk, Element element) throws Exception {
        while (chunk.hasNextChunk()) {
            RiffReader subchunk = chunk.nextChunk();
            String format = subchunk.getFormat();
            String attrinfo = (String)this.mapinfo.get(format);
            if (attrinfo == null) continue;
            byte[] buffer = new byte[subchunk.available()];
            subchunk.read(buffer);
            element.setAttribute(attrinfo, ByteConversion.charToString(buffer));
        }
    }

    public void readInstrument(RiffReader chunk, Element element) throws Exception {
        while (chunk.hasNextChunk()) {
            RiffReader subchunk = chunk.nextChunk();
            if (subchunk.getFormat().equals("LIST")) {
                if (subchunk.getType().equals("lart")) {
                    this.readArticulators(subchunk, element);
                }
                if (subchunk.getType().equals("lrgn")) {
                    while (subchunk.hasNextChunk()) {
                        RiffReader subsubchunk = subchunk.nextChunk();
                        if (!subsubchunk.getFormat().equals("LIST") || !subsubchunk.getType().equals("rgn ")) continue;
                        Element region_element = this.doc.createElement("generator");
                        element.appendChild(region_element);
                        this.readRegion(subsubchunk, region_element);
                    }
                }
                if (!subchunk.getType().equals("INFO")) continue;
                this.readINFO(subchunk, element);
                continue;
            }
            if (subchunk.getFormat().equals("insh")) {
                byte[] bword = new byte[4];
                subchunk.read(bword);
                byte[] bbyte = new byte[1];
                subchunk.read(bbyte);
                int bank = ByteConversion.byteToInt(bbyte) * 128;
                subchunk.read(bbyte);
                subchunk.read(bbyte);
                subchunk.read(bbyte);
                element.setAttribute("bank", Integer.toString(bank += ByteConversion.byteToInt(bbyte)));
                if (bbyte[0] < 0) {
                    element.setAttribute("drumkit", "yes");
                }
                subchunk.read(bword);
                element.setAttribute("id", Long.toString(ByteConversion.dwordToLong(bword)));
            }
            if (!subchunk.getFormat().equals("dlid")) continue;
            byte[] buffer = new byte[16];
            subchunk.read(buffer);
            element.setAttribute("dlsid", ByteConversion.guidToString(buffer));
        }
    }

    public void readArticulators(RiffReader chunk, Element element) throws Exception {
        while (chunk.hasNextChunk()) {
            RiffReader subchunk = chunk.nextChunk();
            if (!subchunk.getFormat().equals("art1")) continue;
            byte[] sdata = new byte[2];
            byte[] ldata = new byte[4];
            int ret = 0;
            ret += subchunk.read(ldata);
            long size = ByteConversion.dwordToLong(ldata);
            long count = ByteConversion.dwordToLong(ldata);
            if (size - (long)(ret += subchunk.read(ldata)) != 0L) {
                subchunk.skip(size - (long)ret);
            }
            int i = 0;
            while ((long)i < count) {
                Element art = this.doc.createElement("Articulators");
                element.appendChild(art);
                chunk.read(sdata);
                art.setAttribute("source", "" + ByteConversion.shortToInt(sdata));
                chunk.read(sdata);
                art.setAttribute("control", "" + ByteConversion.shortToInt(sdata));
                chunk.read(sdata);
                art.setAttribute("destination", "" + ByteConversion.shortToInt(sdata));
                chunk.read(sdata);
                art.setAttribute("transform", "" + ByteConversion.shortToInt(sdata));
                chunk.read(ldata);
                art.setAttribute("scale", "" + (int)ByteConversion.dwordToLong(ldata));
                ++i;
            }
        }
    }

    public void readRegion(RiffReader chunk, Element element) throws Exception {
        while (chunk.hasNextChunk()) {
            byte[] ldata;
            byte[] sdata;
            RiffReader subchunk = chunk.nextChunk();
            if (subchunk.getFormat().equals("LIST")) {
                if (!subchunk.getType().equals("lart")) continue;
                this.readArticulators(subchunk, element);
                continue;
            }
            if (subchunk.getFormat().equals("wsmp")) {
                sdata = new byte[2];
                ldata = new byte[4];
                int ret = 0;
                ret += subchunk.read(ldata);
                long size = ByteConversion.dwordToLong(ldata);
                ret += subchunk.read(sdata);
                element.setAttribute("originalkey", "" + ByteConversion.shortToInt(sdata));
                ret += subchunk.read(sdata);
                element.setAttribute("finetune", "" + ByteConversion.shortToInt(sdata));
                ret += subchunk.read(ldata);
                element.setAttribute("attenuation", "" + (double)((int)ByteConversion.dwordToLong(ldata)) / 4.294967296E9);
                ret += subchunk.read(ldata);
                element.setAttribute("fuloptions", "" + ByteConversion.dwordToLong(ldata));
                long sampleloops = ByteConversion.dwordToLong(ldata);
                if (size > (long)(ret += subchunk.read(ldata))) {
                    byte[] buffer = new byte[(int)(size - (long)ret)];
                    subchunk.read(buffer);
                }
                if (sampleloops != 0L) {
                    ret = 0;
                    ret += subchunk.read(ldata);
                    size = ByteConversion.dwordToLong(ldata);
                    ret += subchunk.read(ldata);
                    element.setAttribute("looptype", "" + ByteConversion.dwordToLong(ldata));
                    ret += subchunk.read(ldata);
                    element.setAttribute("loopstart", "" + ByteConversion.dwordToLong(ldata));
                    ret += subchunk.read(ldata);
                    element.setAttribute("looplen", "" + ByteConversion.dwordToLong(ldata));
                }
            }
            if (subchunk.getFormat().equals("wlnk")) {
                sdata = new byte[2];
                subchunk.read(sdata);
                element.setAttribute("fusOptions", "" + ByteConversion.shortToInt(sdata));
                subchunk.read(sdata);
                element.setAttribute("phasegroup", "" + ByteConversion.shortToInt(sdata));
                ldata = new byte[4];
                subchunk.read(ldata);
                element.setAttribute("channel", "" + ByteConversion.dwordToLong(ldata));
                subchunk.read(ldata);
                element.setAttribute("sampleID", "" + ByteConversion.dwordToLong(ldata));
            }
            if (!subchunk.getFormat().equals("rgnh")) continue;
            sdata = new byte[2];
            subchunk.read(sdata);
            int keyfrom = ByteConversion.shortToInt(sdata);
            subchunk.read(sdata);
            int keyto = ByteConversion.shortToInt(sdata);
            element.setAttribute("keyRange", String.valueOf(keyfrom) + " - " + keyto);
            int velfrom = ByteConversion.shortToInt(sdata);
            subchunk.read(sdata);
            int velto = ByteConversion.shortToInt(sdata);
            element.setAttribute("velRange", String.valueOf(velfrom) + " - " + velto);
            subchunk.read(sdata);
            element.setAttribute("options", "" + ByteConversion.shortToInt(sdata));
            subchunk.read(sdata);
            int keygroup = ByteConversion.shortToInt(sdata);
            if (keygroup == 0) continue;
            element.setAttribute("exclusiveClass", "" + keygroup);
        }
    }

    public void readWave(RiffReader chunk, Element element) throws Exception {
        while (chunk.hasNextChunk()) {
            RiffReader subchunk = chunk.nextChunk();
            if (subchunk.getFormat().equals("LIST")) {
                if (!subchunk.getType().equals("INFO")) continue;
                this.readINFO(subchunk, element);
                continue;
            }
            if (subchunk.getFormat().equals("fmt ")) {
                byte[] sdata = new byte[2];
                byte[] ldata = new byte[4];
                subchunk.read(sdata);
                int format = ByteConversion.shortToInt(sdata);
                if (format != 1) {
                    element.setAttribute("format", "" + format);
                }
                subchunk.read(sdata);
                element.setAttribute("channels", "" + ByteConversion.shortToInt(sdata));
                subchunk.read(ldata);
                element.setAttribute("samplerate", "" + ByteConversion.dwordToLong(ldata));
                subchunk.read(ldata);
                element.setAttribute("framrate", "" + ByteConversion.dwordToLong(ldata));
                subchunk.read(sdata);
                element.setAttribute("framesize", "" + ByteConversion.shortToInt(sdata));
                subchunk.read(sdata);
                element.setAttribute("bits", "" + ByteConversion.shortToInt(sdata));
            }
            if (subchunk.getFormat().equals("data")) {
                element.setAttribute("start", "" + this.isc.pos);
                element.setAttribute("length", "" + subchunk.available());
            }
            if (!subchunk.getFormat().equals("dlid")) continue;
            byte[] buffer = new byte[16];
            subchunk.read(buffer);
            element.setAttribute("dlsid", ByteConversion.guidToString(buffer));
        }
    }

    public static void main(String[] args) throws Exception {
        Collection coll = new Collection();
        FileInputStream fis = new FileInputStream("C:\\realmaker2005\\SoundFonts\\PersonalCopy\\gm.dls");
        coll.read(fis);
        fis.close();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer();
            FileOutputStream fo = new FileOutputStream("C:\\gm.xml");
            transformer.transform(new DOMSource(coll.doc), new StreamResult(fo));
            fo.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class InputStreamCounter
    extends InputStream {
        InputStream inputstream;
        long pos = 0L;

        public long getPosition() {
            return this.pos;
        }

        public InputStreamCounter(InputStream inputstream) {
            this.inputstream = inputstream;
        }

        public int read() throws IOException {
            int len = this.inputstream.read();
            if (len != -1) {
                ++this.pos;
            }
            return len;
        }

        public int available() throws IOException {
            return this.inputstream.available();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int readed = this.inputstream.read(b, off, len);
            if (readed > 0) {
                this.pos += (long)readed;
            }
            return readed;
        }

        public int read(byte[] b) throws IOException {
            int readed = this.inputstream.read(b);
            if (readed > 0) {
                this.pos += (long)readed;
            }
            return readed;
        }

        public long skip(long n) throws IOException {
            long readed = this.inputstream.skip(n);
            if (readed > 0L) {
                this.pos += readed;
            }
            return readed;
        }
    }
}

