/*
 * Decompiled with CFR 0.152.
 */
package rasmus.wavefloat;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import rasmus.util.ByteConversion;
import rasmus.util.riff.RiffReader;
import rasmus.wavefloat.FloatEncoding;

public class WaveFloatFileReader
extends AudioFileReader {
    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat format;
        stream.mark(200);
        try {
            format = this.internal_getAudioFileFormat(stream);
        }
        finally {
            stream.reset();
        }
        return format;
    }

    private AudioFileFormat internal_getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        RiffReader riffiterator = new RiffReader(stream);
        if (!riffiterator.getFormat().equals("RIFF")) {
            throw new UnsupportedAudioFileException();
        }
        if (!riffiterator.getType().equals("WAVE")) {
            throw new UnsupportedAudioFileException();
        }
        boolean fmt_found = false;
        boolean data_found = false;
        int channels = 1;
        long samplerate = 1L;
        long framerate = 1L;
        int framesize = 1;
        int bits = 1;
        while (riffiterator.hasNextChunk()) {
            RiffReader chunk = riffiterator.nextChunk();
            if (chunk.getFormat().equals("fmt ")) {
                fmt_found = true;
                byte[] sdata = new byte[2];
                byte[] ldata = new byte[4];
                chunk.read(sdata);
                int format = ByteConversion.shortToInt(sdata);
                if (format != 3) {
                    throw new UnsupportedAudioFileException();
                }
                chunk.read(sdata);
                channels = ByteConversion.shortToInt(sdata);
                chunk.read(ldata);
                samplerate = ByteConversion.dwordToLong(ldata);
                chunk.read(ldata);
                framerate = ByteConversion.dwordToLong(ldata);
                chunk.read(sdata);
                framesize = ByteConversion.shortToInt(sdata);
                chunk.read(sdata);
                bits = ByteConversion.shortToInt(sdata);
            }
            if (!chunk.getFormat().equals("data")) continue;
            data_found = true;
            break;
        }
        if (!fmt_found) {
            throw new UnsupportedAudioFileException();
        }
        if (!data_found) {
            throw new UnsupportedAudioFileException();
        }
        AudioFormat audioformat = new AudioFormat(FloatEncoding.PCM_FLOAT, samplerate, bits, channels, framesize, framerate, false);
        AudioFileFormat fileformat = new AudioFileFormat(AudioFileFormat.Type.WAVE, audioformat, -1);
        return fileformat;
    }

    /*
     * Unable to fully structure code
     */
    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        format = this.getAudioFileFormat(stream);
        riffiterator = new RiffReader(stream);
        if (!riffiterator.getFormat().equals("RIFF")) {
            throw new UnsupportedAudioFileException();
        }
        if (riffiterator.getType().equals("WAVE")) ** GOTO lbl10
        throw new UnsupportedAudioFileException();
lbl-1000:
        // 1 sources

        {
            chunk = riffiterator.nextChunk();
            if (!chunk.getFormat().equals("data")) continue;
            return new AudioInputStream(chunk, format.getFormat(), chunk.getSize());
lbl10:
            // 2 sources

            ** while (riffiterator.hasNextChunk())
        }
lbl11:
        // 1 sources

        throw new UnsupportedAudioFileException();
    }

    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat format;
        InputStream stream = url.openStream();
        try {
            format = this.getAudioFileFormat(new BufferedInputStream(stream));
        }
        finally {
            stream.close();
        }
        return format;
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat format;
        FileInputStream stream = new FileInputStream(file);
        try {
            format = this.getAudioFileFormat(new BufferedInputStream(stream));
        }
        finally {
            ((InputStream)stream).close();
        }
        return format;
    }

    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(new BufferedInputStream(url.openStream()));
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(new BufferedInputStream(new FileInputStream(file)));
    }
}

