/*
 * Decompiled with CFR 0.152.
 */
package uk.co.drpj.feature;

public class Complex {
    double re;
    double im;

    public Complex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public Complex(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public Complex(double re) {
        this.re = re;
        this.im = 0.0;
    }

    public Complex(Complex c) {
        this.re = c.re;
        this.im = c.im;
    }

    public double abs() {
        double rmod = Math.abs(this.re);
        double imod = Math.abs(this.im);
        double ratio = 0.0;
        double ret = 0.0;
        if (rmod == 0.0) {
            ret = imod;
        } else {
            if (imod == 0.0) {
                ret = rmod;
            }
            if (rmod >= imod) {
                ratio = this.im / this.re;
                ret = rmod * Math.sqrt(1.0 + ratio * ratio);
            } else {
                ratio = this.re / this.im;
                ret = imod * Math.sqrt(1.0 + ratio * ratio);
            }
        }
        return ret;
    }

    public static Complex exp(Complex aa) {
        Complex z = new Complex();
        double a = aa.re;
        double b = aa.im;
        if (b == 0.0) {
            z.re = Math.exp(a);
            z.im = 0.0;
        } else if (a == 0.0) {
            z.re = Math.cos(b);
            z.im = Math.sin(b);
        } else {
            double c = Math.exp(a);
            z.re = c * Math.cos(b);
            z.im = c * Math.sin(b);
        }
        return z;
    }

    public static Complex exp(double aa) {
        Complex bb = new Complex(aa, 0.0);
        return Complex.exp(bb);
    }

    public static Complex expPlusJayArg(double arg) {
        Complex argc = new Complex(0.0, arg);
        return Complex.exp(argc);
    }

    public static Complex expMinusJayArg(double arg) {
        Complex argc = new Complex(0.0, -arg);
        return Complex.exp(argc);
    }

    public static Complex log(Complex aa) {
        double a = aa.re;
        double b = aa.im;
        Complex c = new Complex();
        c.re = Math.log(Complex.abs(aa));
        c.im = Math.atan2(b, a);
        return c;
    }

    public static double abs(Complex a) {
        double rmod = Math.abs(a.re);
        double imod = Math.abs(a.im);
        double ratio = 0.0;
        double res = 0.0;
        if (rmod == 0.0) {
            res = imod;
        } else {
            if (imod == 0.0) {
                res = rmod;
            }
            if (rmod >= imod) {
                ratio = a.im / a.re;
                res = rmod * Math.sqrt(1.0 + ratio * ratio);
            } else {
                ratio = a.re / a.im;
                res = imod * Math.sqrt(1.0 + ratio * ratio);
            }
        }
        return res;
    }
}

