/*
 * Decompiled with CFR 0.152.
 */
package uk.co.drpj.feature;

import uk.co.drpj.feature.Complex;

public class ComplexSpeedTest {
    static int N = 1000;
    static int M = 10000;
    double[] xr = new double[N];
    double[] xi = new double[N];
    double[] xd = new double[2 * N];
    Complex[] x = new Complex[N];

    ComplexSpeedTest() {
        Complex xx = Complex.expMinusJayArg(1.0E-4);
        int i = 0;
        while (i < N) {
            this.x[i] = new Complex(xx);
            this.xr[i] = xx.re;
            this.xi[i] = xx.im;
            this.xd[2 * i] = xx.re;
            this.xd[2 * i + 1] = xx.im;
            ++i;
        }
    }

    void doC() {
        Complex tt = new Complex(1.0);
        int i = 0;
        while (i < N) {
            int j = 0;
            while (j < M) {
                tt.re = tt.re * this.x[i].re - tt.im * this.x[i].im;
                tt.im = tt.im * this.x[i].re + tt.re * this.x[i].im;
                ++j;
            }
            ++i;
        }
    }

    void doR() {
        double tr = 1.0;
        double ti = 0.0;
        int i = 0;
        while (i < N) {
            int j = 0;
            while (j < M) {
                tr = tr * this.xr[i] - ti * this.xi[i];
                ti = ti * this.xr[i] + tr * this.xi[i];
                ++j;
            }
            ++i;
        }
    }

    void doD() {
        double tr = 1.0;
        double ti = 0.0;
        int i = 0;
        while (i < N) {
            int j = 0;
            while (j < M) {
                tr = tr * this.xd[2 * i] - ti * this.xd[2 * i + 1];
                ti = ti * this.xd[2 * i] + tr * this.xd[2 * i + 1];
                ++j;
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        ComplexSpeedTest t = new ComplexSpeedTest();
        long t1 = System.nanoTime();
        t.doC();
        long t2 = System.nanoTime();
        System.out.println(t2 - t1);
        t1 = System.nanoTime();
        t.doR();
        t2 = System.nanoTime();
        System.out.println(t2 - t1);
        t1 = System.nanoTime();
        t.doD();
        t2 = System.nanoTime();
        System.out.println(t2 - t1);
    }
}

