/*
 * Decompiled with CFR 0.152.
 */
package uk.co.drpj.interpreter.controls.sampled;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Map;
import rasmus.interpreter.Variable;
import rasmus.interpreter.controls.sampled.AudioAbstractGraphAnalyzer;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import uk.co.drpj.interpreter.sampled.util.FFTConstantQ;

class AudioCQSpectrumGraphInstance
extends AudioAbstractGraphAnalyzer {
    Variable input;
    Variable timebase;
    Variable samplerate;
    Variable channels;
    Variable binsPerOctave;
    Variable threshold;
    Variable key;
    Variable mindB;
    Variable maxdB;
    Variable minHz;
    Variable maxHz;
    Variable spread;

    public AudioCQSpectrumGraphInstance(Map parameters) {
        super(parameters);
        this.timebase = (Variable)parameters.get("timebase");
        this.input = (Variable)parameters.get("input");
        this.samplerate = (Variable)parameters.get("samplerate");
        this.channels = (Variable)parameters.get("channels");
        this.binsPerOctave = (Variable)parameters.get("binsperoctave");
        this.threshold = (Variable)parameters.get("threshold");
        this.mindB = (Variable)parameters.get("mindb");
        this.maxdB = (Variable)parameters.get("maxdb");
        this.minHz = (Variable)parameters.get("minhz");
        this.maxHz = (Variable)parameters.get("maxhz");
        this.spread = (Variable)parameters.get("spread");
        this.key = (Variable)parameters.get("key");
        Dimension size = new Dimension(300, 300);
        this.getJComponent().setPreferredSize(size);
        this.init();
    }

    public void run() {
        if (this.input == null) {
            return;
        }
        super.run();
        double samplerate = 44100.0;
        int channels = 1;
        double timebase = 0.1;
        int binsPerOctave = 12;
        double mindB = -180.0;
        double maxdB = 0.0;
        double minHz = 100.0;
        double maxHz = samplerate / 2.0;
        double threshold = 0.001;
        double spread = 1.0;
        int key = 0;
        if (this.samplerate != null) {
            samplerate = DoublePart.asDouble(this.samplerate);
        }
        if (this.channels != null) {
            channels = (int)DoublePart.asDouble(this.channels);
        }
        if (this.timebase != null) {
            timebase = DoublePart.asDouble(this.timebase);
        }
        if (this.binsPerOctave != null) {
            binsPerOctave = (int)DoublePart.asDouble(this.binsPerOctave);
        }
        if (this.threshold != null) {
            threshold = DoublePart.asDouble(this.threshold);
        }
        if (this.mindB != null) {
            mindB = DoublePart.asDouble(this.mindB);
        }
        if (this.maxdB != null) {
            maxdB = DoublePart.asDouble(this.maxdB);
        }
        if (this.minHz != null) {
            minHz = DoublePart.asDouble(this.minHz);
        }
        if (this.maxHz != null) {
            maxHz = DoublePart.asDouble(this.maxHz);
        }
        if (this.spread != null) {
            spread = DoublePart.asDouble(this.spread);
        }
        if (this.key != null) {
            key = (int)DoublePart.asDouble(this.key);
        }
        double rangedB = maxdB - mindB;
        Graphics2D g = this.getGraphics();
        g.setColor(Color.BLACK);
        Dimension size = this.getSize();
        int w = size.width;
        int h = size.height;
        g.fillRect(0, 0, w, h);
        g.setColor(Color.CYAN);
        g.drawString("Calculating Constant Q Kernel", 20, 20);
        this.repaint();
        FFTConstantQ fftcq = new FFTConstantQ(samplerate, minHz, maxHz, binsPerOctave, threshold, spread, key);
        Graphics2D g2 = this.getGraphics();
        Dimension size2 = this.getSize();
        int w2 = size2.width;
        int h2 = size2.height;
        g2.setColor(Color.BLACK);
        g2.fillRect(0, 0, w2, h2);
        this.repaint();
        int fftframesize = fftcq.getFFTSize();
        int outputbins = fftcq.getNumberOfOutputBands();
        int outputbins2 = outputbins * 2;
        int fftframesizec = fftframesize * channels;
        int monitorsamples = (int)(samplerate * timebase);
        int monitorsamplesc = monitorsamples * channels;
        System.out.println("monitorsample=" + monitorsamples + "fftframesize " + fftframesize);
        AudioSession audiosession = new AudioSession(samplerate, channels);
        AudioStream audiostream = AudioEvents.openStream(this.input, audiosession);
        double[][] fftbuffer = new double[channels][];
        double[][] fftoutbuffer = new double[channels][];
        double[][] graphbuffer = new double[channels][];
        int c = 0;
        while (c < channels) {
            fftbuffer[c] = new double[fftframesize];
            fftoutbuffer[c] = new double[outputbins2];
            graphbuffer[c] = new double[outputbins];
            ++c;
        }
        double[] window = fftcq.getFFT().wHanning();
        int bufferlen = monitorsamplesc;
        if (bufferlen < fftframesizec) {
            bufferlen = fftframesizec;
        }
        double[] buffer = new double[bufferlen];
        while (this.isActive()) {
            int i;
            int i2 = 0;
            while (i2 < bufferlen - monitorsamplesc) {
                buffer[i2] = buffer[i2 + monitorsamplesc];
                ++i2;
            }
            int len = audiostream.replace(buffer, bufferlen - monitorsamplesc, bufferlen);
            if (len == -1) break;
            Arrays.fill(buffer, bufferlen - monitorsamplesc + len, bufferlen, 0.0);
            int c2 = 0;
            while (c2 < channels) {
                double[] fftbuff = fftbuffer[c2];
                double[] fftbuffout = fftoutbuffer[c2];
                int ci = c2;
                i = 0;
                while (i < fftframesize) {
                    fftbuff[i] = buffer[ci];
                    ci += channels;
                    ++i;
                }
                fftcq.calc(fftbuff, fftbuffout);
                ++c2;
            }
            c2 = 0;
            while (c2 < channels) {
                double[] fftbuffout = fftoutbuffer[c2];
                double[] gbuffer = graphbuffer[c2];
                int x = 0;
                i = 0;
                while (i < outputbins2) {
                    double logman;
                    double real = fftbuffout[i++];
                    double imag = fftbuffout[i++];
                    double magn = 4.0 * Math.sqrt(real * real + imag * imag);
                    gbuffer[x] = logman = (Math.log10(magn) * 20.0 - mindB) / rangedB;
                    ++x;
                }
                ++c2;
            }
            this.paint(graphbuffer);
        }
        audiostream.close();
        audiosession.close();
    }
}

