/*
 * Decompiled with CFR 0.152.
 */
package uk.co.drpj.interpreter.controls.sampled;

import java.awt.Dimension;
import java.util.Map;
import rasmus.interpreter.Variable;
import rasmus.interpreter.controls.sampled.AudioAbstractGraphAnalyzer;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import uk.co.drpj.feature.CQFilter;

class CQFilterBankGraphInstance
extends AudioAbstractGraphAnalyzer {
    Variable input;
    Variable timebase;
    Variable samplerate;
    Variable channels;
    Variable chunksize;
    Variable binsperoctave;
    Variable nOctave;
    Variable Q;
    Variable mindB;
    Variable maxdB;
    Variable minHz;

    public CQFilterBankGraphInstance(Map parameters) {
        super(parameters);
        this.timebase = (Variable)parameters.get("timebase");
        this.input = (Variable)parameters.get("input");
        this.samplerate = (Variable)parameters.get("samplerate");
        this.channels = (Variable)parameters.get("channels");
        this.chunksize = (Variable)parameters.get("chunksize");
        this.binsperoctave = (Variable)parameters.get("binsperoctave");
        Dimension size = new Dimension(300, 300);
        this.getJComponent().setPreferredSize(size);
        this.init();
    }

    public void run() {
        if (this.input == null) {
            return;
        }
        super.run();
        double samplerate = 44100.0;
        int channels = 1;
        int chunksize = 1024;
        int binsPerOctave = 12;
        int nOctave = 7;
        double minHz = 50.0;
        double Q = 60.0;
        double mindB = -180.0;
        double maxdB = 0.0;
        if (this.samplerate != null) {
            samplerate = DoublePart.asDouble(this.samplerate);
        }
        if (this.channels != null) {
            channels = (int)DoublePart.asDouble(this.channels);
        }
        if (this.chunksize != null) {
            chunksize = (int)DoublePart.asDouble(this.chunksize);
        }
        if (this.binsperoctave != null) {
            chunksize = (int)DoublePart.asDouble(this.binsperoctave);
        }
        if (this.minHz != null) {
            chunksize = (int)DoublePart.asDouble(this.minHz);
        }
        if (this.Q != null) {
            Q = (int)DoublePart.asDouble(this.Q);
        }
        if (this.nOctave != null) {
            nOctave = (int)DoublePart.asDouble(this.nOctave);
        }
        if (this.mindB != null) {
            mindB = DoublePart.asDouble(this.mindB);
        }
        if (this.maxdB != null) {
            maxdB = DoublePart.asDouble(this.maxdB);
        }
        double rangedB = maxdB - mindB;
        AudioSession audiosession = new AudioSession(samplerate, channels);
        AudioStream audiostream = AudioEvents.openStream(this.input, audiosession);
        int nBins = 7 * binsPerOctave;
        CQFilter[] filt = new CQFilter[channels];
        double[][] graphbuffer = new double[channels][];
        int c = 0;
        while (c < channels) {
            filt[c] = new CQFilter(minHz, binsPerOctave, nBins, Q, samplerate);
            graphbuffer[c] = new double[nBins];
            ++c;
        }
        int bufferlen = chunksize * channels;
        double[] bufferc = new double[bufferlen];
        double[] buffer = new double[chunksize];
        while (this.isActive()) {
            int i;
            int len = audiostream.replace(bufferc, 0, bufferlen);
            if (len == -1) break;
            assert (len == bufferlen);
            int c2 = 0;
            while (c2 < channels) {
                int ic = c2;
                i = 0;
                while (i < chunksize) {
                    buffer[i] = bufferc[ic];
                    ++i;
                    ic += channels;
                }
                filt[c2].feed(buffer, chunksize);
                ++c2;
            }
            c2 = 0;
            while (c2 < channels) {
                double[] gbuffer = graphbuffer[c2];
                filt[c2].getMagnitude(gbuffer);
                i = 0;
                while (i < nBins) {
                    double logman;
                    gbuffer[i] = logman = (Math.log10(gbuffer[i]) * 20.0 - mindB) / rangedB;
                    ++i;
                }
                ++c2;
            }
            this.paint(graphbuffer);
        }
        audiostream.close();
        audiosession.close();
    }
}

