/*
 * Decompiled with CFR 0.152.
 */
package uk.co.drpj.interpreter.sampled.generators;

import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioImpulseInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable period;
    Variable answer = new Variable();
    private int periodVal = 44100;

    public void calc() {
    }

    public AudioImpulseInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.period = parameters.getParameterWithDefault(1, "period");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        if (this.period != null) {
            this.periodVal = (int)DoublePart.asDouble(this.period);
        }
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        long countval = 0L;
        int channels;

        public FilterStreamInstance(AudioSession session) {
            this.channels = session.getChannels();
        }

        public int mix(double[] buffer, int start, int end) {
            int chs = this.channels;
            int c = 0;
            while (c < chs) {
                long ccountval = this.countval;
                int i = start + c;
                while (i < end) {
                    if (ccountval % (long)AudioImpulseInstance.this.periodVal == 0L) {
                        int n = i;
                        buffer[n] = buffer[n] + 1.0;
                    }
                    ++ccountval;
                    i += chs;
                }
                ++c;
            }
            this.countval += (long)(end - start);
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            int chs = this.channels;
            int c = 0;
            while (c < chs) {
                long ccountval = this.countval;
                int i = start + c;
                while (i < end) {
                    buffer[i] = ccountval % (long)AudioImpulseInstance.this.periodVal == 0L ? (double)ccountval : 0.0;
                    ++ccountval;
                    i += chs;
                }
                ++c;
            }
            this.countval += (long)(end - start);
            return end - start;
        }

        public int skip(int len) {
            return len;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
        }
    }
}

