/*
 * Decompiled with CFR 0.152.
 */
package uk.co.drpj.interpreter.sampled.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import rasmus.interpreter.sampled.util.FFT;

public class FFTConstantQ {
    double q;
    int k;
    int fftlen;
    double[] freqs;
    double[][] qKernel;
    int[][] qKernel_indexes;
    FFT fft;
    File file = null;
    double sampleRate = 44100.0;
    double minFreq = 100.0;
    double maxFreq = 3000.0;
    double binsPerOctave = 12.0;
    double threshold = 0.001;
    double spread = 1.0;
    String kernelsident;
    private int key = 0;

    public FFT getFFT() {
        return this.fft;
    }

    public int getFFTSize() {
        return this.fftlen;
    }

    public int getNumberOfOutputBands() {
        return this.k;
    }

    public FFTConstantQ(double sampleRate, double minFreq, double maxFreq, double binsPerOctave) {
        this.sampleRate = sampleRate;
        this.minFreq = minFreq;
        this.maxFreq = maxFreq;
        this.binsPerOctave = binsPerOctave;
        this.init();
    }

    public FFTConstantQ(double sampleRate, double minFreq, double maxFreq, double binsPerOctave, double threshold, double spread, int key) {
        this.sampleRate = sampleRate;
        this.minFreq = minFreq;
        this.maxFreq = maxFreq;
        this.binsPerOctave = binsPerOctave;
        this.threshold = threshold;
        this.spread = spread;
        this.key = key;
        this.init();
    }

    public FFTConstantQ(double sampleRate, double minFreq, double maxFreq, double binsPerOctave, File file) {
        this.sampleRate = sampleRate;
        this.minFreq = minFreq;
        this.maxFreq = maxFreq;
        this.binsPerOctave = binsPerOctave;
        this.file = file;
        this.init();
    }

    private void init() {
        System.out.println("Spread = " + this.spread + " Key:" + this.key);
        this.q = 1.0 / (Math.pow(2.0, 1.0 / this.binsPerOctave) - 1.0) / this.spread;
        this.k = (int)Math.ceil(this.binsPerOctave * Math.log(this.maxFreq / this.minFreq) / Math.log(2.0));
        double calc_fftlen = Math.ceil(this.q * this.sampleRate / this.minFreq);
        this.fftlen = (int)Math.pow(2.0, Math.ceil(Math.log(calc_fftlen) / Math.log(2.0)));
        this.fft = new FFT(this.fftlen);
        this.qKernel = new double[this.k][];
        this.qKernel_indexes = new int[this.k][];
        this.freqs = new double[this.k];
        this.kernelsident = "R" + this.sampleRate + "S" + this.minFreq + "_E" + this.maxFreq + "_B" + this.binsPerOctave + "_T" + this.threshold + ".fftqkernels";
        if (this.file != null && this.file.exists()) {
            try {
                FileInputStream is = new FileInputStream(this.file);
                try {
                    this.readKernels(is);
                }
                finally {
                    ((InputStream)is).close();
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        double[] temp = new double[this.fftlen * 2];
        double[] ctemp = new double[this.fftlen * 2];
        int[] cindexes = new int[this.fftlen];
        int i = 0;
        while (i < this.k) {
            int i1;
            int j;
            double[] sKernel = temp;
            this.freqs[i] = this.minFreq * Math.pow(2.0, (double)i / this.binsPerOctave);
            double len = this.key == 0 ? Math.ceil(this.q * this.sampleRate / this.freqs[i]) : this.q * this.sampleRate / this.freqs[i];
            int j2 = 0;
            while (j2 < this.fftlen / 2) {
                double aa = this.key != 3 ? ((double)j2 + 0.5) / len : (double)j2 / len;
                if (aa < 0.5) {
                    double a = Math.PI * 2 * aa;
                    double window = 0.5 * (1.0 + Math.cos(a));
                    double x = this.key == 0 ? Math.PI * 2 * this.q * ((double)j2 + 0.5) / len : (this.key == 1 ? Math.PI * 2 * this.freqs[i] * ((double)j2 + 0.5) / this.sampleRate : Math.PI * 2 * this.freqs[i] * (double)j2 / this.sampleRate);
                    sKernel[this.fftlen + j2 * 2] = (window /= len) * Math.cos(x);
                    sKernel[this.fftlen + j2 * 2 + 1] = window * Math.sin(x);
                } else {
                    sKernel[this.fftlen + j2 * 2] = 0.0;
                    sKernel[this.fftlen + j2 * 2 + 1] = 0.0;
                }
                ++j2;
            }
            int halfway = this.fftlen / 2;
            if (this.key != 3) {
                j = 0;
                while (j < halfway) {
                    i1 = halfway - j - 1;
                    int i2 = halfway + j;
                    sKernel[i1 * 2] = sKernel[2 * i2];
                    sKernel[i1 * 2 + 1] = -sKernel[2 * i2 + 1];
                    ++j;
                }
            } else {
                j = 1;
                while (j < halfway) {
                    i1 = halfway - j;
                    int i2 = halfway + j;
                    sKernel[i1 * 2] = sKernel[2 * i2];
                    sKernel[i1 * 2 + 1] = -sKernel[2 * i2 + 1];
                    ++j;
                }
                sKernel[0] = 0.0;
                sKernel[1] = 0.0;
            }
            this.fft.calc(sKernel, -1);
            double[] cKernel = ctemp;
            int k = 0;
            int j3 = 0;
            int j22 = sKernel.length - 2;
            while (j3 < sKernel.length / 2) {
                double absval = Math.sqrt(sKernel[j3] * sKernel[j3] + sKernel[j3 + 1] * sKernel[j3 + 1]);
                if ((absval += Math.sqrt(sKernel[j22] * sKernel[j22] + sKernel[j22 + 1] * sKernel[j22 + 1])) > this.threshold) {
                    cindexes[k] = j3;
                    cKernel[2 * k] = sKernel[j3] + sKernel[j22];
                    cKernel[2 * k + 1] = sKernel[j3 + 1] + sKernel[j22 + 1];
                    ++k;
                }
                j3 += 2;
                j22 -= 2;
            }
            sKernel = new double[k * 2];
            int[] indexes = new int[k];
            int j4 = 0;
            while (j4 < k * 2) {
                sKernel[j4] = cKernel[j4];
                ++j4;
            }
            j4 = 0;
            while (j4 < k) {
                indexes[j4] = cindexes[j4];
                ++j4;
            }
            j4 = 0;
            while (j4 < sKernel.length) {
                int n = j4++;
                sKernel[n] = sKernel[n] / (double)this.fftlen;
            }
            j4 = 0;
            while (j4 < sKernel.length) {
                sKernel[j4] = -sKernel[j4];
                j4 += 2;
            }
            this.qKernel_indexes[i] = indexes;
            this.qKernel[i] = sKernel;
            ++i;
        }
    }

    public void readKernels(InputStream is) throws IOException {
        int i = 0;
        while (i < this.k) {
            ByteBuffer kbuffer = ByteBuffer.allocate(4);
            is.read(kbuffer.array(), kbuffer.arrayOffset(), kbuffer.capacity());
            kbuffer.position(0);
            int len = kbuffer.getInt();
            this.qKernel_indexes[i] = new int[len];
            this.qKernel[i] = new double[len * 2];
            ByteBuffer kernbuffer = ByteBuffer.allocate(len * 8 * 2);
            ByteBuffer indxbuffer = ByteBuffer.allocate(len * 4);
            is.read(kernbuffer.array(), kernbuffer.arrayOffset(), kernbuffer.capacity());
            is.read(indxbuffer.array(), indxbuffer.arrayOffset(), indxbuffer.capacity());
            kernbuffer.position(0);
            indxbuffer.position(0);
            kernbuffer.asDoubleBuffer().get(this.qKernel[i]);
            indxbuffer.asIntBuffer().get(this.qKernel_indexes[i]);
            ++i;
        }
    }

    public void writeKernels(File file) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while (i < this.k) {
            int len = this.qKernel_indexes[i].length;
            ByteBuffer kbuffer = ByteBuffer.allocate(4);
            kbuffer.putInt(len);
            baos.write(kbuffer.array(), kbuffer.arrayOffset(), kbuffer.capacity());
            ByteBuffer kernbuffer = ByteBuffer.allocate(len * 8 * 2);
            kernbuffer.asDoubleBuffer().put(this.qKernel[i]);
            baos.write(kernbuffer.array(), kernbuffer.arrayOffset(), kernbuffer.capacity());
            ByteBuffer indxbuffer = ByteBuffer.allocate(len * 4);
            indxbuffer.asIntBuffer().put(this.qKernel_indexes[i]);
            baos.write(indxbuffer.array(), indxbuffer.arrayOffset(), indxbuffer.capacity());
            ++i;
        }
        try {
            FileOutputStream faos = new FileOutputStream(file);
            faos.write(baos.toByteArray());
            faos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(String.valueOf(file.getPath()) + " writen " + baos.size());
    }

    public void calc(double[] buff_in, double[] buff_out) {
        this.fft.calcReal(buff_in, -1);
        int i = 0;
        while (i < this.qKernel.length) {
            double[] kernel = this.qKernel[i];
            int[] indexes = this.qKernel_indexes[i];
            double t_r = 0.0;
            double t_i = 0.0;
            int j = 0;
            int l = 0;
            while (j < kernel.length) {
                int jj = indexes[l];
                double b_r = buff_in[jj];
                double b_i = buff_in[jj + 1];
                double k_r = kernel[j];
                double k_i = kernel[j + 1];
                t_r += b_r * k_r - b_i * k_i;
                t_i += b_r * k_i + b_i * k_r;
                j += 2;
                ++l;
            }
            buff_out[i * 2] = t_r;
            buff_out[i * 2 + 1] = t_i;
            ++i;
        }
    }
}

