/*
 * Decompiled with CFR 0.152.
 */
package uk.co.drpj.midi;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import javax.swing.JPanel;

public class VirtualPianoPanel
extends JPanel
implements MouseListener,
Transmitter,
KeyListener {
    private static final long serialVersionUID = 1L;
    final int ON = 0;
    final int OFF = 1;
    final Color jfcBlue = new Color(204, 204, 255);
    final Color pink = new Color(255, 175, 175);
    Vector<Key> blackKeys = new Vector();
    Key[] keys;
    Vector<Key> whiteKeys = new Vector();
    Key prevKey;
    final int nOctave;
    final int nNote;
    final int nWhiteNote;
    private Receiver recv;
    private int currentvelocity = 100;
    private int currentoctave = 3;
    int width;
    int height = 30;
    int noteItemHeight;
    private int noteOffset;

    public VirtualPianoPanel() {
        this(3, 6);
    }

    public VirtualPianoPanel(int botOctave, int nOctave) {
        super(false);
        this.nOctave = nOctave;
        this.noteOffset = botOctave * 12;
        this.nNote = nOctave * 12;
        this.nWhiteNote = 7 * this.nOctave;
        this.width = this.nWhiteNote * 10;
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.resizeKeys();
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    private void resizeKeys() {
        int whiteKeyWidth = this.width / this.nWhiteNote;
        int blackKeyDepth = (int)((double)this.height * 0.7);
        int keyDepth = this.height;
        this.keys = new Key[this.nNote];
        this.blackKeys.clear();
        this.whiteKeys.clear();
        this.noteItemHeight = 8;
        int blackWhiteGap = whiteKeyWidth / 3;
        int[] nArray = new int[7];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 9;
        nArray[6] = 11;
        int[] whiteIDs = nArray;
        int i = 0;
        int y = 0;
        while (i < this.nOctave) {
            int j = 0;
            while (j < 7) {
                int keyNum = i * 12 + whiteIDs[j];
                if (keyNum >= this.nNote) break;
                this.whiteKeys.add(new Key(0, y, keyDepth, whiteKeyWidth, keyNum));
                ++j;
                y += whiteKeyWidth;
            }
            ++i;
        }
        int halfGap = blackWhiteGap / 2;
        int blackKeyWidth = 2 * whiteKeyWidth / 3;
        int i2 = 0;
        int y2 = 0;
        while (i2 < this.nOctave) {
            int keyNum = i2 * 12 + 1;
            if (keyNum >= this.nNote) break;
            this.blackKeys.add(new Key(0, (y2 += whiteKeyWidth) - 2 * halfGap, blackKeyDepth, blackKeyWidth, keyNum));
            if ((keyNum += 2) >= this.nNote) break;
            this.blackKeys.add(new Key(0, (y2 += whiteKeyWidth) - 2 * halfGap, blackKeyDepth, blackKeyWidth, keyNum));
            if ((keyNum += 3) >= this.nNote) break;
            y2 += whiteKeyWidth;
            this.blackKeys.add(new Key(0, (y2 += whiteKeyWidth) - 2 * halfGap + 1, blackKeyDepth, blackKeyWidth, keyNum));
            if ((keyNum += 2) >= this.nNote) break;
            this.blackKeys.add(new Key(0, (y2 += whiteKeyWidth) - 2 * halfGap, blackKeyDepth, blackKeyWidth, keyNum));
            if ((keyNum += 2) >= this.nNote) break;
            this.blackKeys.add(new Key(0, (y2 += whiteKeyWidth) - 2 * halfGap - 1, blackKeyDepth, blackKeyWidth, keyNum));
            ++i2;
            y2 += whiteKeyWidth;
        }
        Iterator<Key> iterator = this.whiteKeys.iterator();
        while (iterator.hasNext()) {
            Key key;
            this.keys[key.kNum] = key = iterator.next();
        }
        iterator = this.blackKeys.iterator();
        while (iterator.hasNext()) {
            Key key;
            this.keys[key.kNum] = key = iterator.next();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.prevKey = this.getKey(e.getPoint());
        if (this.prevKey != null) {
            this.prevKey.on();
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.prevKey != null) {
            this.prevKey.off();
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.prevKey != null) {
            this.prevKey.off();
            this.repaint();
            this.prevKey = null;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.requestFocusInWindow();
    }

    public Key getKey(Point point) {
        Key[] keyArray = this.keys;
        int n = 0;
        int n2 = keyArray.length;
        while (n < n2) {
            Key key = keyArray[n];
            if (key.contains(point)) {
                return key;
            }
            ++n;
        }
        return null;
    }

    public void paintComponent(Graphics g) {
        Key key;
        Thread.yield();
        super.paintComponent(g);
        Thread.yield();
        Graphics2D g2 = (Graphics2D)g;
        if (this.width != this.getWidth() || this.height != this.getHeight()) {
            this.width = this.getWidth();
            this.height = this.getHeight();
            this.resizeKeys();
        }
        g2.setColor(Color.PINK);
        g2.fillRect(0, 0, this.width, this.height);
        int i = 0;
        while (i < this.whiteKeys.size()) {
            key = this.whiteKeys.get(i);
            if (key.isNoteOn()) {
                g2.setColor(this.jfcBlue);
                g2.fill(key);
            }
            g2.setColor(Color.black);
            g2.draw(key);
            if (key.kNum % 12 == 0) {
                g2.setColor(Color.BLACK);
                g2.drawString(String.valueOf((key.kNum + this.noteOffset) / 12), key.x + 1, this.height - 1);
            }
            ++i;
        }
        i = 0;
        while (i < this.blackKeys.size()) {
            key = this.blackKeys.get(i);
            if (key.isNoteOn()) {
                g2.setColor(this.jfcBlue);
                g2.fill(key);
                g2.setColor(Color.black);
                g2.draw(key);
            } else {
                g2.setColor(Color.black);
                g2.fill(key);
            }
            ++i;
        }
        Thread.yield();
    }

    public void setReceiver(Receiver receiver) {
        this.recv = receiver;
    }

    public Receiver getReceiver() {
        return this.recv;
    }

    public void close() {
        this.recv = null;
    }

    public int getVelocity() {
        return this.currentvelocity;
    }

    public int getOctave() {
        return this.currentoctave;
    }

    public void setVelocity(int value) {
        this.currentvelocity = value;
    }

    public void setOctave(int value) {
        this.currentoctave = value;
    }

    public boolean isConsumed(KeyEvent e) {
        return this.keyCodeToNote(e) != 0;
    }

    private int keyCodeToNote(KeyEvent e) {
        return this.keyCodeToNote(this.currentoctave, e);
    }

    private int keyCodeToNote(int currentoctave, KeyEvent e) {
        int note;
        block54: {
            int keycode;
            block53: {
                keycode = e.getKeyCode();
                if (keycode != 0) break block53;
                char keychar = e.getKeyChar();
                switch (keychar) {
                    case '\u00e6': {
                        note = 15;
                        break block54;
                    }
                    case '\u00c6': {
                        note = 15;
                        break block54;
                    }
                    case '\u00fe': {
                        note = 16;
                        break block54;
                    }
                    case '\u00de': {
                        note = 16;
                        break block54;
                    }
                    case '\u00f0': {
                        note = 29;
                        break block54;
                    }
                    case '\u00d0': {
                        note = 29;
                        break block54;
                    }
                    default: {
                        return 0;
                    }
                }
            }
            switch (keycode) {
                case 49: {
                    note = 11;
                    break;
                }
                case 81: {
                    note = 12;
                    break;
                }
                case 50: {
                    note = 13;
                    break;
                }
                case 87: {
                    note = 14;
                    break;
                }
                case 51: {
                    note = 15;
                    break;
                }
                case 52: {
                    note = 17;
                    break;
                }
                case 69: {
                    note = 16;
                    break;
                }
                case 82: {
                    note = 17;
                    break;
                }
                case 53: {
                    note = 18;
                    break;
                }
                case 84: {
                    note = 19;
                    break;
                }
                case 54: {
                    note = 20;
                    break;
                }
                case 89: {
                    note = 21;
                    break;
                }
                case 55: {
                    note = 22;
                    break;
                }
                case 56: {
                    note = 24;
                    break;
                }
                case 85: {
                    note = 23;
                    break;
                }
                case 73: {
                    note = 24;
                    break;
                }
                case 57: {
                    note = 25;
                    break;
                }
                case 79: {
                    note = 26;
                    break;
                }
                case 48: {
                    note = 27;
                    break;
                }
                case 80: {
                    note = 28;
                    break;
                }
                case 45: {
                    note = 30;
                    break;
                }
                case 222: {
                    note = 31;
                    break;
                }
                case 70: {
                    note = -1;
                    break;
                }
                case 153: {
                    note = -1;
                    break;
                }
                case 90: {
                    note = 0;
                    break;
                }
                case 83: {
                    note = 1;
                    break;
                }
                case 88: {
                    note = 2;
                    break;
                }
                case 68: {
                    note = 3;
                    break;
                }
                case 65: {
                    note = 5;
                    break;
                }
                case 67: {
                    note = 4;
                    break;
                }
                case 86: {
                    note = 5;
                    break;
                }
                case 71: {
                    note = 6;
                    break;
                }
                case 66: {
                    note = 7;
                    break;
                }
                case 72: {
                    note = 8;
                    break;
                }
                case 78: {
                    note = 9;
                    break;
                }
                case 74: {
                    note = 10;
                    break;
                }
                case 75: {
                    note = 12;
                    break;
                }
                case 77: {
                    note = 11;
                    break;
                }
                case 44: {
                    note = 12;
                    break;
                }
                case 76: {
                    note = 13;
                    break;
                }
                case 46: {
                    note = 14;
                    break;
                }
                default: {
                    return 0;
                }
            }
        }
        note += currentoctave * 12;
        while (note > this.nNote) {
            note -= 12;
        }
        while (note < 0) {
            note += 12;
        }
        return note;
    }

    public void allNotesOff() {
        Key[] keyArray = this.keys;
        int n = 0;
        int n2 = keyArray.length;
        while (n < n2) {
            Key key = keyArray[n];
            key.off();
            ++n;
        }
    }

    public void keyPressed(KeyEvent e) {
        ShortMessage ssmg = new ShortMessage();
        switch (e.getKeyCode()) {
            case 121: {
                System.gc();
                System.runFinalization();
                e.consume();
                return;
            }
            case 122: {
                try {
                    ssmg.setMessage(176, 0, 121, 0);
                }
                catch (InvalidMidiDataException e1) {
                    e1.printStackTrace();
                }
                if (this.recv != null) {
                    this.recv.send(ssmg, 0L);
                }
                e.consume();
                return;
            }
            case 123: {
                try {
                    ssmg.setMessage(176, 0, 120, 0);
                }
                catch (InvalidMidiDataException e1) {
                    e1.printStackTrace();
                }
                if (this.recv != null) {
                    this.recv.send(ssmg, 0L);
                }
                e.consume();
                return;
            }
            case 27: {
                try {
                    ssmg.setMessage(176, 0, 123, 0);
                }
                catch (InvalidMidiDataException e1) {
                    e1.printStackTrace();
                }
                if (this.recv != null) {
                    this.recv.send(ssmg, 0L);
                }
                e.consume();
                return;
            }
            case 33: {
                ++this.currentoctave;
                if (this.currentoctave > 8) {
                    this.currentoctave = 8;
                }
                e.consume();
                return;
            }
            case 34: {
                --this.currentoctave;
                if (this.currentoctave < 0) {
                    this.currentoctave = 0;
                }
                e.consume();
                return;
            }
        }
        if (e.getKeyChar() == '+') {
            try {
                ssmg.setMessage(176, 0, 64, 64);
            }
            catch (InvalidMidiDataException e1) {
                e1.printStackTrace();
            }
            if (this.recv != null) {
                this.recv.send(ssmg, 0L);
            }
        } else if (e.getKeyChar() == '-') {
            try {
                ssmg.setMessage(176, 0, 64, 63);
            }
            catch (InvalidMidiDataException e1) {
                e1.printStackTrace();
            }
            if (this.recv != null) {
                this.recv.send(ssmg, 0L);
            }
        } else if (e.getKeyChar() == '*') {
            try {
                ssmg.setMessage(176, 0, 66, 64);
            }
            catch (InvalidMidiDataException e1) {
                e1.printStackTrace();
            }
            if (this.recv != null) {
                this.recv.send(ssmg, 0L);
            }
        } else if (e.getKeyChar() == '/') {
            try {
                ssmg.setMessage(176, 0, 66, 63);
            }
            catch (InvalidMidiDataException e1) {
                e1.printStackTrace();
            }
            if (this.recv != null) {
                this.recv.send(ssmg, 0L);
            }
        } else {
            int note = this.keyCodeToNote(e);
            if (note == 0) {
                return;
            }
            e.consume();
            this.keys[note].on();
        }
    }

    public void keyReleased(KeyEvent e) {
        int note = this.keyCodeToNote(e);
        if (note == 0) {
            return;
        }
        e.consume();
        this.keys[note].off();
    }

    public void keyTyped(KeyEvent e) {
        int note = this.keyCodeToNote(e);
        if (note == 0) {
            return;
        }
        e.consume();
    }

    class Key
    extends Rectangle {
        private static final long serialVersionUID = 1L;
        int chan;
        int noteState;
        int kNum;

        public Key(int y, int x, int height, int width, int num) {
            super(x, y, width, height);
            this.chan = 0;
            this.noteState = VirtualPianoPanel.this.OFF;
            this.kNum = num;
        }

        public boolean isNoteOn() {
            return this.noteState == VirtualPianoPanel.this.ON;
        }

        public void on() {
            this.setNoteState(VirtualPianoPanel.this.ON);
            if (VirtualPianoPanel.this.recv == null) {
                return;
            }
            ShortMessage shm = new ShortMessage();
            try {
                shm.setMessage(144, this.chan, this.kNum + VirtualPianoPanel.this.noteOffset, VirtualPianoPanel.this.getVelocity());
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
            VirtualPianoPanel.this.recv.send(shm, -1L);
        }

        public void off() {
            if (this.noteState == VirtualPianoPanel.this.OFF) {
                return;
            }
            this.setNoteState(VirtualPianoPanel.this.OFF);
            if (VirtualPianoPanel.this.recv == null) {
                return;
            }
            ShortMessage shm = new ShortMessage();
            try {
                shm.setMessage(144, this.chan, this.kNum + VirtualPianoPanel.this.noteOffset, 0);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
            VirtualPianoPanel.this.recv.send(shm, -1L);
        }

        public void setNoteState(int state) {
            this.noteState = state;
            VirtualPianoPanel.this.repaint();
        }
    }
}

