/*
 * Decompiled with CFR 0.152.
 */
package uk.co.drpj.process;

import javax.swing.JFrame;
import rasmus.interpreter.sampled.util.FFTConstantQ;
import uk.co.drpj.process.Graph;

public class ConstantQ {
    FFTConstantQ fftconstanq = null;
    boolean process_running = false;
    static double samplerate = 44100.0;
    double[] freqs;
    int frameInc;

    ConstantQ(int frameInc) {
        this.frameInc = frameInc;
        double minFreq = 440.0 * Math.pow(2.0, -2.8333333333333335);
        double maxFreq = samplerate / 2.0;
        int binsPerOctave = 24;
        this.fftconstanq = new FFTConstantQ(samplerate, minFreq, maxFreq, binsPerOctave);
        this.freqs = new double[this.fftconstanq.getNumberOfOutputBands()];
        int i = 0;
        while (i < this.fftconstanq.getNumberOfOutputBands()) {
            this.freqs[i] = minFreq * Math.pow(2.0, (double)i / (double)binsPerOctave);
            ++i;
        }
    }

    public void process(double[] in, double[] out) {
        int fftlen = this.fftconstanq.getFFTSize();
        double[] noise = new double[fftlen];
        double[] outnoise = new double[this.fftconstanq.getNumberOfOutputBands() * 2];
        double[] magn = new double[this.fftconstanq.getNumberOfOutputBands()];
        double[] phase = new double[this.fftconstanq.getNumberOfOutputBands()];
        int i = 0;
        while (i < this.fftconstanq.getNumberOfOutputBands()) {
            phase[i] = 0.0;
            magn[i] = 0.0;
            ++i;
        }
        int frameCount = 0;
        while (frameCount - 1 < in.length / this.frameInc) {
            System.out.print(".");
            int i2 = 0;
            while (i2 < fftlen) {
                noise[i2] = i2 + frameCount * this.frameInc < in.length ? in[i2 + frameCount * this.frameInc] : 0.0;
                ++i2;
            }
            this.fftconstanq.calc(noise, outnoise);
            int sampleCount = frameCount * this.frameInc;
            double t1 = (double)sampleCount / samplerate;
            int bin = 0;
            while (bin < this.fftconstanq.getNumberOfOutputBands()) {
                double freq = this.freqs[bin];
                double period = 1.0 / freq;
                double phaseShift = Math.PI * 2 * (t1 % period) / period;
                double real = outnoise[2 * bin];
                double imag = outnoise[2 * bin + 1];
                double magni = 2.0 * Math.sqrt(real * real + imag * imag);
                double phasei = Math.atan2(imag, real) - phaseShift;
                while (phasei < phase[bin] - Math.PI) {
                    phasei += Math.PI * 2;
                }
                while (phasei > phase[bin] + Math.PI) {
                    phasei -= Math.PI * 2;
                }
                double scale = 1.0 / (double)(this.frameInc - 1);
                int i3 = 0;
                while (i3 < this.frameInc) {
                    if (sampleCount + i3 >= in.length) break;
                    double fact2 = (double)i3 * scale;
                    double fact1 = 1.0 - fact2;
                    double mag = magn[bin] * fact1 + magni * fact2;
                    double pha = phase[bin] * fact1 + phasei * fact2;
                    double tt = (double)(sampleCount + i3) * freq * Math.PI * 2.0 / samplerate;
                    int n = sampleCount + i3;
                    out[n] = out[n] + mag * Math.cos(tt + pha);
                    ++i3;
                }
                magn[bin] = magni;
                phase[bin] = phasei;
                ++bin;
            }
            ++frameCount;
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Graph graph = new Graph();
        frame.setContentPane(graph);
        frame.pack();
        frame.setVisible(true);
        frame.setSize(1000, 500);
        int frameInc = 128;
        ConstantQ q = new ConstantQ(frameInc);
        double freq = q.freqs[25];
        double[] in = new double[10000];
        double[] out = new double[10000];
        int i = 0;
        while (i < in.length) {
            in[i] = Math.sin((double)(i * 2) * Math.PI * freq / samplerate);
            out[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < frameInc) {
            int n = i;
            in[n] = in[n] * ((double)i / (double)frameInc);
            ++i;
        }
        q.process(in, out);
        i = 0;
        while (i < frameInc) {
            out[i] = 0.0;
            ++i;
        }
        double[][] a = new double[][]{in, out};
        graph.plot(a);
    }
}

