/*
 * Decompiled with CFR 0.152.
 */
package uk.co.drpj.testing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.controls.ControlViewer;
import rasmus.interpreter.metadata.FunctionCallEditor;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.util.FFT;
import rasmus.interpreter.sampled.util.FFTConstantQ;
import rasmus.interpreter.sampled.util.LogDFT;
import rasmus.interpreter.ui.AboutDialog;
import rasmus.interpreter.ui.GroupMenuListener;
import rasmus.interpreter.ui.GroupMenus;
import rasmus.interpreter.ui.RSyntaxDocument;
import rasmus.interpreter.ui.RegisterFunction;
import rasmus.interpreter.ui.RegisterUnit;
import rasmus.testing.SoundFontTester;
import rasmus.util.RasmusUtil;

public class FFT_Testing
extends JFrame {
    private static final long serialVersionUID = 1L;
    BufferedImage offImg;
    JPanel panel;
    JPanel cpanel;
    JTextPane textarea = new JTextPane();
    boolean process_running = false;
    boolean b_phase_included;
    FFTConstantQ fftconstanq = null;
    FFTConstantQ fftconstanq2 = null;
    boolean q_hires = false;
    GroupMenuListener groupmenulistener = new GroupMenuListener(){

        public void actionPerformed(RegisterUnit.Record record) {
            if (record.unit instanceof RegisterFunction) {
                if (FunctionCallEditor.isEditableFunction(record.name, FFT_Testing.this.globalinterpreter)) {
                    String statement = FunctionCallEditor.editFunctionCall(FFT_Testing.this, String.valueOf(record.name) + "()", FFT_Testing.this.globalinterpreter);
                    if (statement != null) {
                        FFT_Testing.this.textarea.replaceSelection(statement);
                    }
                    return;
                }
                FFT_Testing.this.textarea.replaceSelection(String.valueOf(record.name) + "()");
                return;
            }
            FFT_Testing.this.textarea.replaceSelection(record.name);
        }
    };
    UndoManager undo = new UndoManager();
    Interpreter globalinterpreter = new Interpreter();
    JPanel uipanel;
    CardLayout cardlayout;
    Interpreter ui_interpreter = null;
    ControlViewer panelviewer = null;

    public void processStereoImage(boolean phase_included) {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        this.b_phase_included = phase_included;
        Runnable runnable = new Runnable(){
            boolean phase_included;
            {
                this.phase_included = FFT_Testing.this.b_phase_included;
            }

            public void run() {
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 2);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int fftsize = 8192;
                int fftsizeh = fftsize / 2;
                double fftsizeh1 = fftsize / 4;
                double fftsizeh2 = fftsize / 8;
                int readsize = 2048;
                int fftoffset = fftsize * 2 - readsize;
                int seclen = (int)(samplerate / (double)(readsize / 2));
                int secounter = 0;
                FFT fft = new FFT(fftsize);
                double[] window = fft.wHanning();
                double[] buffer = new double[fftsize * 2];
                int yy = 0;
                while (FFT_Testing.this.process_running) {
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    int i = 0;
                    while (i < fftoffset) {
                        buffer[i] = buffer[i + readsize];
                        ++i;
                    }
                    int len = audiostream.replace(buffer, fftoffset, fftsize * 2);
                    if (len == -1) break;
                    double[] noiseL = new double[fftsize];
                    double[] noiseR = new double[fftsize];
                    int i2 = 0;
                    while (i2 < fftsize) {
                        noiseL[i2] = buffer[i2 * 2] * window[i2];
                        noiseR[i2] = buffer[i2 * 2 + 1] * window[i2];
                        ++i2;
                    }
                    fft.calcReal(noiseL, -1);
                    fft.calcReal(noiseR, -1);
                    g2.setColor(Color.GREEN);
                    double[] fmagn1 = new double[513];
                    double[] fmagn2 = new double[513];
                    double[] fmagn3 = new double[513];
                    int i3 = 0;
                    while (i3 < fftsizeh) {
                        double magna;
                        int pos;
                        double L_real = noiseL[2 * i3];
                        double L_imag = noiseL[2 * i3 + 1];
                        double L_magn = 2.0 * Math.sqrt(L_real * L_real + L_imag * L_imag);
                        double L_phase = Math.atan2(L_imag, L_real);
                        double R_real = noiseR[2 * i3];
                        double R_imag = noiseR[2 * i3 + 1];
                        double R_magn = 2.0 * Math.sqrt(R_real * R_real + R_imag * R_imag);
                        double R_phase = Math.atan2(R_imag, R_real);
                        double magn = (L_magn + R_magn) / 2.0;
                        double T_magn = L_magn + R_magn;
                        double pan = R_magn / T_magn;
                        double phase_diff = Math.abs(L_phase - R_phase) % (Math.PI * 2);
                        if (phase_diff > Math.PI) {
                            phase_diff = Math.PI * 2 - phase_diff;
                        }
                        int phase_size1 = pos = (int)(pan * 512.0);
                        int phase_size2 = 512 - pos;
                        int i_phase_diff1 = (int)((phase_diff /= Math.PI) * (double)phase_size1);
                        int i_phase_diff2 = (int)(phase_diff * (double)phase_size2);
                        if (!this.phase_included) {
                            i_phase_diff1 = 0;
                            i_phase_diff2 = 0;
                        }
                        int posa = pos - i_phase_diff1;
                        int posb = pos + i_phase_diff2;
                        if (posa > 512) {
                            posa = 512;
                        }
                        if (posa < 0) {
                            posa = 0;
                        }
                        if (posb > 512) {
                            posb = 512;
                        }
                        if (posb < 0) {
                            posb = 0;
                        }
                        double ii = i3;
                        if ((double)i3 < fftsizeh2) {
                            magna = magn * Math.pow(10.0, -5.0 * (1.0 - (fftsizeh2 - ii) / fftsizeh2));
                            int n = posa;
                            fmagn1[n] = fmagn1[n] + magna;
                            int n2 = posb;
                            fmagn1[n2] = fmagn1[n2] + magna;
                            magna = magn * Math.pow(10.0, -5.0 * (1.0 - ii / fftsizeh2));
                            int n3 = posa;
                            fmagn2[n3] = fmagn2[n3] + magna;
                            int n4 = posb;
                            fmagn2[n4] = fmagn2[n4] + magna;
                        } else if ((double)i3 < fftsizeh1) {
                            magna = magn * Math.pow(10.0, -5.0 * (1.0 - (fftsizeh2 - (ii - fftsizeh2)) / fftsizeh2));
                            int n = posa;
                            fmagn2[n] = fmagn2[n] + magna;
                            int n5 = posb;
                            fmagn2[n5] = fmagn2[n5] + magna;
                            magna = magn * Math.pow(10.0, -5.0 * (1.0 - (ii - fftsizeh2) / fftsizeh2));
                            int n6 = posa;
                            fmagn3[n6] = fmagn3[n6] + magna;
                            int n7 = posb;
                            fmagn3[n7] = fmagn3[n7] + magna;
                        } else {
                            int n = posa;
                            fmagn3[n] = fmagn3[n] + magn;
                            int n8 = posb;
                            fmagn3[n8] = fmagn3[n8] + magn;
                        }
                        ++i3;
                    }
                    i3 = 0;
                    while (i3 < 513) {
                        double logman1 = Math.log10(fmagn1[i3] / (double)fftsizeh) * 2.0;
                        float colormag1 = (float)((logman1 + 9.0) / 7.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        double logman2 = Math.log10(fmagn2[i3] / (double)fftsizeh) * 2.0;
                        float colormag2 = (float)((logman2 + 9.0) / 7.0);
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        double logman3 = Math.log10(fmagn3[i3] / (double)fftsizeh) * 2.0;
                        float colormag3 = (float)((logman3 + 9.0) / 7.0);
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        g2.setColor(new Color(colormag1, colormag2, colormag3));
                        g2.drawLine(yy, i3, yy, i3);
                        ++i3;
                    }
                    if (secounter == 0) {
                        secounter = seclen;
                        g2.setColor(Color.GREEN);
                        g2.drawLine(yy, 512, yy, FFT_Testing.this.panel.getHeight());
                    }
                    FFT_Testing.this.panel.repaint();
                    --secounter;
                }
                g2.setColor(Color.GREEN);
                g2.drawLine(FFT_Testing.this.panel.getWidth() - 10, 0, FFT_Testing.this.panel.getWidth(), 0);
                g2.drawLine(FFT_Testing.this.panel.getWidth() - 10, 256, FFT_Testing.this.panel.getWidth(), 256);
                g2.drawLine(FFT_Testing.this.panel.getWidth() - 10, 512, FFT_Testing.this.panel.getWidth(), 512);
                FFT_Testing.this.panel.repaint();
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processStereoPhaseImage() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 2);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int fftsize = 8192;
                int fftsizeh = fftsize / 2;
                int fftsizeh1 = fftsize / 4;
                int fftsizeh2 = fftsize / 8;
                int readsize = 2048;
                int fftoffset = fftsize * 2 - readsize;
                int seclen = (int)(samplerate / (double)(readsize / 2));
                int secounter = 0;
                FFT fft = new FFT(fftsize);
                double[] window = fft.wHanning();
                double[] buffer = new double[fftsize * 2];
                int yy = 0;
                while (FFT_Testing.this.process_running) {
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    int i = 0;
                    while (i < fftoffset) {
                        buffer[i] = buffer[i + readsize];
                        ++i;
                    }
                    int len = audiostream.replace(buffer, fftoffset, fftsize * 2);
                    if (len == -1) break;
                    double[] noiseL = new double[fftsize];
                    double[] noiseR = new double[fftsize];
                    int i2 = 0;
                    while (i2 < fftsize) {
                        noiseL[i2] = buffer[i2 * 2] * window[i2];
                        noiseR[i2] = buffer[i2 * 2 + 1] * window[i2];
                        ++i2;
                    }
                    fft.calcReal(noiseL, -1);
                    fft.calcReal(noiseR, -1);
                    g2.setColor(Color.GREEN);
                    double[] fmagn1 = new double[513];
                    double[] fmagn2 = new double[513];
                    double[] fmagn3 = new double[513];
                    int i3 = 0;
                    while (i3 < fftsizeh) {
                        double magna;
                        double L_real = noiseL[2 * i3];
                        double L_imag = noiseL[2 * i3 + 1];
                        double L_magn = 2.0 * Math.sqrt(L_real * L_real + L_imag * L_imag);
                        double L_phase = Math.atan2(L_imag, L_real);
                        double R_real = noiseR[2 * i3];
                        double R_imag = noiseR[2 * i3 + 1];
                        double R_magn = 2.0 * Math.sqrt(R_real * R_real + R_imag * R_imag);
                        double R_phase = Math.atan2(R_imag, R_real);
                        double magn = (L_magn + R_magn) / 2.0;
                        double T_magn = L_magn + R_magn;
                        double pan = R_magn / T_magn;
                        double phase_diff = Math.abs(L_phase - R_phase) % (Math.PI * 2);
                        if (phase_diff > Math.PI) {
                            phase_diff = Math.PI * 2 - phase_diff;
                        }
                        int pos = (int)(pan * 512.0);
                        int phase_size = fftsizeh1;
                        double i_phase_diff = (phase_diff /= Math.PI) * (double)phase_size;
                        int posa = pos;
                        if (i_phase_diff < (double)fftsizeh2) {
                            magna = magn * Math.pow(10.0, -5.0 * (1.0 - ((double)fftsizeh2 - i_phase_diff) / (double)fftsizeh2));
                            int n = posa;
                            fmagn1[n] = fmagn1[n] + magna * 2.0;
                            magna = magn * Math.pow(10.0, -5.0 * (1.0 - i_phase_diff / (double)fftsizeh2));
                            int n2 = posa;
                            fmagn2[n2] = fmagn2[n2] + magna * 2.0;
                        } else if (i_phase_diff <= (double)fftsizeh1) {
                            magna = magn * Math.pow(10.0, -5.0 * (1.0 - ((double)fftsizeh2 - (i_phase_diff - (double)fftsizeh2)) / (double)fftsizeh2));
                            int n = posa;
                            fmagn2[n] = fmagn2[n] + magna * 2.0;
                            magna = magn * Math.pow(10.0, -5.0 * (1.0 - (i_phase_diff - (double)fftsizeh2) / (double)fftsizeh2));
                            int n3 = posa;
                            fmagn3[n3] = fmagn3[n3] + magna * 2.0;
                        }
                        ++i3;
                    }
                    i3 = 0;
                    while (i3 < 513) {
                        double logman1 = Math.log10(fmagn1[i3] / (double)fftsizeh) * 2.0;
                        float colormag1 = (float)((logman1 + 9.0) / 7.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        double logman2 = Math.log10(fmagn2[i3] / (double)fftsizeh) * 2.0;
                        float colormag2 = (float)((logman2 + 9.0) / 7.0);
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        double logman3 = Math.log10(fmagn3[i3] / (double)fftsizeh) * 2.0;
                        float colormag3 = (float)((logman3 + 9.0) / 7.0);
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        g2.setColor(new Color(colormag1, colormag2, colormag3));
                        g2.drawLine(yy, i3, yy, i3);
                        ++i3;
                    }
                    if (secounter == 0) {
                        secounter = seclen;
                        g2.setColor(Color.GREEN);
                        g2.drawLine(yy, 512, yy, FFT_Testing.this.panel.getHeight());
                    }
                    FFT_Testing.this.panel.repaint();
                    --secounter;
                }
                g2.setColor(Color.GREEN);
                g2.drawLine(FFT_Testing.this.panel.getWidth() - 10, 0, FFT_Testing.this.panel.getWidth(), 0);
                g2.drawLine(FFT_Testing.this.panel.getWidth() - 10, 256, FFT_Testing.this.panel.getWidth(), 256);
                g2.drawLine(FFT_Testing.this.panel.getWidth() - 10, 512, FFT_Testing.this.panel.getWidth(), 512);
                FFT_Testing.this.panel.repaint();
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processPhaseImage() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 2);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int fftsize = 8192;
                int fftsizeh = fftsize / 2;
                int fftsizeh1 = fftsize / 4;
                int fftsizeh2 = fftsize / 8;
                int readsize = 2048;
                int fftoffset = fftsize * 2 - readsize;
                int seclen = (int)(samplerate / (double)(readsize / 2));
                int secounter = 0;
                FFT fft = new FFT(fftsize);
                double[] window = fft.wHanning();
                double[] buffer = new double[fftsize * 2];
                int yy = 0;
                while (FFT_Testing.this.process_running) {
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    int i = 0;
                    while (i < fftoffset) {
                        buffer[i] = buffer[i + readsize];
                        ++i;
                    }
                    int len = audiostream.replace(buffer, fftoffset, fftsize * 2);
                    if (len == -1) break;
                    double[] noiseL = new double[fftsize];
                    double[] noiseR = new double[fftsize];
                    int i2 = 0;
                    while (i2 < fftsize) {
                        noiseL[i2] = buffer[i2 * 2] * window[i2];
                        noiseR[i2] = buffer[i2 * 2 + 1] * window[i2];
                        ++i2;
                    }
                    fft.calcReal(noiseL, -1);
                    fft.calcReal(noiseR, -1);
                    g2.setColor(Color.GREEN);
                    double[] fmagn1 = new double[513];
                    double[] fmagn2 = new double[513];
                    double[] fmagn3 = new double[513];
                    int i3 = 0;
                    while (i3 < fftsizeh) {
                        double magna;
                        int phase_size;
                        int i_phase_diff;
                        int posa;
                        double L_real = noiseL[2 * i3];
                        double L_imag = noiseL[2 * i3 + 1];
                        double L_magn = 2.0 * Math.sqrt(L_real * L_real + L_imag * L_imag);
                        double L_phase = Math.atan2(L_imag, L_real);
                        double R_real = noiseR[2 * i3];
                        double R_imag = noiseR[2 * i3 + 1];
                        double R_magn = 2.0 * Math.sqrt(R_real * R_real + R_imag * R_imag);
                        double R_phase = Math.atan2(R_imag, R_real);
                        double magn = (L_magn + R_magn) / 2.0;
                        double phase_diff = Math.abs(L_phase - R_phase) % (Math.PI * 2);
                        if (phase_diff > Math.PI) {
                            phase_diff = Math.PI * 2 - phase_diff;
                        }
                        if ((posa = (i_phase_diff = (int)((phase_diff /= Math.PI) * (double)(phase_size = 512)))) > 512) {
                            posa = 512;
                        }
                        if (posa < 0) {
                            posa = 0;
                        }
                        double ii = i3;
                        if (i3 < fftsizeh2) {
                            magna = magn * Math.pow(10.0, -5.0 * (1.0 - ((double)fftsizeh2 - ii) / (double)fftsizeh2));
                            int n = posa;
                            fmagn1[n] = fmagn1[n] + magna * 2.0;
                            magna = magn * Math.pow(10.0, -5.0 * (1.0 - ii / (double)fftsizeh2));
                            int n2 = posa;
                            fmagn2[n2] = fmagn2[n2] + magna * 2.0;
                        } else if (i3 < fftsizeh1) {
                            magna = magn * Math.pow(10.0, -5.0 * (1.0 - ((double)fftsizeh2 - (ii - (double)fftsizeh2)) / (double)fftsizeh2));
                            int n = posa;
                            fmagn2[n] = fmagn2[n] + magna * 2.0;
                            magna = magn * Math.pow(10.0, -5.0 * (1.0 - (ii - (double)fftsizeh2) / (double)fftsizeh2));
                            int n3 = posa;
                            fmagn3[n3] = fmagn3[n3] + magna * 2.0;
                        } else {
                            int n = posa;
                            fmagn3[n] = fmagn3[n] + magn * 2.0;
                        }
                        ++i3;
                    }
                    i3 = 0;
                    while (i3 < 513) {
                        double logman1 = Math.log10(fmagn1[i3] / (double)fftsizeh) * 2.0;
                        float colormag1 = (float)((logman1 + 9.0) / 7.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        double logman2 = Math.log10(fmagn2[i3] / (double)fftsizeh) * 2.0;
                        float colormag2 = (float)((logman2 + 9.0) / 7.0);
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        double logman3 = Math.log10(fmagn3[i3] / (double)fftsizeh) * 2.0;
                        float colormag3 = (float)((logman3 + 9.0) / 7.0);
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        g2.setColor(new Color(colormag1, colormag2, colormag3));
                        g2.drawLine(yy, i3, yy, i3);
                        ++i3;
                    }
                    if (secounter == 0) {
                        secounter = seclen;
                        g2.setColor(Color.GREEN);
                        g2.drawLine(yy, 512, yy, FFT_Testing.this.panel.getHeight());
                    }
                    --secounter;
                    FFT_Testing.this.panel.repaint();
                }
                g2.setColor(Color.GREEN);
                g2.drawLine(FFT_Testing.this.panel.getWidth() - 10, 0, FFT_Testing.this.panel.getWidth(), 0);
                g2.drawLine(FFT_Testing.this.panel.getWidth() - 10, 256, FFT_Testing.this.panel.getWidth(), 256);
                g2.drawLine(FFT_Testing.this.panel.getWidth() - 10, 512, FFT_Testing.this.panel.getWidth(), 512);
                FFT_Testing.this.panel.repaint();
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processIntensityImage() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                int i;
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 1);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int fftsize = 8192;
                int fftsizeh = fftsize / 2;
                int fftsizeh1 = fftsize / 4;
                int fftsizeh2 = fftsize / 8;
                int readsize = 1024;
                int fftoffset = fftsize - readsize;
                int seclen = (int)(samplerate / (double)readsize);
                int secounter = 0;
                FFT fft = new FFT(fftsize);
                double[] window = fft.wHanning();
                double[] buffer = new double[fftsize];
                int yy = 0;
                while (FFT_Testing.this.process_running) {
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    i = 0;
                    while (i < fftoffset) {
                        buffer[i] = buffer[i + readsize];
                        ++i;
                    }
                    int len = audiostream.replace(buffer, fftoffset, fftsize);
                    if (len == -1) break;
                    double[] noiseL = new double[fftsize];
                    int i2 = 0;
                    while (i2 < fftsize) {
                        noiseL[i2] = buffer[i2] * window[i2];
                        ++i2;
                    }
                    fft.calcReal(noiseL, -1);
                    g2.setColor(Color.GREEN);
                    double[] fmagn1 = new double[513];
                    double[] fmagn2 = new double[513];
                    double[] fmagn3 = new double[513];
                    int i3 = 0;
                    while (i3 < fftsizeh) {
                        double magna;
                        double L_real = noiseL[2 * i3];
                        double L_imag = noiseL[2 * i3 + 1];
                        double L_magn = 2.0 * Math.sqrt(L_real * L_real + L_imag * L_imag);
                        double magn = L_magn;
                        double logman1 = Math.log10(magn / (double)fftsizeh) * 2.0;
                        int posa = (int)(50.0 - logman1 * 20.0);
                        if (posa > 512) {
                            posa = 512;
                        }
                        if (posa < 0) {
                            posa = 0;
                        }
                        magn = 0.1;
                        double ii = i3;
                        if (i3 < fftsizeh2) {
                            magna = magn * ((double)fftsizeh2 - ii) / (double)fftsizeh2;
                            int n = posa;
                            fmagn1[n] = fmagn1[n] + magna * 2.0;
                            magna = magn * ii / (double)fftsizeh2;
                            int n2 = posa;
                            fmagn2[n2] = fmagn2[n2] + magna * 2.0;
                        } else if (i3 < fftsizeh1) {
                            magna = magn * ((double)fftsizeh2 - (ii - (double)fftsizeh2)) / (double)fftsizeh2;
                            int n = posa;
                            fmagn2[n] = fmagn2[n] + magna * 2.0;
                            magna = magn * (ii - (double)fftsizeh2) / (double)fftsizeh2;
                            int n3 = posa;
                            fmagn3[n3] = fmagn3[n3] + magna * 2.0;
                        } else {
                            int n = posa;
                            fmagn3[n] = fmagn3[n] + magn * 2.0;
                        }
                        ++i3;
                    }
                    i3 = 0;
                    while (i3 < 513) {
                        double logman1 = fmagn1[i3];
                        float colormag1 = (float)logman1;
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        double logman2 = fmagn2[i3];
                        float colormag2 = (float)logman2;
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        double logman3 = fmagn3[i3];
                        float colormag3 = (float)logman3;
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        g2.setColor(new Color(colormag1, colormag2, colormag3));
                        g2.drawLine(yy, i3, yy, i3);
                        ++i3;
                    }
                    if (secounter == 0) {
                        secounter = seclen;
                        g2.setColor(Color.GREEN);
                        g2.drawLine(yy, 512, yy, FFT_Testing.this.panel.getHeight());
                    }
                    --secounter;
                    FFT_Testing.this.panel.repaint();
                }
                g2.setColor(Color.GREEN);
                i = 0;
                while (i < 22) {
                    g2.drawString(String.valueOf(-i * 10) + "dB", FFT_Testing.this.panel.getWidth() - 40, 50 + 20 * i - 4);
                    g2.drawLine(FFT_Testing.this.panel.getWidth() - 50, 50 + 20 * i, FFT_Testing.this.panel.getWidth(), 50 + 20 * i);
                    ++i;
                }
                FFT_Testing.this.panel.repaint();
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processCepstrumGraph() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                int y;
                int i;
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                int fftlen = 4096;
                double[] buffer = new double[fftlen];
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 1);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int fftlenh = fftlen / 2;
                int seclen = (int)(samplerate / 1024.0);
                int secounter = 0;
                FFT fft = new FFT(fftlen);
                double[] window = fft.wHanning();
                int readsize = 1024;
                int fftoffset = fftlen - readsize;
                int yy = 0;
                while (FFT_Testing.this.process_running) {
                    double imag;
                    double real;
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    i = 0;
                    while (i < fftoffset) {
                        buffer[i] = buffer[i + readsize];
                        ++i;
                    }
                    int len = audiostream.replace(buffer, fftoffset, fftlen);
                    if (len == -1) break;
                    double[] noise = new double[fftlen * 2];
                    double[] noise2 = new double[fftlen * 2];
                    int i2 = 0;
                    while (i2 < fftlen) {
                        noise[2 * i2] = buffer[i2];
                        noise[2 * i2 + 1] = 0.0;
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < fftlen) {
                        int n = i2 * 2;
                        noise[n] = noise[n] * window[i2];
                        ++i2;
                    }
                    fft.calc(noise, -1);
                    g2.setColor(Color.GREEN);
                    i2 = 0;
                    while (i2 < fftlen) {
                        real = noise[2 * i2] / (double)fftlen;
                        imag = noise[2 * i2 + 1] / (double)fftlen;
                        noise2[i2 * 2] = Math.log(Math.sqrt(real * real + imag * imag));
                        noise2[i2 * 2 + 1] = 0.0;
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < fftlen) {
                        int j = (i2 + fftlenh) % fftlen;
                        int n = i2 * 2;
                        noise2[n] = noise2[n] * window[j];
                        ++i2;
                    }
                    fft.calc(noise2, -1);
                    i2 = 0;
                    while (i2 < 512) {
                        real = noise2[2 * (512 - i2)];
                        imag = noise2[2 * (512 - i2) + 1];
                        double magn = 2.0 * Math.sqrt(real * real + imag * imag);
                        double logman = 1.0 + Math.log10(magn / 512.0) * 2.0 / 2.0;
                        float colormag3 = (float)logman;
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        float colormag2 = (float)(logman / 2.0);
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        float colormag1 = (float)(logman / 4.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        g2.setColor(new Color(colormag1, colormag2, colormag3));
                        g2.drawLine(yy, 512 - i2, yy, 512 - i2);
                        ++i2;
                    }
                    if (secounter == 0) {
                        secounter = seclen;
                        g2.setColor(Color.GREEN);
                        g2.drawLine(yy, 512, yy, FFT_Testing.this.panel.getHeight());
                    }
                    --secounter;
                    FFT_Testing.this.panel.repaint();
                }
                g2.setColor(Color.GREEN.darker());
                i = 12;
                while (i <= 60) {
                    double f = Math.pow(2.0, ((double)i - 45.0) / 12.0) * 440.0;
                    y = (int)(44100.0 / f);
                    g2.drawLine(FFT_Testing.this.panel.getWidth() - 30, y, FFT_Testing.this.panel.getWidth(), y);
                    if (i % 12 == 0) {
                        g2.drawLine(0, y, FFT_Testing.this.panel.getWidth(), y);
                    }
                    if (i % 12 == 0) {
                        g2.setColor(Color.WHITE);
                        g2.drawString(String.valueOf(RasmusUtil.encodeMusicNote(i)) + " = " + Math.round(f) + " Hz", FFT_Testing.this.panel.getWidth() - 130, y - 2);
                        g2.setColor(Color.GREEN.darker());
                    }
                    ++i;
                }
                g2.setColor(Color.WHITE);
                i = 12;
                while (i <= 48) {
                    double f = Math.pow(2.0, ((double)i - 45.0) / 12.0) * 440.0;
                    y = (int)(44100.0 / f);
                    if (i % 2 == 0) {
                        g2.drawString(RasmusUtil.encodeMusicNote(i), FFT_Testing.this.panel.getWidth() - 20, y - 2);
                    }
                    if (i % 2 == 1) {
                        g2.drawString(RasmusUtil.encodeMusicNote(i), FFT_Testing.this.panel.getWidth() - 40, y - 2);
                    }
                    ++i;
                }
                FFT_Testing.this.panel.repaint();
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processHarmonicProductSpectrumGraph() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                int i;
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 1);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int fftlen = 1024;
                int fftlen2 = fftlen / 2;
                double[] buffer = new double[fftlen];
                FFT fft = new FFT(fftlen);
                double[] window = fft.wHanning();
                int readsize = 1024;
                int fftoffset = fftlen - readsize;
                int seclen = (int)(samplerate / (double)readsize);
                int secounter = 0;
                int yy = 0;
                while (FFT_Testing.this.process_running) {
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    i = 0;
                    while (i < fftoffset) {
                        buffer[i] = buffer[i + readsize];
                        ++i;
                    }
                    int len = audiostream.replace(buffer, fftoffset, fftlen);
                    if (len == -1) break;
                    double[] noise = new double[fftlen * 2];
                    int i2 = 0;
                    while (i2 < fftlen) {
                        noise[i2] = buffer[i2];
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < fftlen) {
                        int n = i2;
                        noise[n] = noise[n] * window[i2];
                        ++i2;
                    }
                    fft.calcReal(noise, -1);
                    g2.setColor(Color.GREEN);
                    i2 = 0;
                    while (i2 < fftlen2) {
                        double real = noise[2 * i2];
                        double imag = noise[2 * i2 + 1];
                        noise[2 * i2] = 2.0 * Math.sqrt(real * real + imag * imag);
                        noise[2 * i2 + 1] = 1.0;
                        ++i2;
                    }
                    i2 = fftlen2;
                    while (i2 < fftlen) {
                        noise[2 * i2] = 0.0;
                        noise[2 * i2 + 1] = 1.0;
                        ++i2;
                    }
                    int h = 1;
                    while (h < 4) {
                        int i3 = 0;
                        while (i3 < fftlen2 / h) {
                            int ii = i3 * h;
                            double magn = 0.0;
                            int j = 0;
                            while (j < h) {
                                magn += noise[2 * (ii + j)];
                                ++j;
                            }
                            int n = 2 * i3 + 1;
                            noise[n] = noise[n] * magn;
                            ++i3;
                        }
                        ++h;
                    }
                    i2 = 0;
                    while (i2 < 512) {
                        double magn = 1.0 + Math.log(noise[2 * i2 + 1]);
                        double logman = magn;
                        float colormag3 = (float)(logman / 4.0);
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        float colormag2 = (float)(logman / 8.0);
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        float colormag1 = (float)(logman / 16.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        g2.setColor(new Color(colormag1, colormag2, colormag3));
                        g2.drawLine(yy, 512 - i2, yy, 512 - i2);
                        ++i2;
                    }
                    if (secounter == 0) {
                        secounter = seclen;
                        g2.setColor(Color.GREEN);
                        g2.drawLine(yy, 512, yy, FFT_Testing.this.panel.getHeight());
                    }
                    --secounter;
                    FFT_Testing.this.panel.repaint();
                }
                g2.setColor(Color.GREEN.darker());
                i = 0;
                while (i < 24) {
                    int y = 512 - (int)((double)(i * 2) * 1000.0 / samplerate * 512.0);
                    g2.drawLine(0, y, FFT_Testing.this.panel.getWidth(), y);
                    ++i;
                }
                FFT_Testing.this.panel.repaint();
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public FFTConstantQ getFFTConstantQ() {
        double samplerate = 44100.0;
        if (this.fftconstanq == null) {
            this.fftconstanq = new FFTConstantQ(samplerate, 440.0 * Math.pow(2.0, -2.8333333333333335), samplerate / 2.0, 24.0);
        }
        return this.fftconstanq;
    }

    public FFTConstantQ getFFTConstantQ2() {
        double samplerate = 44100.0;
        if (this.fftconstanq2 == null) {
            this.fftconstanq2 = new FFTConstantQ(samplerate, 440.0 * Math.pow(2.0, -2.8333333333333335), samplerate / 2.0, 48.0);
        }
        return this.fftconstanq2;
    }

    public void processConstantQSpectrumGraphHPS() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                int i;
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                FFTConstantQ fftconstanq = FFT_Testing.this.getFFTConstantQ2();
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 1);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int fftlen = fftconstanq.getFFTSize();
                double[] buffer = new double[fftlen];
                int seclen = (int)(samplerate / 1024.0);
                int secounter = 0;
                int outk = fftconstanq.getNumberOfOutputBands();
                int yy = 0;
                double[] noise = new double[fftlen];
                double[] outnoise = new double[fftconstanq.getNumberOfOutputBands() * 2];
                double[] outnoise2 = new double[fftconstanq.getNumberOfOutputBands() * 2];
                while (FFT_Testing.this.process_running) {
                    int len;
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    i = 0;
                    while (i < buffer.length - 1024) {
                        buffer[i] = buffer[i + 1024];
                        ++i;
                    }
                    int i2 = len = audiostream.replace(buffer, buffer.length - 1024, buffer.length);
                    while (i2 < 1024) {
                        buffer[i2 + buffer.length - 1024] = 0.0;
                        ++i2;
                    }
                    if (len == -1) break;
                    i2 = 0;
                    while (i2 < fftlen) {
                        noise[i2] = buffer[i2];
                        ++i2;
                    }
                    fftconstanq.calc(noise, outnoise);
                    double max = 0.0;
                    double min = 0.0;
                    int i3 = 0;
                    while (i3 < fftconstanq.getNumberOfOutputBands()) {
                        double real = outnoise[2 * i3];
                        double imag = outnoise[2 * i3 + 1];
                        outnoise[i3] = 2.0 * Math.sqrt(real * real + imag * imag);
                        if (i3 == 0) {
                            min = max = outnoise[i3];
                        }
                        if (outnoise[i3] > max) {
                            max = outnoise[i3];
                        }
                        if (outnoise[i3] < min) {
                            min = outnoise[i3];
                        }
                        ++i3;
                    }
                    double startfreq = 440.0 * Math.pow(2.0, -2.8333333333333335);
                    double endfreq = samplerate / 2.0;
                    int i4 = 0;
                    while (i4 < fftconstanq.getNumberOfOutputBands()) {
                        outnoise2[i4] = outnoise[i4];
                        ++i4;
                    }
                    int h = 2;
                    while (h < 5) {
                        double offset = (double)outk * Math.log(h) / (Math.log(endfreq) - Math.log(startfreq));
                        int offset_i = (int)offset;
                        int i5 = 0;
                        while (i5 < outk - offset_i) {
                            int n = i5;
                            outnoise2[n] = outnoise2[n] * (outnoise2[i5 + offset_i] * 100.0 * (double)h * (double)h * (double)h);
                            ++i5;
                        }
                        ++h;
                    }
                    g2.setColor(Color.GREEN);
                    i4 = 0;
                    while (i4 < fftconstanq.getNumberOfOutputBands()) {
                        double magn = outnoise[i4];
                        double magn2 = outnoise2[i4];
                        double logman = Math.log10(magn) * 1.5;
                        double logman2 = Math.log10(magn2) * 1.5;
                        float colormag3 = (float)(1.0 + logman / 8.0);
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        float colormag2 = (float)(1.0 + logman2 / 12.0);
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        colormag3 *= colormag2;
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        }
                        colormag2 = colormag3;
                        float colormag1 = (float)(1.0 + logman / 8.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        g2.setColor(new Color(colormag1, colormag1, colormag1));
                        g2.drawLine(yy, 512 - i4, yy, 512 - i4);
                        ++i4;
                    }
                    if (secounter == 0) {
                        secounter = seclen;
                        g2.setColor(Color.GREEN);
                        g2.drawLine(yy, 512, yy, FFT_Testing.this.panel.getHeight());
                    }
                    --secounter;
                    FFT_Testing.this.panel.repaint();
                }
                g2.setColor(Color.GREEN.darker());
                i = 0;
                while (i < 24) {
                    int y = 512 - i * 24 * 2;
                    g2.drawLine(0, y, FFT_Testing.this.panel.getWidth(), y);
                    double freq = 440.0 * Math.pow(2.0, (double)(i * 12 - 58 + 24) / 12.0);
                    g2.drawString("c" + (1 + i) + " = " + (int)freq + " hz", FFT_Testing.this.panel.getWidth() - 100, y - 5);
                    ++i;
                }
                FFT_Testing.this.panel.repaint();
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processConstantQSpectrumGraph() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                int i;
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                FFTConstantQ fftconstanq = !FFT_Testing.this.q_hires ? FFT_Testing.this.getFFTConstantQ() : FFT_Testing.this.getFFTConstantQ2();
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 1);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int fftlen = fftconstanq.getFFTSize();
                double[] buffer = new double[fftlen];
                int seclen = (int)(samplerate / 1024.0);
                int secounter = 0;
                int yy = 0;
                double[] noise = new double[fftlen];
                double[] outnoise = new double[fftconstanq.getNumberOfOutputBands() * 2];
                while (FFT_Testing.this.process_running) {
                    float colormag1;
                    float colormag2;
                    float colormag3;
                    double logman;
                    double magn;
                    double imag;
                    double real;
                    int len;
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    i = 0;
                    while (i < buffer.length - 1024) {
                        buffer[i] = buffer[i + 1024];
                        ++i;
                    }
                    int i2 = len = audiostream.replace(buffer, buffer.length - 1024, buffer.length);
                    while (i2 < 1024) {
                        buffer[i2 + buffer.length - 1024] = 0.0;
                        ++i2;
                    }
                    if (len == -1) break;
                    i2 = 0;
                    while (i2 < fftlen) {
                        noise[i2] = buffer[i2];
                        ++i2;
                    }
                    fftconstanq.calc(noise, outnoise);
                    g2.setColor(Color.GREEN);
                    if (FFT_Testing.this.q_hires) {
                        i2 = 0;
                        while (i2 < fftconstanq.getNumberOfOutputBands()) {
                            real = outnoise[2 * i2];
                            imag = outnoise[2 * i2 + 1];
                            magn = 2.0 * Math.sqrt(real * real + imag * imag);
                            logman = Math.log10(magn) * 1.5;
                            colormag3 = (float)(1.0 + logman / 16.0);
                            if ((double)colormag3 > 1.0) {
                                colormag3 = 1.0f;
                            } else if ((double)colormag3 < 0.0) {
                                colormag3 = 0.0f;
                            }
                            colormag2 = (float)(1.0 + logman / 8.0);
                            if ((double)colormag2 > 1.0) {
                                colormag2 = 1.0f;
                            } else if ((double)colormag2 < 0.0) {
                                colormag2 = 0.0f;
                            }
                            colormag1 = (float)(1.0 + logman / 4.0);
                            if ((double)colormag1 > 1.0) {
                                colormag1 = 1.0f;
                            } else if ((double)colormag1 < 0.0) {
                                colormag1 = 0.0f;
                            }
                            g2.setColor(new Color(colormag1, colormag2, colormag3));
                            g2.drawLine(yy, 512 - i2, yy, 512 - i2);
                            ++i2;
                        }
                    } else {
                        i2 = 0;
                        while (i2 < fftconstanq.getNumberOfOutputBands() * 2) {
                            real = outnoise[2 * (i2 / 2)];
                            imag = outnoise[2 * (i2 / 2) + 1];
                            magn = 2.0 * Math.sqrt(real * real + imag * imag);
                            logman = Math.log10(magn) * 1.5;
                            colormag3 = (float)(1.0 + logman / 16.0);
                            if ((double)colormag3 > 1.0) {
                                colormag3 = 1.0f;
                            } else if ((double)colormag3 < 0.0) {
                                colormag3 = 0.0f;
                            }
                            colormag2 = (float)(1.0 + logman / 8.0);
                            if ((double)colormag2 > 1.0) {
                                colormag2 = 1.0f;
                            } else if ((double)colormag2 < 0.0) {
                                colormag2 = 0.0f;
                            }
                            colormag1 = (float)(1.0 + logman / 4.0);
                            if ((double)colormag1 > 1.0) {
                                colormag1 = 1.0f;
                            } else if ((double)colormag1 < 0.0) {
                                colormag1 = 0.0f;
                            }
                            g2.setColor(new Color(colormag1, colormag2, colormag3));
                            g2.drawLine(yy, 512 - i2, yy, 512 - i2);
                            ++i2;
                        }
                    }
                    if (secounter == 0) {
                        secounter = seclen;
                        g2.setColor(Color.GREEN);
                        g2.drawLine(yy, 512, yy, FFT_Testing.this.panel.getHeight());
                    }
                    --secounter;
                    FFT_Testing.this.panel.repaint();
                }
                g2.setColor(Color.GREEN.darker());
                i = 0;
                while (i < 24) {
                    int y = 512 - i * 24 * 2;
                    g2.drawLine(0, y, FFT_Testing.this.panel.getWidth(), y);
                    double freq = 440.0 * Math.pow(2.0, (double)(i * 12 - 58 + 24) / 12.0);
                    g2.drawString("c" + (1 + i) + " = " + (int)freq + " hz", FFT_Testing.this.panel.getWidth() - 100, y - 5);
                    ++i;
                }
                FFT_Testing.this.panel.repaint();
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processConstantQSpectrumHarmonicGraph() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                int i;
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                FFTConstantQ fftconstanq = FFT_Testing.this.getFFTConstantQ();
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 1);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int fftlen = fftconstanq.getFFTSize();
                int outk = fftconstanq.getNumberOfOutputBands();
                int harmonic_fftlen = (int)Math.pow(2.0, Math.ceil(Math.log(outk * 2) / Math.log(2.0)));
                FFT harmonic_fft = new FFT(harmonic_fftlen);
                double[] harmonic_buffer = new double[harmonic_fftlen];
                double[] last_value = new double[harmonic_fftlen];
                double[] buffer = new double[fftlen];
                int seclen = (int)(samplerate / 1024.0);
                int secounter = 0;
                int yy = 0;
                double[] noise = new double[fftlen];
                double[] outnoise = new double[fftconstanq.getNumberOfOutputBands() * 2];
                Arrays.fill(noise, 0.0);
                Arrays.fill(outnoise, 0.0);
                while (FFT_Testing.this.process_running) {
                    int len;
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    i = 0;
                    while (i < buffer.length - 1024) {
                        buffer[i] = buffer[i + 1024];
                        ++i;
                    }
                    int i2 = len = audiostream.replace(buffer, buffer.length - 1024, buffer.length);
                    while (i2 < 1024) {
                        buffer[i2 + buffer.length - 1024] = 0.0;
                        ++i2;
                    }
                    if (len == -1) break;
                    i2 = 0;
                    while (i2 < fftlen) {
                        noise[i2] = buffer[i2];
                        ++i2;
                    }
                    fftconstanq.calc(noise, outnoise);
                    Arrays.fill(harmonic_buffer, 0.0);
                    int k = 0;
                    int i3 = 0;
                    while (i3 < fftconstanq.getNumberOfOutputBands()) {
                        double real = outnoise[2 * i3];
                        double imag = outnoise[2 * i3 + 1];
                        harmonic_buffer[k] = 2.0 * Math.sqrt(real * real + imag * imag);
                        ++k;
                        ++i3;
                    }
                    harmonic_fft.calcReal(harmonic_buffer, -1);
                    i3 = 0;
                    while (i3 < harmonic_fftlen) {
                        double b_r = harmonic_buffer[i3];
                        double b_i = harmonic_buffer[i3 + 1];
                        double t_r = b_r;
                        double t_i = b_i;
                        harmonic_buffer[i3] = t_r *= 0.1 + 0.9 * ((double)i3 / (double)harmonic_fftlen);
                        harmonic_buffer[i3 + 1] = t_i *= 0.1 + 0.9 * ((double)i3 / (double)harmonic_fftlen);
                        i3 += 2;
                    }
                    harmonic_fft.calcReal(harmonic_buffer, 1);
                    g2.setColor(Color.GREEN);
                    i3 = 0;
                    while (i3 < harmonic_buffer.length) {
                        harmonic_buffer[i3] = last_value[i3] * 0.6 + harmonic_buffer[i3] * 0.4;
                        last_value[i3] = harmonic_buffer[i3];
                        ++i3;
                    }
                    i3 = 0;
                    while (i3 < harmonic_buffer.length) {
                        double magn1 = harmonic_buffer[i3 / 2] / (double)harmonic_fftlen;
                        double magn2 = 0.4 * harmonic_buffer[i3 / 2 + 24] / (double)harmonic_fftlen;
                        double magn3 = 0.4 * harmonic_buffer[i3 / 2 + 38] / (double)harmonic_fftlen;
                        magn2 += 0.2 * harmonic_buffer[i3 / 2 + 24 - 1] / (double)harmonic_fftlen;
                        magn3 += 0.2 * harmonic_buffer[i3 / 2 + 38 - 1] / (double)harmonic_fftlen;
                        double logman1 = Math.log10(magn1) * 1.5;
                        double logman2 = Math.log10(magn2 += 0.2 * harmonic_buffer[i3 / 2 + 24 + 1] / (double)harmonic_fftlen) * 1.5;
                        double logman3 = Math.log10(magn3 += 0.2 * harmonic_buffer[i3 / 2 + 38 + 1] / (double)harmonic_fftlen) * 1.5;
                        float colormag1 = (float)(1.0 + logman1 / 10.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        float colormag3 = (float)(1.0 + logman3 / 10.0);
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        float colormag2 = (float)(1.0 + logman2 / 10.0);
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        colormag3 *= colormag2 * 2.0f;
                        colormag2 *= colormag2 * 2.0f;
                        colormag2 *= colormag1 * 2.0f;
                        colormag3 *= colormag1 * 2.0f;
                        colormag1 *= colormag1 * 2.0f;
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        }
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        }
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        }
                        g2.setColor(new Color(colormag1, colormag2, colormag3));
                        g2.drawLine(yy, 512 - i3, yy, 512 - i3);
                        ++i3;
                    }
                    if (secounter == 0) {
                        secounter = seclen;
                        g2.setColor(Color.GREEN);
                        g2.drawLine(yy, 512, yy, FFT_Testing.this.panel.getHeight());
                    }
                    --secounter;
                    FFT_Testing.this.panel.repaint();
                }
                g2.setColor(Color.GREEN.darker());
                i = 0;
                while (i < 24) {
                    int y = 512 - i * 24 * 2;
                    g2.drawLine(0, y, FFT_Testing.this.panel.getWidth(), y);
                    double freq = 440.0 * Math.pow(2.0, (double)(i * 12 - 58 + 24) / 12.0);
                    g2.drawString("c" + (1 + i) + " = " + (int)freq + " hz", FFT_Testing.this.panel.getWidth() - 100, y - 5);
                    ++i;
                }
                FFT_Testing.this.panel.repaint();
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processSpectrumGraph() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 1);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int fftlen = 1024;
                double[] buffer = new double[fftlen];
                int seclen = (int)(samplerate / (double)fftlen);
                int secounter = 0;
                FFT fft = new FFT(fftlen);
                double[] window = fft.wHanning();
                int yy = 0;
                double[] noise = new double[fftlen * 2];
                while (FFT_Testing.this.process_running) {
                    int len;
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    if ((len = audiostream.replace(buffer, 0, fftlen)) == -1) break;
                    int i = 0;
                    while (i < len) {
                        noise[i] = buffer[i];
                        ++i;
                    }
                    i = len;
                    while (i < fftlen) {
                        noise[i] = 0.0;
                        ++i;
                    }
                    i = 0;
                    while (i < fftlen) {
                        int n = i;
                        noise[n] = noise[n] * window[i];
                        ++i;
                    }
                    fft.calcReal(noise, -1);
                    g2.setColor(Color.GREEN);
                    i = 0;
                    while (i < 512) {
                        double real = noise[2 * i];
                        double imag = noise[2 * i + 1];
                        double magn = 2.0 * Math.sqrt(real * real + imag * imag);
                        double logman = Math.log10(magn / 512.0) * 2.0;
                        float colormag3 = (float)(1.0 + logman / 16.0);
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        float colormag2 = (float)(1.0 + logman / 8.0);
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        float colormag1 = (float)(1.0 + logman / 4.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        g2.setColor(new Color(colormag1, colormag2, colormag3));
                        g2.drawLine(yy, 512 - i, yy, 512 - i);
                        ++i;
                    }
                    if (secounter == 0) {
                        secounter = seclen;
                        g2.setColor(Color.GREEN);
                        g2.drawLine(yy, 512, yy, FFT_Testing.this.panel.getHeight());
                    }
                    --secounter;
                    FFT_Testing.this.panel.repaint();
                }
                g2.setColor(Color.GREEN.darker());
                int i = 0;
                while (i < 24) {
                    int y = 512 - (int)((double)(i * 2) * 1000.0 / samplerate * 512.0);
                    g2.drawLine(0, y, FFT_Testing.this.panel.getWidth(), y);
                    ++i;
                }
                FFT_Testing.this.panel.repaint();
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processSpectrumGraphDFT() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                double[] buffer = new double[4096];
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 1);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int seclen = (int)(samplerate / 1024.0);
                int secounter = 0;
                LogDFT fft = new LogDFT(1024);
                int yy = 0;
                while (FFT_Testing.this.process_running) {
                    int len;
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    if ((len = audiostream.replace(buffer, 0, 1024)) == -1) break;
                    double[] noise = new double[2048];
                    int i = 0;
                    while (i < len) {
                        noise[2 * i] = buffer[i];
                        noise[2 * i + 1] = 0.0;
                        ++i;
                    }
                    i = len;
                    while (i < 1024) {
                        noise[2 * i] = 0.0;
                        noise[2 * i + 1] = 0.0;
                        ++i;
                    }
                    fft.calcLOGDFT(noise);
                    g2.setColor(Color.GREEN);
                    i = 0;
                    while (i < 512) {
                        double real = noise[2 * i];
                        double imag = noise[2 * i + 1];
                        double magn = 2.0 * Math.sqrt(real * real + imag * imag);
                        double logman = Math.log10(magn / 512.0) * 2.0;
                        float colormag3 = (float)(1.0 + logman / 16.0);
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        float colormag2 = (float)(1.0 + logman / 8.0);
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        float colormag1 = (float)(1.0 + logman / 4.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        g2.setColor(new Color(colormag1, colormag2, colormag3));
                        g2.drawLine(yy, 512 - i, yy, 512 - i);
                        ++i;
                    }
                    if (secounter == 0) {
                        secounter = seclen;
                        g2.setColor(Color.GREEN);
                        g2.drawLine(yy, 512, yy, FFT_Testing.this.panel.getHeight());
                    }
                    --secounter;
                    FFT_Testing.this.panel.repaint();
                }
                g2.setColor(Color.GREEN.darker());
                int i = 0;
                while (i < 24) {
                    int y = 512 - (int)((double)(i * 2) * 1000.0 / samplerate * 512.0);
                    g2.drawLine(0, y, FFT_Testing.this.panel.getWidth(), y);
                    ++i;
                }
                FFT_Testing.this.panel.repaint();
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processSpectrumGraphP() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                double[] buffer = new double[4096];
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 1);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int seclen = (int)(samplerate / 1024.0);
                int secounter = 0;
                FFT fft = new FFT(1024);
                double[] window = fft.wHanning();
                int yy = 0;
                while (FFT_Testing.this.process_running) {
                    int len;
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    if ((len = audiostream.replace(buffer, 0, 1024)) == -1) break;
                    double[] noise = new double[1024];
                    int i = 0;
                    while (i < len) {
                        noise[i] = buffer[i];
                        ++i;
                    }
                    i = len;
                    while (i < 1024) {
                        noise[i] = 0.0;
                        ++i;
                    }
                    i = 0;
                    while (i < 1024) {
                        int n = i;
                        noise[n] = noise[n] * window[i];
                        ++i;
                    }
                    fft.calcReal(noise, -1);
                    g2.setColor(Color.GREEN);
                    i = 0;
                    while (i < 512) {
                        double real = noise[2 * i];
                        double imag = noise[2 * i + 1];
                        double magn = 2.0 * Math.sqrt(real * real + imag * imag);
                        double phase = Math.atan2(imag, real);
                        double logman = Math.log10(magn / 512.0) * 2.0;
                        float colormag1 = (float)(1.0 + logman / 16.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        double f_phase = (phase / (Math.PI * 2) % 1.0 + 1.0) % 1.0;
                        float red = (float)((double)colormag1 * f_phase);
                        float green = (float)((double)colormag1 * (1.0 - f_phase));
                        if (red < 0.0f) {
                            red = 0.0f;
                        }
                        if (red > 1.0f) {
                            red = 1.0f;
                        }
                        if (green < 0.0f) {
                            green = 0.0f;
                        }
                        if (green > 1.0f) {
                            green = 1.0f;
                        }
                        g2.setColor(new Color(red, green, colormag1));
                        g2.drawLine(yy, 512 - i, yy, 512 - i);
                        ++i;
                    }
                    if (secounter == 0) {
                        secounter = seclen;
                        g2.setColor(Color.GREEN);
                        g2.drawLine(yy, 512, yy, FFT_Testing.this.panel.getHeight());
                    }
                    --secounter;
                    FFT_Testing.this.panel.repaint();
                }
                g2.setColor(Color.GREEN.darker());
                int i = 0;
                while (i < 24) {
                    int y = 512 - (int)((double)(i * 2) * 1000.0 / samplerate * 512.0);
                    g2.drawLine(0, y, FFT_Testing.this.panel.getWidth(), y);
                    ++i;
                }
                FFT_Testing.this.panel.repaint();
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processSpectrumGraph2() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                double[] buffer = new double[4096];
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 1);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int seclen = (int)(samplerate / 1024.0);
                int secounter = 0;
                FFT fft = new FFT(1024);
                double[] window = fft.wHanning();
                int yy = 0;
                while (FFT_Testing.this.process_running) {
                    int len;
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    if ((len = audiostream.replace(buffer, 0, 1024)) == -1) break;
                    double[] noise = new double[2048];
                    int i = 0;
                    while (i < len) {
                        noise[2 * i] = buffer[i];
                        noise[2 * i + 1] = 0.0;
                        ++i;
                    }
                    i = len;
                    while (i < 1024) {
                        noise[2 * i] = 0.0;
                        noise[2 * i + 1] = 0.0;
                        ++i;
                    }
                    i = 0;
                    while (i < 1024) {
                        int n = i * 2;
                        noise[n] = noise[n] * window[i];
                        ++i;
                    }
                    fft.calc(noise, -1);
                    fft.calc(noise, -1);
                    fft.calc(noise, -1);
                    g2.setColor(Color.GREEN);
                    i = 0;
                    while (i < 512) {
                        double real = noise[2 * i];
                        double imag = noise[2 * i + 1];
                        double magn = 2.0 * Math.sqrt(real * real + imag * imag);
                        double logman = Math.log10(magn / 512.0) * 2.0;
                        float colormag3 = (float)(1.0 + logman / 16.0);
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        float colormag2 = (float)(1.0 + logman / 8.0);
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        float colormag1 = (float)(1.0 + logman / 4.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        g2.setColor(new Color(colormag1, colormag2, colormag3));
                        g2.drawLine(yy, 512 - i, yy, 512 - i);
                        ++i;
                    }
                    if (secounter == 0) {
                        secounter = seclen;
                        g2.setColor(Color.GREEN);
                        g2.drawLine(yy, 512, yy, FFT_Testing.this.panel.getHeight());
                    }
                    --secounter;
                    FFT_Testing.this.panel.repaint();
                }
                g2.setColor(Color.GREEN.darker());
                int i = 0;
                while (i < 24) {
                    int y = 512 - (int)((double)(i * 2) * 1000.0 / samplerate * 512.0);
                    g2.drawLine(0, y, FFT_Testing.this.panel.getWidth(), y);
                    ++i;
                }
                FFT_Testing.this.panel.repaint();
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processSpectrumGraphLog() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 1);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int seclen = (int)(samplerate / 1024.0);
                int secounter = 0;
                FFT fft = new FFT(4096);
                FFT fft2 = new FFT(8192);
                FFT fft3 = new FFT(16384);
                double[] window = fft.wHanning();
                double[] window2 = fft2.wHanning();
                double[] window3 = fft3.wHanning();
                double[] noise = new double[4096];
                double[] noise2 = new double[8192];
                double[] noise3 = new double[16384];
                double[] buffer = new double[16384];
                audiostream.replace(buffer, 1024, buffer.length);
                int yy = 0;
                while (FFT_Testing.this.process_running) {
                    int xx2;
                    int xx;
                    double ii2;
                    double ii;
                    float colormag1;
                    float colormag2;
                    float colormag3;
                    double logman;
                    double magn;
                    double imag;
                    double real;
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    int i = 0;
                    while (i < buffer.length - 1024) {
                        buffer[i] = buffer[i + 1024];
                        ++i;
                    }
                    int len = audiostream.replace(buffer, buffer.length - 1024, buffer.length);
                    if (len == -1) break;
                    int i2 = 0;
                    while (i2 < len * 4) {
                        noise[i2] = buffer[i2 + 7000] * window[i2];
                        ++i2;
                    }
                    i2 = len * 4;
                    while (i2 < 1024) {
                        noise[i2] = 0.0;
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < len * 8) {
                        noise2[i2] = buffer[i2 + 7000] * window2[i2];
                        ++i2;
                    }
                    i2 = len * 8;
                    while (i2 < 4096) {
                        noise2[i2] = 0.0;
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < len * 16) {
                        noise3[i2] = buffer[i2] * window3[i2];
                        ++i2;
                    }
                    i2 = len * 16;
                    while (i2 < 16384) {
                        noise3[i2] = 0.0;
                        ++i2;
                    }
                    fft.calcReal(noise, -1);
                    fft2.calcReal(noise2, -1);
                    fft3.calcReal(noise3, -1);
                    g2.setColor(Color.GREEN);
                    i2 = 128;
                    while (i2 < 2048) {
                        real = noise[2 * i2];
                        imag = noise[2 * i2 + 1];
                        magn = 2.0 * Math.sqrt(real * real + imag * imag);
                        logman = Math.log10(magn / 512.0) * 2.0;
                        colormag3 = (float)(1.0 + logman / 16.0);
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        colormag2 = (float)(1.0 + logman / 8.0);
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        colormag1 = (float)(1.0 + logman / 4.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        g2.setColor(new Color(colormag1, colormag2, colormag3));
                        if (i2 > 1) {
                            ii = (double)i2 / 4.0;
                            ii2 = (double)(i2 + 1) / 4.0;
                            xx = (int)(-60.0 * (Math.log(ii) - Math.log(512.0)) / Math.log(2.0));
                            xx2 = (int)(-60.0 * (Math.log(ii2) - Math.log(512.0)) / Math.log(2.0));
                            g2.drawLine(yy, xx, yy, xx2);
                        }
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < 256) {
                        real = noise2[2 * i2];
                        imag = noise2[2 * i2 + 1];
                        magn = 2.0 * Math.sqrt(real * real + imag * imag);
                        logman = Math.log10(magn / 512.0) * 2.0;
                        colormag3 = (float)(1.0 + logman / 16.0);
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        colormag2 = (float)(1.0 + logman / 8.0);
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        colormag1 = (float)(1.0 + logman / 4.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        g2.setColor(new Color(colormag1, colormag2, colormag3));
                        if (i2 > 1) {
                            ii = (double)i2 / 8.0;
                            ii2 = (double)(i2 + 1) / 8.0;
                            xx = (int)(-60.0 * (Math.log(ii) - Math.log(512.0)) / Math.log(2.0));
                            xx2 = (int)(-60.0 * (Math.log(ii2) - Math.log(512.0)) / Math.log(2.0));
                            g2.drawLine(yy, xx, yy, xx2);
                        }
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < 128) {
                        real = noise3[2 * i2];
                        imag = noise3[2 * i2 + 1];
                        magn = 2.0 * Math.sqrt(real * real + imag * imag);
                        logman = Math.log10(magn / 512.0) * 2.0;
                        colormag3 = (float)(1.0 + logman / 16.0);
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        colormag2 = (float)(1.0 + logman / 8.0);
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        colormag1 = (float)(1.0 + logman / 4.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        g2.setColor(new Color(colormag1, colormag2, colormag3));
                        if (i2 > 1) {
                            ii = (double)i2 / 16.0;
                            ii2 = (double)(i2 + 1) / 16.0;
                            xx = (int)(-60.0 * (Math.log(ii) - Math.log(512.0)) / Math.log(2.0));
                            xx2 = (int)(-60.0 * (Math.log(ii2) - Math.log(512.0)) / Math.log(2.0));
                            g2.drawLine(yy, xx, yy, xx2);
                        }
                        ++i2;
                    }
                    if (secounter == 0) {
                        secounter = seclen;
                        g2.setColor(Color.GREEN);
                        g2.drawLine(yy, 512, yy, FFT_Testing.this.panel.getHeight());
                    }
                    --secounter;
                    FFT_Testing.this.panel.repaint();
                }
                FFT_Testing.this.panel.repaint();
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processFrequencyResponse() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                double samplerate = 44100.0;
                double[] buffer = new double[4096];
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 1);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                FFT fft = new FFT(4096);
                double[] noise = buffer;
                double[] window = fft.wHanning();
                while (FFT_Testing.this.process_running) {
                    int y;
                    int x;
                    int len = audiostream.replace(buffer, 0, 4096);
                    if (len == -1) break;
                    g2.setColor(Color.BLACK);
                    g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    g2.setColor(Color.RED);
                    int w = FFT_Testing.this.panel.getWidth();
                    g2.setColor(Color.RED.darker());
                    int sx = 0;
                    int sy = 25;
                    int i = 0;
                    while (i < 4096) {
                        x = (int)((double)(i * w) / 4096.0);
                        y = (int)(noise[i] * 7.0 + 20.0);
                        g2.drawLine(sx, sy, x, y);
                        sx = x;
                        sy = y;
                        ++i;
                    }
                    g2.drawLine(0, 13, w, 13);
                    g2.drawLine(0, 27, w, 27);
                    sx = 0;
                    sy = 25;
                    g2.setColor(Color.YELLOW.darker());
                    i = 0;
                    while (i < 4096) {
                        int n = i;
                        noise[n] = noise[n] * window[i];
                        x = (int)((double)(i * w) / 4096.0);
                        y = (int)(window[i] * 7.0 + 20.0);
                        g2.drawLine(sx, sy, x, y);
                        g2.drawLine(sx, 20 - (sy - 20), x, 20 - (y - 20));
                        sx = x;
                        sy = y;
                        ++i;
                    }
                    g2.setColor(Color.YELLOW);
                    sx = 0;
                    sy = 25;
                    i = 0;
                    while (i < 4096) {
                        x = (int)((double)(i * w) / 4096.0);
                        y = (int)(noise[i] * 7.0 + 20.0);
                        g2.drawLine(sx, sy, x, y);
                        sx = x;
                        sy = y;
                        ++i;
                    }
                    g2.setColor(Color.BLUE);
                    g2.drawLine(0, 100, w, 100);
                    int s = 62;
                    g2.drawLine(0, 100 + s, w, 100 + s);
                    g2.drawLine(0, 100 - s, w, 100 - s);
                    fft.calcReal(noise, -1);
                    double fftstart = 220.0;
                    double fftscale = -10.0;
                    g2.setColor(Color.GREEN.darker().darker().darker().darker());
                    double logman = Math.log10(1.0) * 2.0;
                    int s2 = (int)(fftstart + logman * fftscale);
                    g2.drawLine(0, s2, w - 40, s2);
                    int i2 = 0;
                    while (i2 < 32) {
                        s2 = (int)(fftstart + (double)(-(1 * i2)) * fftscale);
                        g2.drawLine(0, s2, w - 40, s2);
                        ++i2;
                    }
                    g2.setColor(Color.GREEN.darker().darker());
                    i2 = 0;
                    while (i2 < 23) {
                        double freq = i2 * 1000;
                        int f = (int)(freq * 2.0 / samplerate * (double)w);
                        g2.drawLine(f, (int)(fftstart + 0.0 * fftscale), f, (int)(fftstart + -31.0 * fftscale));
                        g2.drawString(String.valueOf(i2) + "kHz", f, (int)(fftstart - 2.0));
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < 32) {
                        s2 = (int)(fftstart + (double)(-(1 * i2)) * fftscale);
                        g2.drawString(String.valueOf(-i2 * 10) + "dB", w - 40, s2 + 1);
                        g2.drawLine(0, s2, w - 40, s2);
                        i2 += 2;
                    }
                    g2.setColor(Color.GREEN);
                    int lx = 0;
                    int ly = 100;
                    int px = 0;
                    int py = 50;
                    int i3 = 0;
                    while (i3 < 2048) {
                        double real = noise[2 * i3];
                        double imag = noise[2 * i3 + 1];
                        double magn = 2.0 * Math.sqrt(real * real + imag * imag);
                        double phase = Math.atan2(imag, real);
                        g2.setColor(Color.GREEN);
                        int x2 = (int)((double)(i3 * w) / 2048.0);
                        double logman2 = Math.log10(magn / 2048.0) * 2.0;
                        int y2 = (int)(fftstart + logman2 * fftscale);
                        if (i3 == 0) {
                            lx = x2;
                            ly = y2;
                        }
                        g2.drawLine(lx, ly, x2, y2);
                        lx = x2;
                        ly = y2;
                        g2.setColor(Color.RED);
                        x2 = (int)((double)(i3 * w) / 2048.0);
                        y2 = (int)(phase * 20.0) + 100;
                        if (i3 == 0) {
                            px = x2;
                            py = y2;
                        }
                        g2.drawLine(px, py, x2, y2);
                        px = x2;
                        py = y2;
                        ++i3;
                    }
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(this){
                            final /* synthetic */ 16 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                16.access$0(this.this$1).panel.repaint();
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }

            static /* synthetic */ FFT_Testing access$0(16 var0) {
                return var0.FFT_Testing.this;
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processLogFrequencyResponse() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                FFTConstantQ fftconstanq = !FFT_Testing.this.q_hires ? FFT_Testing.this.getFFTConstantQ() : FFT_Testing.this.getFFTConstantQ2();
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 1);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int fftlen = fftconstanq.getFFTSize();
                int outk = fftconstanq.getNumberOfOutputBands();
                int harmonic_fftlen = (int)Math.pow(2.0, Math.ceil(Math.log(outk * 2) / Math.log(2.0)));
                double startfreq = 440.0 * Math.pow(2.0, -2.8333333333333335);
                double endfreq = samplerate / 2.0;
                double disp75hz = (Math.log(75.0) - Math.log(startfreq)) / (Math.log(endfreq) - Math.log(startfreq));
                double disp100hz = (Math.log(100.0) - Math.log(startfreq)) / (Math.log(endfreq) - Math.log(startfreq));
                double disp250hz = (Math.log(250.0) - Math.log(startfreq)) / (Math.log(endfreq) - Math.log(startfreq));
                double disp500hz = (Math.log(500.0) - Math.log(startfreq)) / (Math.log(endfreq) - Math.log(startfreq));
                double disp1000hz = (Math.log(1000.0) - Math.log(startfreq)) / (Math.log(endfreq) - Math.log(startfreq));
                double disp2500hz = (Math.log(2500.0) - Math.log(startfreq)) / (Math.log(endfreq) - Math.log(startfreq));
                double disp5000hz = (Math.log(5000.0) - Math.log(startfreq)) / (Math.log(endfreq) - Math.log(startfreq));
                double disp10000hz = (Math.log(10000.0) - Math.log(startfreq)) / (Math.log(endfreq) - Math.log(startfreq));
                AffineTransform xform = AffineTransform.getTranslateInstance(50.0, 50.0);
                xform.scale(20.0, 20.0);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                double[] harmonic_buffer = new double[harmonic_fftlen];
                int runsum_len = 3;
                int runsum_cur = 0;
                double[] buffer = new double[fftlen];
                int yy = 0;
                double[] noise = new double[fftlen];
                double[] outnoise = new double[fftconstanq.getNumberOfOutputBands() * 2];
                Arrays.fill(noise, 0.0);
                Arrays.fill(outnoise, 0.0);
                while (FFT_Testing.this.process_running) {
                    double val;
                    int len;
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    int i = 0;
                    while (i < buffer.length - 4096) {
                        buffer[i] = buffer[i + 4096];
                        ++i;
                    }
                    int i2 = len = audiostream.replace(buffer, buffer.length - 4096, buffer.length);
                    while (i2 < 4096) {
                        buffer[i2 + buffer.length - 4096] = 0.0;
                        ++i2;
                    }
                    if (len == -1) break;
                    i2 = 0;
                    while (i2 < fftlen) {
                        noise[i2] = buffer[i2];
                        ++i2;
                    }
                    fftconstanq.calc(noise, outnoise);
                    Arrays.fill(harmonic_buffer, 0.0);
                    int k = 0;
                    int i3 = 0;
                    while (i3 < fftconstanq.getNumberOfOutputBands()) {
                        double real = outnoise[2 * i3];
                        double imag = outnoise[2 * i3 + 1];
                        harmonic_buffer[k] = 2.0 * Math.sqrt(real * real + imag * imag);
                        ++k;
                        ++i3;
                    }
                    g2.setColor(Color.GREEN);
                    g2.setColor(Color.BLACK);
                    g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    g2.setColor(Color.RED);
                    int lx = 0;
                    int ly = 100;
                    double fftstart = 100.0;
                    double fftscale = -10.0;
                    int w = FFT_Testing.this.panel.getWidth();
                    g2.setColor(Color.GREEN.darker().darker());
                    g2.drawString("FFT Size = " + fftconstanq.getFFTSize(), 20, 20);
                    g2.drawString("Q bands  = " + fftconstanq.getNumberOfOutputBands(), 20, 40);
                    g2.setColor(Color.GREEN.darker().darker().darker().darker());
                    double logman = 0.0;
                    int s = (int)(fftstart + logman * fftscale);
                    g2.drawLine(0, s, w - 40, s);
                    int i4 = 0;
                    while (i4 < 32) {
                        s = (int)(fftstart + (double)(-(1 * i4)) * fftscale);
                        g2.drawLine(0, s, w - 40, s);
                        ++i4;
                    }
                    g2.setColor(Color.GREEN.darker().darker());
                    i4 = 0;
                    while (i4 < 10) {
                        double freq = 0.0;
                        if (i4 == 0) {
                            freq = disp75hz;
                        }
                        if (i4 == 1) {
                            freq = disp100hz;
                        }
                        if (i4 == 2) {
                            freq = disp250hz;
                        }
                        if (i4 == 3) {
                            freq = disp500hz;
                        }
                        if (i4 == 4) {
                            freq = disp1000hz;
                        }
                        if (i4 == 5) {
                            freq = disp2500hz;
                        }
                        if (i4 == 6) {
                            freq = disp5000hz;
                        }
                        if (i4 == 7) {
                            freq = disp10000hz;
                        }
                        int f = (int)(freq * (double)w);
                        g2.drawLine(f, (int)(fftstart + 0.0 * fftscale), f, (int)(fftstart + -31.0 * fftscale));
                        if (i4 == 0) {
                            g2.drawString("75 hz", f, (int)(fftstart - 2.0));
                        }
                        if (i4 == 1) {
                            g2.drawString("100 hz", f, (int)(fftstart - 2.0));
                        }
                        if (i4 == 2) {
                            g2.drawString("250 hz", f, (int)(fftstart - 2.0));
                        }
                        if (i4 == 3) {
                            g2.drawString("500 hz", f, (int)(fftstart - 2.0));
                        }
                        if (i4 == 4) {
                            g2.drawString("1 kHz", f, (int)(fftstart - 2.0));
                        }
                        if (i4 == 5) {
                            g2.drawString("2.5 kHz", f, (int)(fftstart - 2.0));
                        }
                        if (i4 == 6) {
                            g2.drawString("5 kHz", f, (int)(fftstart - 2.0));
                        }
                        if (i4 == 7) {
                            g2.drawString("10 kHz", f, (int)(fftstart - 2.0));
                        }
                        ++i4;
                    }
                    i4 = 0;
                    while (i4 < 32) {
                        s = (int)(fftstart + (double)(-(1 * i4)) * fftscale);
                        g2.drawString(String.valueOf(-i4 * 10) + "dB", w - 40, s + 1);
                        g2.drawLine(0, s, w - 40, s);
                        i4 += 2;
                    }
                    int hlen = outnoise.length / 2;
                    int max = fftconstanq.getNumberOfOutputBands();
                    g2.setColor(Color.GREEN);
                    int i5 = 0;
                    while (i5 < max - 2) {
                        double magn = 2.0 * harmonic_buffer[i5] / (double)harmonic_fftlen;
                        int x = (int)((double)i5 * (double)w / (double)hlen);
                        double logman2 = Math.log10(magn * 500.0) * 2.0;
                        int y = (int)(fftstart + logman2 * fftscale);
                        if (i5 == 0) {
                            lx = x;
                            ly = y;
                        }
                        g2.drawLine(lx, ly, x, y);
                        lx = x;
                        ly = y;
                        ++i5;
                    }
                    i5 = 0;
                    while (i5 < max - 2) {
                        double logman3;
                        double magn = 2.0 * harmonic_buffer[i5] / (double)harmonic_fftlen;
                        harmonic_buffer[i5] = logman3 = Math.log10(magn * 500.0) * 2.0;
                        ++i5;
                    }
                    g2.setColor(Color.PINK);
                    double lastval = harmonic_buffer[0];
                    double lowerby = 0.1;
                    int i6 = 0;
                    while (i6 < max - 2) {
                        val = harmonic_buffer[i6];
                        if (val > (lastval -= lowerby)) {
                            lastval = val;
                        }
                        harmonic_buffer[i6] = lastval;
                        ++i6;
                    }
                    i6 = max - 3;
                    while (i6 >= 0) {
                        val = harmonic_buffer[i6];
                        if (val > (lastval -= lowerby)) {
                            lastval = val;
                        }
                        harmonic_buffer[i6] = lastval;
                        --i6;
                    }
                    lastval = harmonic_buffer[3];
                    double lastval2 = 0.0;
                    int ly2 = 0;
                    int i7 = 3;
                    while (i7 < max - 2 - 3) {
                        double logman4 = harmonic_buffer[i7];
                        int x = (int)((double)i7 * (double)w / (double)hlen);
                        int y = (int)(fftstart + logman4 * fftscale);
                        if (i7 == 3) {
                            lx = x;
                            ly = y;
                        }
                        g2.drawLine(lx, ly, x, y);
                        double diff = logman4 - lastval;
                        double diffdiff = diff - lastval2;
                        lastval2 = diff;
                        if (diffdiff > 0.0) {
                            diffdiff = 0.0;
                        }
                        diffdiff = -diffdiff;
                        int y2 = (int)(fftstart + 200.0 + diffdiff * fftscale * 10.0);
                        if (i7 == 3) {
                            ly2 = y2;
                        }
                        g2.drawLine(lx, ly2, x, y2);
                        ly2 = y2;
                        lastval = logman4;
                        lx = x;
                        ly = y;
                        ++i7;
                    }
                    runsum_cur = (runsum_cur + 1) % runsum_len;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(this){
                            final /* synthetic */ 18 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                18.access$0(this.this$1).panel.repaint();
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }

            static /* synthetic */ FFT_Testing access$0(18 var0) {
                return var0.FFT_Testing.this;
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public void processOctaveNoteMatrix() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.showFFTPanel();
        Runnable runnable = new Runnable(){

            public void run() {
                Graphics2D g2 = FFT_Testing.this.offImg.createGraphics();
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                g2.setColor(Color.RED);
                double samplerate = 44100.0;
                FFTConstantQ fftconstanq = FFT_Testing.this.getFFTConstantQ();
                Interpreter interpreter = new Interpreter();
                String script = FFT_Testing.this.textarea.getText();
                try {
                    interpreter.eval(script);
                }
                catch (ScriptParserException e) {
                    e.printStackTrace();
                }
                AudioSession audiosession = new AudioSession(samplerate, 1);
                AudioStream audiostream = AudioEvents.openStream(interpreter.get("output"), audiosession);
                int ww = FFT_Testing.this.panel.getWidth();
                int fftlen = fftconstanq.getFFTSize();
                int outk = fftconstanq.getNumberOfOutputBands();
                int harmonic_fftlen = (int)Math.pow(2.0, Math.ceil(Math.log(outk * 2) / Math.log(2.0)));
                int[] matriximagedata = new int[harmonic_fftlen / 2];
                MemoryImageSource mis = new MemoryImageSource(24, 10, matriximagedata, 0, 24);
                AffineTransform xform = AffineTransform.getTranslateInstance(50.0, 50.0);
                xform.scale(20.0, 20.0);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                double[] harmonic_buffer = new double[harmonic_fftlen];
                double[] buffer = new double[fftlen];
                int yy = 0;
                double[] noise = new double[fftlen];
                double[] outnoise = new double[fftconstanq.getNumberOfOutputBands() * 2];
                Arrays.fill(noise, 0.0);
                Arrays.fill(outnoise, 0.0);
                while (FFT_Testing.this.process_running) {
                    int len;
                    if (++yy == ww) {
                        yy = 0;
                        g2.setColor(Color.BLACK);
                        g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    }
                    int i = 0;
                    while (i < buffer.length - 4096) {
                        buffer[i] = buffer[i + 4096];
                        ++i;
                    }
                    int i2 = len = audiostream.replace(buffer, buffer.length - 4096, buffer.length);
                    while (i2 < 4096) {
                        buffer[i2 + buffer.length - 4096] = 0.0;
                        ++i2;
                    }
                    if (len == -1) break;
                    i2 = 0;
                    while (i2 < fftlen) {
                        noise[i2] = buffer[i2];
                        ++i2;
                    }
                    fftconstanq.calc(noise, outnoise);
                    Arrays.fill(harmonic_buffer, 0.0);
                    int k = 0;
                    int i3 = 0;
                    while (i3 < fftconstanq.getNumberOfOutputBands()) {
                        double real = outnoise[2 * i3];
                        double imag = outnoise[2 * i3 + 1];
                        harmonic_buffer[k] = 2.0 * Math.sqrt(real * real + imag * imag);
                        ++k;
                        ++i3;
                    }
                    g2.setColor(Color.GREEN);
                    g2.setColor(Color.BLACK);
                    g2.fillRect(0, 0, FFT_Testing.this.panel.getWidth(), FFT_Testing.this.panel.getHeight());
                    g2.setColor(Color.RED);
                    int m = 0;
                    int i4 = 0;
                    while (i4 < harmonic_buffer.length / 2) {
                        double magn1 = harmonic_buffer[i4] / (double)harmonic_fftlen;
                        double logman1 = Math.log10(magn1);
                        float colormag1 = (float)(1.0 + logman1 / 8.0);
                        if ((double)colormag1 > 1.0) {
                            colormag1 = 1.0f;
                        } else if ((double)colormag1 < 0.0) {
                            colormag1 = 0.0f;
                        }
                        float colormag2 = (float)(1.0 + logman1 / 12.0);
                        if ((double)colormag2 > 1.0) {
                            colormag2 = 1.0f;
                        } else if ((double)colormag2 < 0.0) {
                            colormag2 = 0.0f;
                        }
                        float colormag3 = (float)(1.0 + logman1 / 16.0);
                        if ((double)colormag3 > 1.0) {
                            colormag3 = 1.0f;
                        } else if ((double)colormag3 < 0.0) {
                            colormag3 = 0.0f;
                        }
                        int value1 = (int)(colormag1 * colormag1 * 255.0f);
                        int value2 = (int)(colormag2 * colormag2 * 255.0f);
                        int value3 = (int)(colormag3 * colormag3 * 255.0f);
                        matriximagedata[m++] = value3 | value2 << 8 | value1 << 16 | 0xFF000000;
                        ++i4;
                    }
                    Image matriximage = FFT_Testing.this.createImage(mis);
                    g2.drawImage(matriximage, xform, null);
                    g2.setColor(Color.GREEN);
                    g2.drawString("C", 55, 35);
                    g2.drawString("C#", 95, 35);
                    g2.drawString("D", 135, 35);
                    g2.drawString("D#", 175, 35);
                    g2.drawString("E", 215, 35);
                    g2.drawString("F", 255, 35);
                    g2.drawString("F#", 295, 35);
                    g2.drawString("G", 335, 35);
                    g2.drawString("G#", 375, 35);
                    g2.drawString("A", 415, 35);
                    g2.drawString("A#", 455, 35);
                    g2.drawString("B", 495, 35);
                    g2.drawString("1", 35, 55);
                    g2.drawString("2", 35, 75);
                    g2.drawString("3", 35, 95);
                    g2.drawString("4", 35, 115);
                    g2.drawString("5", 35, 135);
                    g2.drawString("6", 35, 155);
                    g2.drawString("7", 35, 175);
                    g2.drawString("8", 35, 195);
                    g2.drawString("9", 35, 215);
                    g2.drawString("10", 35, 235);
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(this){
                            final /* synthetic */ 20 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                20.access$0(this.this$1).panel.repaint();
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                audiostream.close();
                interpreter.close();
                FFT_Testing.this.process_running = false;
                FFT_Testing.this.hideFFTPanel();
            }

            static /* synthetic */ FFT_Testing access$0(20 var0) {
                return var0.FFT_Testing.this;
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    public FFT_Testing() {
        this.textarea.setDocument(new RSyntaxDocument(this.globalinterpreter));
        this.textarea.setFont(new Font("Courier", 0, 12));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = this.getClass().getResourceAsStream("/uk/co/drpj/testing/Synth.r");
        try {
            try {
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, len);
                }
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.textarea.replaceSelection(new String(baos.toByteArray(), "LATIN1"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        Document doc = this.textarea.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent evt) {
                FFT_Testing.this.undo.addEdit(evt.getEdit());
            }
        });
        ActionMap textarea_actionmap = this.textarea.getActionMap();
        InputMap textarea_inputmap = this.textarea.getInputMap();
        textarea_inputmap.put(KeyStroke.getKeyStroke("control Z"), "Undo");
        textarea_inputmap.put(KeyStroke.getKeyStroke("control Y"), "Redo");
        textarea_actionmap.put("Undo", new AbstractAction("Undo"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (FFT_Testing.this.undo.canUndo()) {
                        FFT_Testing.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        textarea_actionmap.put("Redo", new AbstractAction("Redo"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (FFT_Testing.this.undo.canRedo()) {
                        FFT_Testing.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        JMenu file_menu = menubar.add(new JMenu("File"));
        JMenuItem exit_menuitem = file_menu.add(new JMenuItem("Exit"));
        exit_menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                System.exit(0);
            }
        });
        JMenu edit_menu = menubar.add(new JMenu("Edit"));
        JMenuItem menu_undo = new JMenuItem("Undo");
        menu_undo.setMnemonic('U');
        menu_undo.setAccelerator(KeyStroke.getKeyStroke("control Z"));
        menu_undo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (FFT_Testing.this.undo.canUndo()) {
                        FFT_Testing.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        JMenuItem menu_cut = new JMenuItem("Cut");
        menu_cut.setMnemonic('t');
        menu_cut.setAccelerator(KeyStroke.getKeyStroke("control X"));
        menu_cut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.textarea.cut();
            }
        });
        JMenuItem menu_copy = new JMenuItem("Copy");
        menu_copy.setMnemonic('C');
        menu_copy.setAccelerator(KeyStroke.getKeyStroke("control C"));
        menu_copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.textarea.copy();
            }
        });
        JMenuItem menu_paste = new JMenuItem("Paste");
        menu_paste.setMnemonic('P');
        menu_paste.setAccelerator(KeyStroke.getKeyStroke("control V"));
        menu_paste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.textarea.paste();
            }
        });
        JMenuItem menu_delete = new JMenuItem("Delete");
        menu_delete.setMnemonic('D');
        menu_delete.setAccelerator(KeyStroke.getKeyStroke("DELETE"));
        menu_delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.textarea.replaceSelection("");
            }
        });
        JMenuItem menu_selectAll = new JMenuItem("Select All");
        menu_selectAll.setMnemonic('A');
        menu_selectAll.setAccelerator(KeyStroke.getKeyStroke("control A"));
        menu_selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.textarea.selectAll();
            }
        });
        JMenuItem menu_arguments = new JMenuItem("Arguments...");
        menu_arguments.setAccelerator(KeyStroke.getKeyStroke("F4"));
        menu_arguments.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    int start = FFT_Testing.this.textarea.getSelectionStart();
                    int[] pair = ((RSyntaxDocument)FFT_Testing.this.textarea.getDocument()).extractFunctionCall(start);
                    if (pair == null) {
                        return;
                    }
                    FFT_Testing.this.textarea.select(pair[0], pair[0] + pair[1]);
                    String token = FFT_Testing.this.textarea.getDocument().getText(pair[0], pair[1]);
                    String expr = FunctionCallEditor.editFunctionCall(FFT_Testing.this, token, FFT_Testing.this.globalinterpreter);
                    if (expr != null) {
                        FFT_Testing.this.textarea.replaceSelection(expr);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        edit_menu.add(menu_undo);
        edit_menu.addSeparator();
        edit_menu.add(menu_cut);
        edit_menu.add(menu_copy);
        edit_menu.add(menu_paste);
        edit_menu.add(menu_delete);
        edit_menu.addSeparator();
        edit_menu.add(menu_selectAll);
        edit_menu.addSeparator();
        edit_menu.add(menu_arguments);
        JMenu run_menu = menubar.add(new JMenu("Run"));
        JMenuItem start_menuitem = run_menu.add(new JMenuItem("Run"));
        start_menuitem.setAccelerator(KeyStroke.getKeyStroke("F5"));
        start_menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.runScript();
            }
        });
        JMenuItem stop_menuitem = run_menu.add(new JMenuItem("Terminate"));
        stop_menuitem.setAccelerator(KeyStroke.getKeyStroke("ESCAPE"));
        stop_menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.stopScript();
            }
        });
        JMenu calc_menu = menubar.add(new JMenu("View"));
        GroupMenus groupmenu = new GroupMenus(new Interpreter(), this.groupmenulistener);
        menubar.add(groupmenu);
        calc_menu.add(new JMenuItem("Intensity graph...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.processIntensityImage();
            }
        });
        calc_menu.add(new JMenuItem("Stereo image...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.processStereoImage(false);
            }
        });
        calc_menu.add(new JMenuItem("Stereo + phase image...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.processStereoImage(true);
            }
        });
        calc_menu.add(new JMenuItem("Stereo image with phase color...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.processStereoPhaseImage();
            }
        });
        calc_menu.add(new JMenuItem("Stereo phase image...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.processPhaseImage();
            }
        });
        calc_menu.add(new JMenuItem("Spectrum graph...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.processSpectrumGraph();
            }
        });
        calc_menu.add(new JMenuItem("Spectrum graph (Constant Q, res = 24/oct )...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.q_hires = false;
                FFT_Testing.this.processConstantQSpectrumGraph();
            }
        });
        calc_menu.add(new JMenuItem("Spectrum graph (Constant Q, res = 48/oct )...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.q_hires = true;
                FFT_Testing.this.processConstantQSpectrumGraph();
            }
        });
        calc_menu.add(new JMenuItem("Spectrum graph (Constant Q, HPS)...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.processConstantQSpectrumGraphHPS();
            }
        });
        calc_menu.add(new JMenuItem("Spectrum graph (Constant Q, Harmonics in color)...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.processConstantQSpectrumHarmonicGraph();
            }
        });
        calc_menu.add(new JMenuItem("Spectrum graph (DFT)...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.processSpectrumGraphDFT();
            }
        });
        calc_menu.add(new JMenuItem("Spectrum graph (log)...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.processSpectrumGraphLog();
            }
        });
        calc_menu.add(new JMenuItem("Harmonic product spectrum graph ...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.processHarmonicProductSpectrumGraph();
            }
        });
        calc_menu.add(new JMenuItem("Cepstrum graph ...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.processCepstrumGraph();
            }
        });
        calc_menu.add(new JMenuItem("Frequency response...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.processFrequencyResponse();
            }
        });
        calc_menu.add(new JMenuItem("Frequency response (Constant Q, res = 24/oct )...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.q_hires = false;
                FFT_Testing.this.processLogFrequencyResponse();
            }
        });
        calc_menu.add(new JMenuItem("Frequency response (Constant Q, res = 48/oct )...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.q_hires = true;
                FFT_Testing.this.processLogFrequencyResponse();
            }
        });
        calc_menu.add(new JMenuItem("Note matrix...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FFT_Testing.this.processOctaveNoteMatrix();
            }
        });
        JMenu tools_menu = menubar.add(new JMenu("Tools"));
        tools_menu.add(new JMenuItem("SoundFont Tester...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SoundFontTester sft = new SoundFontTester();
                sft.setExitOnClose(false);
                sft.setVisible(true);
            }
        });
        JMenu help_menu = menubar.add(new JMenu("Help"));
        help_menu.add(new JMenuItem("About RasmusDSP...")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                new AboutDialog(FFT_Testing.this).setVisible(true);
            }
        });
        this.setSize(1280, 800);
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(3);
        this.setTitle("RasmusDSP - Script Tester");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/rasmus/rasmusdsp.PNG")).getImage());
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        this.offImg = graphicsConfiguration.createCompatibleImage(1280, 800, 2);
        Graphics2D g2 = this.offImg.createGraphics();
        g2.setBackground(this.getBackground());
        this.panel = new JPanel(){
            private static final long serialVersionUID = 1L;

            public void paint(Graphics graphics) {
                super.paint(graphics);
                graphics.drawImage(FFT_Testing.this.offImg, 0, 0, this);
            }
        };
        this.panel.setBackground(Color.BLACK);
        this.panel.setMinimumSize(new Dimension(10, 1000));
        this.panel.setPreferredSize(new Dimension(10, 1000));
        JPanel textpanel = new JPanel();
        textpanel.setLayout(new BorderLayout());
        textpanel.add(this.textarea);
        JScrollPane scrollpane = new JScrollPane(textpanel);
        this.cpanel = new JPanel();
        this.uipanel = new JPanel();
        this.uipanel.setLayout(new BorderLayout());
        this.cardlayout = new CardLayout();
        this.cpanel.setLayout(this.cardlayout);
        this.cpanel.add((Component)scrollpane, "text");
        this.cpanel.add((Component)this.panel, "fft");
        this.cpanel.add((Component)this.uipanel, "uipanel");
        this.setContentPane(this.cpanel);
        this.setVisible(true);
    }

    public void showFFTPanel() {
        this.cardlayout.show(this.cpanel, "fft");
    }

    public void hideFFTPanel() {
    }

    public void runScript() {
        if (this.process_running) {
            return;
        }
        this.process_running = true;
        this.cardlayout.show(this.cpanel, "uipanel");
        this.ui_interpreter = new Interpreter();
        String script = this.textarea.getText();
        try {
            this.ui_interpreter.eval(script);
        }
        catch (ScriptParserException e) {
            e.printStackTrace();
        }
        this.panelviewer = new ControlViewer(this.ui_interpreter, this.ui_interpreter.get("output"));
        this.uipanel.add(this.panelviewer);
        this.uipanel.invalidate();
        this.uipanel.validate();
        this.ui_interpreter.commit();
    }

    public void stopScript() {
        if (this.panelviewer != null) {
            this.uipanel.remove(this.panelviewer);
            this.panelviewer.close();
            this.panelviewer = null;
            this.uipanel.invalidate();
            this.uipanel.validate();
            this.cardlayout.show(this.cpanel, "text");
        }
        if (this.ui_interpreter != null) {
            this.ui_interpreter.close();
            this.ui_interpreter.commit();
            this.ui_interpreter = null;
        }
        if (!this.process_running) {
            this.cardlayout.show(this.cpanel, "text");
        }
        this.process_running = false;
    }

    public static void main(String[] args) {
        new FFT_Testing();
    }
}

