/* *******************************************************
 * 
 * name:          JWEvent.java
 * 
 * description:   Object which is sent as event for the
 *                eventmodel of JaWavedit
 *
 * Author:        Florian Bomers
 *
 * (c) 1997       JaWavedit-Team
 *                JaWavedit@bome.com
 *
 ********************************************************* */

/** 
* classes pour implementer notre propre modele
* d'une gestion des evenements. <br>
* chaque evenement peut etre reconu par 
* <UL>
* <LI> la source
* <LI> son ID
* les ID 1-999 sont disponibles par le programme
* a definition libre.<BR>
* les ID 1000+ sont des ID fixes. Au moment, seules 1000 et 1001
* sont defini pour Undo et Edit.
* </UL> <br>
* chaque evenement transmettre des informations par
* <UL>
* <LI> un parametre de type int
* <LI> un parametre de type String
* <LI> un parametre de type boolean
* </UL>
* @see JWMulticaster
* @see JWListener
*/

public class JWEvent {
  /** Source de la classe qui a emet l'evenement*/
  private Object source;
  /** ID de la classe qui a emis l'evenement*/
  private int ID=0;
  /** Parametre de type int */
  private int iParam=0;
  /** Parametre de type String */
  private String sParam="";
  /** Parametre de type boolean */
  private boolean bParam=false;
  
  public JWEvent(Object source) {
    this.source=source;
  }
  
  public JWEvent(Object source,int ID) {
    this.source=source;
    this.ID=ID;
  }
  
  public JWEvent(Object source,int ID,String s) {
    this.source=source;
    this.ID=ID;
    sParam=s;
  }
  
  public JWEvent(Object source,int ID,int i) {
    this.source=source;
    this.ID=ID;
    iParam=i;
  }
  
  public JWEvent(Object source,int ID,int i,String s) {
    this.source=source;
    this.ID=ID;
    iParam=i;
    sParam=s;
  }
  
  public JWEvent(Object source,int ID, boolean b) {
    this.source=source;
    this.ID=ID;
    bParam=b;
  }
  
  public JWEvent(Object source,int ID,String s, boolean b) {
    this.source=source;
    this.ID=ID;
    sParam=s;
    bParam=b;
  }
  
  public JWEvent(Object source,int ID,int i, boolean b) {
    this.source=source;
    this.ID=ID;
    iParam=i;
    bParam=b;
  }
  
  public JWEvent(Object source,int ID,int i, String s,boolean b) {
    this.source=source;
    this.ID=ID;
    iParam=i;
    sParam=s;
    bParam=b;
  }
  
  /** @return Object that invoked event 
  */
  public Object getSource() {
    return source;
  }
  
  /** @return ID parameter of the event 
  */
   public int getID() {
    return ID;
  }
  
  /** @return Optional integer parameter 
  */
  public int getIParam() {
    return iParam;
  }
  
  /** @return Optional string parameter 
  */
  public String getSParam() {
    return sParam;
  }
  
  /** @return Optional boolean parameter 
  */
  public boolean getBParam() {
    return bParam;
  }
}
