/* *******************************************************
 * 
 * name:          LangBase.java
 * 
 * description:   Array of basic Strings for multi-language
 *                Applications
 *
 * Author:        Florian Bomers
 *
 * (c) 1997       JaWavedit-Team
 *                JaWavedit@bome.com
 *
 ********************************************************* */

import java.util.Locale;

/**
 * Base class for language support. <BR>
 * You should use the class <A href=Lang.html>Lang</A> to
 * access language-dependent strings.<BR>
 * However, you might want to use the defined constants in this
 * class. <BR><BR>
 * Note that at the time being, the language cannot be changed
 * while running the program.
 */

public class LangBase {
  
  protected static int lang=findLang();
  
  private static final Locale[] AvailLang={Locale.ENGLISH,Locale.GERMAN, Locale.FRENCH};
  private static final String[] AvailLangNames={"English","Deutsch","Franais"};
  
  public static final int OK=0;
  public static final int CANCEL=1;
  public static final int APPLY=2;
  public static final int RETRY=3;
  public static final int YES=4;
  public static final int NO=5;

  public static final int FILE=6;
  public static final int NEW=7;
  public static final int OPEN=8;
  public static final int SAVE=9;
  public static final int SAVE_AS=10;
  public static final int SAVE_ALL=11;
  public static final int SAVE_SEL_AS=12;
  public static final int REOPEN=13;
  public static final int NEW_WINDOW=14;
  public static final int CLOSE=15;

  public static final int EDIT=16;
  public static final int UNDO=17;
  public static final int CUT=18;
  public static final int COPY=19;
  public static final int PASTE=20;
  public static final int FIND=21;

  public static final int SELECTION=22;
  public static final int DESELECT=23;
  public static final int SELECT_ALL=24;
  public static final int WINDOW=25;

  public static final int HELP=26;
  public static final int CONTENTS=27;
  public static final int ABOUT=28;
  public static final int DOYOUWANTTOSAVE_S=29;
  public static final int LOADING_WAIT=30;
  public static final int SAVING_WAIT=31;
  public static final int OPERATION_ABORTED=32;
  public static final int LOADED_S=33;
  public static final int SAVED_S=34;
  public static final int EXECUTED_S=35;
  public static final int APPLIED_S=36;
  public static final int SUCCESFUL=37;
  public static final int NO2=38; //SUCCESFULLY=38;
  public static final int PREPARE_UNDO=39;
  public static final int STORING_UNDO=40;
  public static final int ERROR_STORING_UNDO=41;
  public static final int PROB_MEM_ERR=42;
  public static final int STILL_CONTINUE=43;
  public static final int NO_UNDO_AVAIL=44;
  public static final int OPTIONS=45;
  public static final int RESET=46;
  public static final int LANGUAGE=47;

  private static int findLang() {
    try {
      String l=System.getProperty("user.language","").substring(0,2);
      if (l.equalsIgnoreCase("fr")) return 2;
      if (l.equalsIgnoreCase("de")) return 1;
    } catch (Throwable t) {}
    return 0;
  }
  
  // first index: language, 2nd index: which String (see constants above)
  protected static final String std[][]={
    // english
    {
    "OK","Cancel","Apply","Retry","Yes","No",
    "File","New","Open","Save","Save As","Save All",
      "Save Selection As","Re-Open","New Window","Close",
    "Edit","Undo","Cut","Copy","Paste","Find",
    "Selection","Deselect","Select All",
    "Window",
    "Help","Contents","About",
    "Do you want to save your recent changes of %s ?",
    "loading... please wait","saving... please wait",
    "operation aborted",
    "loaded %s succesfully","saved %s succesfully","executed %s succesfully","applied %s succesfully",
    "succesful","",
    "preparing Undo...","storing undo-informations","Error during storing undo",
      "That is probably a memory error.",
      "Do you still want to continue ?",
      "No Undo available",
    "Options","Reset","Language"
    },
   // deutsch
    {
    "OK","Abbrechen","bertragen","Wiederholen","Ja","Nein",
    "Datei","Neu","ffnen","Speichern","Speichern unter","Alles Speichern",
      "Markierung speichern unter","Wiederffnen","Neues Fenster","Schlieen",
    "Bearbeiten","Rckgngig","Ausschneiden","Kopieren","Einfgen","Suchen",
    "Markierung","Nichts markieren","Alles markieren",
    "Fenster",
    "Hilfe","Inhalt","ber",
    "Wollen Sie die letzten nderungen in %s speichern ?",
    "ldt... bitte warten","speichert... bitte warten",
    "Vorgang abgebrochen",
    "%s erfolgreich geladen","%s erfolgreich gespeichert","%s erfolgreich ausgefhrt","%s erfolgreich angewendet",
    "erfolgreich","",
    "Undo wird vorbereitet...","Rckgngig-Informationen werden gesichert...","Fehler whrend des sicherns des Undo.",
      "Dies ist wahrscheinlich ein Speicherfehler.",
      "Wollen Sie trotzdem fortfahren ?",
      "Undo ist nicht verfgbar",
    "Optionen","Reset","Sprache"
    },
    // franais
    {
    "OK","Annuler","Appliquer","Refaire","Oui","Non",
    "Fichier","Nouveau","Ouvrir","Enregistrer","Enregistrer sous","Sauver tout",
      "Enregistrer slection sous","Re-ouvrier","Nouvelle fentre","Fermer",
    "Editeur","Annuler","Couper","Copier","Coller","Rechercher",
    "Slection","Slectionner rien","Slectionner tout",
    "Fentre",
    "Aide","Sommaire","A propos",
    "Voulez vous enregistrer les changements dans %s ?",
    "charger... attendez s'il vous plat","sauver... attendez s'il vous plat",
    "Opration annull",
    "Charg %s avec succs","Sauv %s avec succs","Excut %s avec succs","Appliqu %s avec succs",
    "avec succs","",
    "Prparation de l'undo...","Sauve les informations pour l'undo...","Erreur pendant sauver l'undo.",
      "C'est probablement un erreur de mmoire.",
      "Voulez vous continuer quand mme ?",
      "Undo n'est pas disponible",
    "Options","Reset","Langue"
    }
  };
  
  public static int getLangCount() {
    return AvailLangNames.length;
  }
  
  protected static void setLangName(String l) {
    for (int i=0; i<AvailLangNames.length; i++) {
      if (AvailLangNames[i].equals(l)) {
        lang=i;
        return;
      }
    }
  }

  protected static void setLangIndex(int l) {
    if (AvailLangNames.length>l)
      lang=l;
  }
  
  public static int getLangIndex(String l) {
    for (int i=0; i<AvailLangNames.length; i++)
      if (AvailLangNames[i].equals(l))
        return i;
    return 0;
  }
  
  public static String getLangName() {
    return AvailLangNames[lang];
  }

  public static String getLangName(int l) {
    if (AvailLangNames.length>l)
      return AvailLangNames[l];
    else
      return AvailLangNames[0];
  }
  
  public static int getLangIndex() {
    return lang;
  }
  
  public static Locale getLangLocale(String l) {
    for (int i=0; i<AvailLangNames.length; i++)
      if (AvailLangNames[i].equals(l))
        return AvailLang[i];
    return AvailLang[0];
  }
  
  public static String getStr(int constant) {
    return std[lang][constant];
  }
}
