/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.console;

import ch.oli4.console.CCommand;
import ch.oli4.console.CCommandImpl;
import ch.oli4.console.CConsole;
import java.util.Iterator;
import java.util.TreeSet;

public class CCommandAutoComplete
extends CCommandImpl {
    public CCommandAutoComplete(String name) {
        super(name, "", "autocompleter");
    }

    public CCommandAutoComplete() {
        this(">");
    }

    private int getMatchLength(String a, String b) {
        int l = Math.min(a.length(), b.length());
        int i = 0;
        while (i < l) {
            if (a.charAt(i) != b.charAt(i)) {
                return i;
            }
            ++i;
        }
        return l;
    }

    private String autoComplete(CConsole console, String line) {
        TreeSet<String> candidate = new TreeSet<String>();
        for (String c : console.getCommandMap().keySet()) {
            if (!c.startsWith(line)) continue;
            candidate.add(c);
        }
        Iterator cbit = candidate.iterator();
        int matchIndex = Integer.MAX_VALUE;
        String last = null;
        while (cbit.hasNext()) {
            String c = (String)cbit.next();
            if (last != null) {
                matchIndex = Math.min(matchIndex, this.getMatchLength(last, c));
            }
            last = c;
        }
        if (candidate.size() <= 0) {
            return line;
        }
        Iterator cit = candidate.iterator();
        while (cit.hasNext()) {
            CCommand n = (CCommand)console.getCommandMap().get(cit.next());
            console.println(n.toString());
        }
        if (candidate.size() == 1) {
            String s = (String)candidate.toArray()[0];
            return s;
        }
        return ((String)candidate.toArray()[0]).substring(0, matchIndex);
    }

    public boolean onConsoleCommand(CConsole console, String commandLine) {
        if (commandLine.trim().endsWith(this.name)) {
            StringBuffer sb = new StringBuffer();
            sb = new StringBuffer(this.autoComplete(console, commandLine.substring(0, commandLine.lastIndexOf(this.name))));
            while (true) {
                console.printPrompt();
                console.print(sb.toString());
                String i = console.readInputCommand();
                if (i == null) {
                    return true;
                }
                i = i.trim();
                sb.append(i);
                if (i.length() <= 0) break;
                sb = new StringBuffer(this.autoComplete(console, sb.toString()));
            }
            console.fireOnConsoleCommand(sb.toString());
            return true;
        }
        return false;
    }

    public void onConsoleStart() {
    }

    public void onConsoleStop() {
    }
}

