/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.io;

public class IntFifo {
    private int[] body;
    private int head;
    private int tail;
    private int maxSize;

    public IntFifo() {
        this(1024);
    }

    public IntFifo(int maxSize) {
        this.maxSize = maxSize + 1;
        this.body = new int[this.maxSize];
        this.head = 0;
        this.tail = 0;
    }

    public void clear() {
        this.head = 0;
        this.tail = 0;
    }

    public synchronized void put(int o) {
        if (!this.isNotFull()) {
            this.tail = (this.tail + 1) % this.maxSize;
        }
        this.body[this.head] = o;
        this.head = (this.head + 1) % this.maxSize;
    }

    public synchronized int get() {
        int o = this.body[this.tail];
        this.tail = (this.tail + 1) % this.maxSize;
        return o;
    }

    public synchronized void replace(int o, int index) {
        this.body[(this.tail + index) % this.maxSize] = o;
    }

    public float pick(int index) {
        int i = this.tail + index;
        if (i < this.getActualSize()) {
            return this.body[i];
        }
        return this.body[i - this.maxSize];
    }

    public float pickFromHead(int index) {
        int i = this.head - index;
        if (i < 0) {
            return this.body[i + this.maxSize];
        }
        return this.body[i];
    }

    public boolean isNotEmpty() {
        return this.head != this.tail;
    }

    public boolean isNotFull() {
        return (this.head + 1) % this.maxSize != this.tail;
    }

    public int getActualSize() {
        return (this.head + this.maxSize - this.tail) % this.maxSize;
    }

    public int getFreeSize() {
        return this.maxSize - 1 - this.getActualSize();
    }
}

