/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IoToolkit {
    public static final int BIT0 = 1;
    public static final int BIT1 = 2;
    public static final int BIT2 = 4;
    public static final int BIT3 = 8;
    public static final int BIT4 = 16;
    public static final int BIT5 = 32;
    public static final int BIT6 = 64;
    public static final int BIT7 = 128;
    public static final int BIT8 = 256;
    public static final int BIT9 = 512;
    public static final int BIT10 = 1024;
    public static final int BIT11 = 2048;
    public static final int BIT12 = 4096;
    public static final int BIT13 = 8192;
    public static final int BIT14 = 16384;
    public static final int BIT15 = 32768;

    public static String readln(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (is.available() > 0) {
            is.read();
        }
        while (true) {
            char c = (char)is.read();
            System.out.println(String.valueOf((int)c) + " " + c);
            if (c == '\n' || c == '\r' || c <= '\u0000') {
                return new String(sb);
            }
            sb.append(c);
        }
    }

    public static String getFileExtension(File f) {
        String fileName = f.getName();
        int pointIndex = fileName.lastIndexOf(46);
        if (pointIndex < 0) {
            return null;
        }
        String extension = fileName.substring(pointIndex + 1);
        return extension;
    }

    public static boolean isAlphaNumeric(byte d) {
        if (d >= 48 && d <= 57) {
            return true;
        }
        return d >= 65 && d <= 70;
    }

    public static int fromHexDigit(byte d) {
        if (IoToolkit.isAlphaNumeric(d)) {
            if (d <= 57) {
                return d - 48;
            }
            return d - 65 + 10;
        }
        return 0;
    }

    public static int fromHexNumber(byte[] d, int offset, int nibbleLength) {
        int v = 0;
        int i = 0;
        while (i < nibbleLength) {
            v = v * 16 + IoToolkit.fromHexDigit(d[offset + i]);
            ++i;
        }
        return v;
    }

    public static int fromHexString(String s) {
        byte[] h = s.replace('h', ' ').replace('x', '0').trim().toUpperCase().getBytes();
        return IoToolkit.fromHexNumber(h, 0, h.length);
    }

    public static byte toHexDigit(int n) {
        if (n <= 9) {
            return (byte)(48 + n);
        }
        if (n <= 15) {
            return (byte)(65 + n - 10);
        }
        return 32;
    }

    public static void toHexNumber(int numericValue, byte[] d, int offset, int nibbleLength) {
        int i = 0;
        while (i < nibbleLength) {
            d[offset + i] = IoToolkit.toHexDigit(numericValue >> 4 * (nibbleLength - i - 1) & 0xF);
            ++i;
        }
    }

    public static String toHexString(int value, int nibbleLength) {
        byte[] d = new byte[nibbleLength];
        IoToolkit.toHexNumber(value, d, 0, nibbleLength);
        return new String(d);
    }

    public static int fromNBaseString(String s) {
        if ((s = s.trim()).startsWith("0x")) {
            return Integer.parseInt(s.substring(2), 16);
        }
        if (s.startsWith("0o")) {
            return Integer.parseInt(s.substring(2), 8);
        }
        if (s.startsWith("0b")) {
            return Integer.parseInt(s.substring(2), 2);
        }
        return Integer.parseInt(s);
    }

    public static int performCrc16(byte[] data, int offset, int length, int startValue) {
        int crc = startValue;
        int i = 0;
        while (i < length) {
            int d = data[offset + i] & 0xFF;
            int nextCrc = crc ^ d;
            int j = 0;
            while (j < 16) {
                if ((nextCrc & 0x8000) != 0) {
                    nextCrc <<= 1;
                    nextCrc ^= 0x1021;
                } else {
                    nextCrc <<= 1;
                }
                ++j;
            }
            crc = nextCrc & 0xFFFF;
            ++i;
        }
        return crc;
    }

    public static int performCrc16(byte[] data, int offset, int length) {
        return IoToolkit.performCrc16(data, offset, length, 0);
    }

    public static int bit(int bitNumber) {
        return 1 << bitNumber;
    }

    public static boolean isBitSet(int value, int bitNumber) {
        return (value & IoToolkit.bit(bitNumber)) != 0;
    }

    public static int setBit(int value, int bitNumber) {
        return value | IoToolkit.bit(bitNumber);
    }

    public static int clearBit(int value, int bitNumber) {
        return value & ~IoToolkit.bit(bitNumber);
    }

    public static int changeBit(int value, int bitNumber, boolean set) {
        if (set) {
            return IoToolkit.setBit(value, bitNumber);
        }
        return IoToolkit.clearBit(value, bitNumber);
    }

    public static byte getByte(int value, int byteNumber) {
        return (byte)(value >> byteNumber * 8);
    }

    public static int buildInt(int byte3, int byte2, int byte1, int byte0) {
        return (byte3 << 24) + (byte2 << 16) + (byte1 << 8) + (byte0 << 0);
    }

    public static int fromUnsignedByte(byte d) {
        return d & 0xFF;
    }

    public static byte toUnsignedByte(int d) {
        return (byte)d;
    }

    public static void printXmlTree(Node n) {
        IoToolkit.printXmlTree(n, 0);
    }

    private static void printXmlTree(Node n, int hierarchyLevel) {
        NodeList nl = n.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeType() != 3) {
                int j = 0;
                while (j < hierarchyLevel) {
                    System.out.print("   ");
                    ++j;
                }
                System.out.println(nl.item(i).getNodeName());
                IoToolkit.printXmlTree(nl.item(i), hierarchyLevel + 1);
            }
            ++i;
        }
    }
}

