/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia;

import ch.oli4.mmedia.MTimer;
import ch.oli4.trace.Trace;

public class MCounter
implements Runnable {
    private int totalCounter;
    private int perSecondCounter;
    private int countsPerSecond;
    private int perMinuteCounter;
    private int countsPerMinute;
    private boolean running = true;

    public MCounter() {
        Thread t = new Thread(this);
        t.start();
    }

    public synchronized int getTotalCounts() {
        return this.totalCounter;
    }

    public synchronized int getCountsPerMinute() {
        return this.countsPerMinute;
    }

    public synchronized int getCountsPerSecond() {
        return this.countsPerSecond;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() {
        MCounter mCounter = this;
        synchronized (mCounter) {
            ++this.totalCounter;
            ++this.perSecondCounter;
            ++this.perMinuteCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        MCounter mCounter = this;
        synchronized (mCounter) {
            this.totalCounter = 0;
        }
    }

    public void dispose() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int seconds = 0;
        while (this.running) {
            MTimer.sleep(1000);
            MCounter mCounter = this;
            synchronized (mCounter) {
                this.countsPerSecond = this.perSecondCounter;
                this.perSecondCounter = 0;
                if (++seconds >= 60) {
                    seconds = 0;
                    this.countsPerMinute = this.perMinuteCounter;
                    this.perMinuteCounter = 0;
                }
            }
            Trace.getInstance().addEntry(7, "MCounter c/s=" + this.countsPerSecond + " c/m=" + this.countsPerMinute + " c=" + this.totalCounter);
        }
    }
}

