/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.mmedia.game.ActiveArea;
import ch.oli4.mmedia.game.CObject;
import ch.oli4.mmedia.game.CPerspective;
import ch.oli4.mmedia.game.EventProducer;
import ch.oli4.mmedia.game.Game;
import ch.oli4.mmedia.game.Perspective;
import ch.oli4.mmedia.game.PrintedImage;
import java.util.ArrayList;
import java.util.List;

public class CObjectBook
extends CObject {
    private PrintedImage normalPageImages;
    private String imagesPrefix;
    private String imagesPostfix;
    private int totalPages;
    private int currentPage;
    private String pageNoise;
    private String coverNoise;
    private ActiveArea forward;
    private ActiveArea backward;
    private List<CPaged> allMagicObjects;
    private List<CPaged> currentMagicObjects;

    public CObjectBook(PrintedImage pageImages, int pages, String pageNoise, String coverNoise, ActiveArea forward, ActiveArea backward, CPaged[] magicObjects) {
        this.normalPageImages = pageImages;
        this.imagesPrefix = pageImages.image.substring(0, pageImages.image.indexOf(46));
        this.imagesPostfix = pageImages.image.substring(pageImages.image.indexOf(46));
        this.totalPages = pages;
        this.pageNoise = pageNoise;
        this.coverNoise = coverNoise;
        this.forward = forward;
        this.backward = backward;
        this.allMagicObjects = new ArrayList<CPaged>();
        if (magicObjects != null) {
            int i = 0;
            while (i < magicObjects.length) {
                this.allMagicObjects.add(magicObjects[i]);
                ++i;
            }
        }
        this.currentMagicObjects = new ArrayList<CPaged>();
    }

    public CObjectBook(PrintedImage normalPageImages, int totalPages, String pageNoise, String coverNoise, ActiveArea forward, ActiveArea backward) {
        this(normalPageImages, totalPages, pageNoise, coverNoise, forward, backward, null);
    }

    public void addMagicObject(int pageNumber, CPaged object) {
        this.allMagicObjects.add(object);
    }

    private void updateMagicObjects() {
        for (CPaged i : this.currentMagicObjects) {
            i.object.setEnabled(false);
        }
        this.currentMagicObjects.clear();
        for (CPaged i : this.allMagicObjects) {
            if (i.page != this.currentPage) continue;
            this.currentMagicObjects.add(i);
        }
        for (CPaged i : this.currentMagicObjects) {
            i.object.setEnabled(true);
        }
    }

    private void goForward(Perspective p) {
        if (this.currentPage < this.totalPages) {
            ++this.currentPage;
            if (this.currentPage == 2 || this.currentPage == this.totalPages) {
                if (this.coverNoise != null) {
                    Perspective.getAudio(this.coverNoise).play();
                }
            } else if (this.pageNoise != null) {
                Perspective.getAudio(this.pageNoise).play();
            }
            this.updateMagicObjects();
        }
        this.forward.setEnabled(this.currentPage < this.totalPages);
        this.backward.setEnabled(this.currentPage > 1);
    }

    private void goBackward(Perspective p) {
        if (this.currentPage > 1) {
            --this.currentPage;
            if (this.currentPage == 1 || this.currentPage == this.totalPages - 1) {
                if (this.coverNoise != null) {
                    Perspective.getAudio(this.coverNoise).play();
                }
            } else if (this.pageNoise != null) {
                Perspective.getAudio(this.pageNoise).play();
            }
            this.updateMagicObjects();
        }
        this.forward.setEnabled(this.currentPage < this.totalPages);
        this.backward.setEnabled(this.currentPage > 1);
    }

    private void closeTheBook() {
        if (this.currentPage != 1) {
            this.currentPage = 1;
            if (this.coverNoise != null) {
                Game.getInstance().getAudio(this.coverNoise).play();
            }
            this.updateMagicObjects();
        }
        this.forward.setEnabled(this.currentPage < this.totalPages);
        this.backward.setEnabled(this.currentPage > 1);
    }

    void init(Perspective p) {
        p.add(this.forward);
        p.add(this.backward);
        for (CPaged i : this.allMagicObjects) {
            i.object.init(p);
        }
    }

    void setup() {
        this.currentPage = 1;
        this.updateMagicObjects();
        this.forward.setEnabled(this.currentPage < this.totalPages);
        this.backward.setEnabled(this.currentPage > 1);
        for (CPaged i : this.allMagicObjects) {
            i.object.setup();
            i.object.setEnabled(false);
        }
    }

    void perform(CPerspective p, EventProducer a) {
        if (a == this.forward) {
            this.goForward(p);
        } else if (a == this.backward) {
            this.goBackward(p);
        }
        for (CPaged i : this.currentMagicObjects) {
            i.object.perform(p, a);
        }
    }

    void print() {
        Game.getInstance().getPanel().printImage(String.valueOf(this.imagesPrefix) + this.currentPage + this.imagesPostfix, this.normalPageImages.x, this.normalPageImages.y);
        for (CPaged i : this.currentMagicObjects) {
            i.object.print();
        }
    }

    void cleanup() {
        for (CPaged i : this.allMagicObjects) {
            i.object.cleanup();
        }
        this.closeTheBook();
    }

    public static class CPaged {
        public int page;
        public CObject object;

        public CPaged(int page, CObject object) {
            this.page = page;
            this.object = object;
        }
    }
}

