/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.mmedia.game.CObject;
import ch.oli4.mmedia.game.CPerspective;
import ch.oli4.mmedia.game.EventProducer;
import ch.oli4.mmedia.game.GameState;
import ch.oli4.mmedia.game.Perspective;

public class COnced
extends CObject {
    private CObject onceObject;
    private CObject defaultObject;
    private String stateName;

    public COnced(String stateName, CObject onceObject, CObject defaultObject, boolean persistent) {
        this.stateName = stateName;
        this.onceObject = onceObject;
        this.defaultObject = defaultObject;
        if (!persistent) {
            GameState.getInstance().setBoolean(stateName, false);
        }
    }

    public COnced(String stateName, CObject onceObject, CObject defaultObject) {
        this(stateName, onceObject, defaultObject, true);
    }

    void init(Perspective p) {
        if (this.onceObject != null) {
            this.onceObject.init(p);
        }
        if (this.defaultObject != null) {
            this.defaultObject.init(p);
        }
    }

    void setup() {
        if (!GameState.getInstance().getBoolean(this.stateName, false)) {
            if (this.onceObject != null) {
                this.onceObject.setup();
            }
        } else if (this.defaultObject != null) {
            this.defaultObject.setup();
        }
    }

    void print() {
        if (!GameState.getInstance().getBoolean(this.stateName, false)) {
            if (this.onceObject != null) {
                this.onceObject.print();
            }
        } else if (this.defaultObject != null) {
            this.defaultObject.print();
        }
    }

    void perform(CPerspective p, EventProducer a) {
        if (!GameState.getInstance().getBoolean(this.stateName, false)) {
            if (this.onceObject != null) {
                this.onceObject.perform(p, a);
            }
        } else if (this.defaultObject != null) {
            this.defaultObject.perform(p, a);
        }
    }

    void cleanup() {
        if (!GameState.getInstance().getBoolean(this.stateName, false)) {
            if (this.onceObject != null) {
                this.onceObject.cleanup();
            }
        } else if (this.defaultObject != null) {
            this.defaultObject.cleanup();
        }
        GameState.getInstance().setBoolean(this.stateName, true);
    }
}

