/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.mmedia.game.ActiveArea;
import ch.oli4.mmedia.game.CObject;
import ch.oli4.mmedia.game.CPerspective;
import ch.oli4.mmedia.game.EventProducer;
import ch.oli4.mmedia.game.Perspective;
import ch.oli4.trace.Trace;

public class CStoried
extends CObject {
    public static final int MODE_FORWARD_SINGLE = 1;
    public static final int MODE_FORWARD_LOOP = 2;
    public static final int MODE_FORWARD_SINGLE_REPEAT_LAST = 3;
    public static final int MODE_RANDOM_LOOP = 4;
    private ActiveArea area;
    private int mode;
    private CObject[] objects;
    private int index;
    private static final int OFF = -99;
    private boolean running;

    public CStoried(ActiveArea area, int mode, CObject[] o) {
        this.area = area;
        this.mode = mode;
        this.objects = o;
    }

    public CStoried(int mode, CObject[] o) {
        this(null, mode, o);
    }

    void init(Perspective p) {
        if (this.area != null) {
            p.add(this.area);
        }
        this.index = -1;
        int i = 0;
        while (i < this.objects.length) {
            this.objects[i].init(p);
            ++i;
        }
        Trace.getInstance().addEntry(6, "story index set to " + this.index);
    }

    void setup() {
        if (this.index != -99) {
            switch (this.mode) {
                case 1: {
                    if (this.index < this.objects.length - 1) {
                        ++this.index;
                        break;
                    }
                    this.index = -99;
                    break;
                }
                case 3: {
                    if (this.index < this.objects.length - 2) {
                        ++this.index;
                        break;
                    }
                    this.index = this.objects.length - 1;
                    break;
                }
                case 2: {
                    if (this.index < this.objects.length - 1) {
                        ++this.index;
                        break;
                    }
                    this.index = 0;
                    break;
                }
                case 4: {
                    this.index = Math.min((int)(Math.random() * (double)this.objects.length), this.objects.length - 1);
                }
            }
            Trace.getInstance().addEntry(6, "story index set to " + this.index);
            if (this.index >= 0) {
                this.objects[this.index].setup();
            }
        }
        this.running = this.index != -99;
    }

    void perform(CPerspective p, EventProducer a) {
        if (this.running && this.area != null && a == this.area) {
            this.cleanup();
            this.setup();
        }
    }

    void cleanup() {
        if (this.index >= 0) {
            this.objects[this.index].cleanup();
        }
        this.running = false;
    }
}

