/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.mmedia.MMouse;
import ch.oli4.mmedia.game.GameState;
import ch.oli4.trace.Trace;
import java.awt.FlowLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameCollectedObjects {
    private static GameCollectedObjects instance = null;
    private Map<String, String> objectNames = new HashMap<String, String>();
    private Map<String, Integer> objectCursors = new HashMap<String, Integer>();
    private int cursorIdBase = 2000;
    private JPanel panel = new JPanel();

    private GameCollectedObjects() {
        this.panel.setLayout(new FlowLayout());
        this.refreshPanel();
    }

    public static GameCollectedObjects getInstance() {
        if (instance == null) {
            instance = new GameCollectedObjects();
        }
        return instance;
    }

    public void register(String gameState, String icon) {
        Trace.getInstance().addEntry(4, "register collected object " + gameState + " --> " + icon);
        this.objectNames.put(gameState, icon);
        int id = this.cursorIdBase++;
        this.objectCursors.put(gameState, id);
        ImageIcon ii = new ImageIcon(icon);
        ii.setImage(ii.getImage().getScaledInstance(64, -1, 4));
        MMouse.getInstance().loadCustomCursor(id, gameState, ii, 0.5, 0.5);
        this.refreshPanel();
    }

    public Set<String> getAllObjectNames() {
        return this.objectNames.keySet();
    }

    public int getCursor(String name) {
        if (this.objectCursors.containsKey(name)) {
            return this.objectCursors.get(name);
        }
        return 1;
    }

    private void refreshPanel() {
        this.panel.removeAll();
        for (String i : this.objectNames.keySet()) {
            if (!GameState.getInstance().getBoolean(i, false)) continue;
            ImageIcon ii = new ImageIcon(this.objectNames.get(i));
            ii.setImage(ii.getImage().getScaledInstance(128, -1, 4));
            JLabel l = new JLabel(ii);
            this.panel.add(l);
        }
        this.panel.validate();
        this.panel.repaint();
    }

    public JPanel getPanel() {
        this.refreshPanel();
        return this.panel;
    }
}

