/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.mmedia.MAudio;
import ch.oli4.mmedia.MPanel;
import ch.oli4.mmedia.game.Game;
import ch.oli4.mmedia.game.Path;
import ch.oli4.trace.Trace;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class Room {
    private Room parent = null;
    private String name;
    protected List<Room> subRooms;
    private static Room lastRoom = null;

    public Room(String name) {
        this.name = name;
        this.subRooms = new ArrayList<Room>();
    }

    public void add(Room r) {
        if (r.parent != null) {
            throw new IllegalStateException("room " + r.name + " already used! it cannot be added to " + this.getPath().toString());
        }
        this.subRooms.add(r);
        Trace.getInstance().addEntry(1, "path " + r.getPath().toString() + " added to " + this.getPath().toString());
        r.parent = this;
    }

    public final Path getPath() {
        Path p = new Path("/");
        this.buildPath(p);
        return p;
    }

    private void buildPath(Path p) {
        if (this.parent != null) {
            this.parent.buildPath(p);
        }
        p.addNode(this.name);
    }

    public String toStructure() {
        return this.toStructure(0);
    }

    String toStructure(int ident) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ident) {
            if (i == 0) {
                sb.append("   ");
            } else {
                sb.append("|  ");
            }
            ++i;
        }
        sb.append("+--");
        sb.append(this.name);
        if (this.subRooms.size() > 0) {
            sb.append(" (room)");
        } else {
            sb.append(" (perspective)");
        }
        sb.append("\n");
        for (Room i2 : this.subRooms) {
            sb.append(i2.toStructure(ident + 1));
        }
        return sb.toString();
    }

    public static MAudio getAudio(String name) {
        return Game.getInstance().getAudio(name);
    }

    public static MPanel getPanel() {
        return Game.getInstance().getPanel();
    }

    public String getResource(String relativePath) {
        return Room.getResource(this, relativePath);
    }

    public static String getResource(Object o, String relativePath) {
        URL u = o.getClass().getResource(relativePath);
        if (u != null) {
            return u.getPath();
        }
        return "";
    }

    public void setNextPath(String p) {
        Game.getInstance().setNextPath(new Path(p));
    }

    protected void onEntry() {
    }

    private Room findRoom(Path p) {
        for (Room i : this.subRooms) {
            if (!p.contains(i.getPath())) continue;
            return i;
        }
        return null;
    }

    void run() {
        if (lastRoom == this) {
            Trace.getInstance().addEntry(1, "path " + Game.getInstance().getCurrentPath().toString() + " not found!");
            Game.getInstance().setNextPath(new Path("/"));
        } else {
            Room sr;
            lastRoom = this;
            Trace.getInstance().addEntry(1, "onEntry " + this.getPath().toString());
            this.onEntry();
            while ((sr = this.findRoom(Game.getInstance().getCurrentPath())) != null) {
                sr.run();
            }
            Trace.getInstance().addEntry(1, "onExit " + this.getPath().toString());
            this.onExit();
            System.gc();
        }
        if (Game.getInstance().getMainRoom() == this) {
            Trace.getInstance().addEntry(1, "end of game, path " + Game.getInstance().getCurrentPath().toString() + " not found!");
        }
    }

    protected void onExit() {
    }
}

