/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.os;

import ch.oli4.os.OSemaphore;
import ch.oli4.os.OTimerListener;
import java.util.LinkedList;
import java.util.List;

public class OTimer {
    private static OTimerManager manager = new OTimerManager();
    private long timeout;
    private OTimerListener listener;

    public OTimer(OTimerListener listener) {
        this.listener = listener;
    }

    public void start(int delay) {
        this.timeout = System.currentTimeMillis() + (long)delay;
        manager.removeTimer(this);
        manager.insertTimer(this);
    }

    public void stop() {
        manager.removeTimer(this);
    }

    public int getRemainTime() {
        return (int)(this.timeout - System.currentTimeMillis());
    }

    public boolean isRunning() {
        return manager.isRunning(this);
    }

    public static void setResolution(int res) {
        manager.setResolution(res);
    }

    private static class OTimerManager
    implements Runnable {
        private OSemaphore s;
        private List queue = new LinkedList();
        private int resolution = 1;

        public OTimerManager() {
            this.s = new OSemaphore(0);
            Thread t = new Thread(this);
            t.start();
        }

        public synchronized void insertTimer(OTimer t) {
            int i = 0;
            while (i < this.queue.size()) {
                if (t.timeout < ((OTimer)this.queue.get(i)).timeout) {
                    this.queue.add(i, t);
                    return;
                }
                ++i;
            }
            this.queue.add(t);
            if (this.queue.size() <= 1) {
                this.s.signal();
            }
        }

        public synchronized void removeTimer(OTimer t) {
            this.queue.remove(t);
        }

        public synchronized boolean isRunning(OTimer t) {
            return this.queue.contains(t);
        }

        public void setResolution(int res) {
            this.resolution = res < 1 ? 1 : res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.resolution);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.queue.size() == 0) {
                    this.s.waitSignal();
                }
                OTimerManager oTimerManager = this;
                synchronized (oTimerManager) {
                    if (this.queue.size() > 0) {
                        OTimer t = (OTimer)this.queue.get(0);
                        if (System.currentTimeMillis() >= t.timeout) {
                            this.queue.remove(0);
                            if (t.listener != null) {
                                t.listener.onTimeout(t);
                            }
                        }
                    }
                }
            }
        }
    }
}

