/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.text;

import ch.oli4.trace.Trace;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Language {
    private static Language language;
    private ResourceBundle textBundle;
    private String languageCode;
    private String countryCode;

    public static Language getInstance() {
        if (language == null) {
            language = new Language();
        }
        return language;
    }

    public void setLanguage(String languageCode, String countryCode) {
        try {
            this.languageCode = languageCode;
            this.countryCode = countryCode;
            this.textBundle = ResourceBundle.getBundle("language", new Locale(languageCode, countryCode));
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
    }

    public void setLanguage(String languageCode) {
        this.setLanguage(languageCode, "");
    }

    public String getLanguage() {
        return this.languageCode;
    }

    public String[] getAllLanguages() {
        File f = new File(System.getProperty("user.dir"));
        class LanguageFilenameFilter
        implements FilenameFilter {
            LanguageFilenameFilter() {
            }

            public boolean accept(File dir, String name) {
                return name.startsWith("language_") && name.endsWith(".properties");
            }
        }
        String[] l = f.list(new LanguageFilenameFilter());
        int i = 0;
        while (i < l.length) {
            int begin = l[i].indexOf(95) + 1;
            int end = l[i].indexOf(46, begin);
            l[i] = l[i].substring(begin, end);
            ++i;
        }
        return l;
    }

    public String translate(String logicWord) {
        try {
            return Language.language.textBundle.getString(logicWord);
        }
        catch (Exception e) {
            if (Trace.getInstance().isVerboseLevel(9)) {
                Trace.getInstance().addEntry("could not translate word: " + logicWord);
            }
            return logicWord;
        }
    }
}

