/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui;

import ch.oli4.ui.UiMouseTrackEvent;
import ch.oli4.ui.UiMouseTrackListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class UiMouseTracker
extends JPanel
implements MouseListener,
MouseMotionListener {
    private boolean moving;
    private int delayCounter;
    private static final int START_DELAY = 40;
    private float oldX;
    private float oldY;
    private float dx;
    private float dy;
    private float speed;
    private float rx;
    private float ry;
    private float r;
    private float angle;
    private float deltaAngle;
    private WeakHashMap<UiMouseTrackListener, Object> listeners = new WeakHashMap();
    private int centerX;
    private int centerY;
    private int minRadius;
    private int[] xPoly;
    private int[] yPoly;

    public UiMouseTracker() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setForeground(new Color(0x3333FF));
        this.setMinimumSize(new Dimension(3, 3));
        this.setPreferredSize(new Dimension(12, 24));
        this.xPoly = new int[3];
        this.yPoly = new int[3];
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.isEnabled()) {
            this.delayCounter = 0;
            this.moving = true;
            this.trackMouse(e.getX(), e.getY());
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.isEnabled()) {
            this.moving = false;
            this.trackMouse(e.getX(), e.getY());
            this.fireOnReleaseEvent();
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.isEnabled()) {
            this.trackMouse(e.getX(), e.getY());
            if (this.delayCounter++ > 40 && this.r > (float)this.minRadius) {
                this.fireOnMovingEvent();
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    private float mean(float mean, float value) {
        int meanWidth = 4;
        return (mean * (float)(meanWidth - 1) + value) / (float)meanWidth;
    }

    private void trackMouse(int x, int y) {
        this.dx = this.mean(this.dx, (float)x - this.oldX);
        this.dy = this.mean(this.dy, (float)y - this.oldY);
        this.speed = (float)Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        this.rx = this.mean(this.rx, x - this.centerX);
        this.ry = this.mean(this.ry, y - this.centerY);
        this.r = (float)Math.sqrt(this.rx * this.rx + this.ry * this.ry);
        double a = Math.atan2(-this.ry, this.rx);
        float da = (float)(a = (57.29577951308232 * a + 360.0) % 360.0) - this.angle;
        if (da > 180.0f) {
            da -= 360.0f;
        } else if (da < -180.0f) {
            da += 360.0f;
        }
        this.deltaAngle = this.mean(this.deltaAngle, da);
        this.angle = (float)a;
        this.oldX = x;
        this.oldY = y;
    }

    public float getRadiusX() {
        return this.rx;
    }

    public float getRadiusY() {
        return this.ry;
    }

    public float getRadius() {
        return this.r;
    }

    public float getSpeedX() {
        return this.dx;
    }

    public float getSpeedY() {
        return this.dy;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getDeltaAngle() {
        return this.deltaAngle;
    }

    public boolean isClockWise() {
        return this.deltaAngle < 0.0f && this.r > (float)this.minRadius;
    }

    public boolean isCounterClockWise() {
        return this.deltaAngle > 0.0f && this.r > (float)this.minRadius;
    }

    public void addMouseTrackListener(UiMouseTrackListener l) {
        this.listeners.put(l, null);
    }

    private void fireOnMovingEvent() {
        UiMouseTrackEvent e = new UiMouseTrackEvent(this);
        for (UiMouseTrackListener l : this.listeners.keySet()) {
            l.onMoving(e);
        }
    }

    private void fireOnReleaseEvent() {
        UiMouseTrackEvent e = new UiMouseTrackEvent(this);
        for (UiMouseTrackListener l : this.listeners.keySet()) {
            l.onRelease(e);
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        this.centerX = this.getWidth() / 2;
        this.centerY = this.getHeight() / 2;
        this.minRadius = Math.min(this.centerX, this.centerY);
        Color fillColor = this.isEnabled() ? (this.moving ? this.getForeground() : this.getForeground().darker().darker().darker()) : Color.gray;
        int ax = this.getWidth() / 4;
        int ay = this.getHeight() / 5;
        int bx = this.getWidth() / 7;
        int by = this.getHeight() / 7;
        int rx = (this.getWidth() - 2 * bx - ax) / 2;
        int ry = (this.getHeight() - 2 * by) / 2;
        this.xPoly[0] = bx + 2 * rx;
        this.xPoly[1] = bx + 2 * rx + ax;
        this.xPoly[2] = bx + 2 * rx - ax;
        this.yPoly[0] = by + ry + ay / 2;
        this.yPoly[1] = by + ry - ay / 2;
        this.yPoly[2] = by + ry - ay / 2;
        g2d.setColor(Color.white);
        g2d.drawArc(bx - 1, by - 1, 2 * rx + 2, 2 * ry + 2, 45, 180);
        g2d.drawLine(this.xPoly[1], this.yPoly[1] - 1, this.xPoly[2], this.yPoly[2] - 1);
        g2d.setColor(fillColor);
        g2d.drawArc(bx, by, 2 * rx, 2 * ry, 0, 320);
        g2d.fill(new Polygon(this.xPoly, this.yPoly, 3));
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        UiMouseTracker t1 = new UiMouseTracker();
        t1.setEnabled(true);
        p.add((Component)t1, "Center");
        UiMouseTracker t2 = new UiMouseTracker();
        t2.setEnabled(false);
        t2.setForeground(Color.green);
        p.add((Component)t2, "South");
        UiMouseTracker t3 = new UiMouseTracker();
        t3.setEnabled(true);
        p.add((Component)t3, "East");
        f.getContentPane().add(p);
        f.setSize(new Dimension(100, 100));
        f.setVisible(true);
    }
}

