/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui;

import ch.oli4.ui.signal.UiSignalLed;
import java.awt.Color;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UiStatusBar
extends JPanel
implements Runnable {
    private String[] leftText;
    private int cyclePeriod;
    private int index;
    private UiSignalLed led;
    private JLabel livingState;
    private JLabel detailState;
    public static final int OK = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    public static final int DISABLE = 4;

    public UiStatusBar() {
        this.setCyclePeriod(1500);
        this.index = 0;
        this.setLayout(new BoxLayout(this, 0));
        this.detailState = new JLabel();
        this.add(this.detailState);
        this.add(Box.createHorizontalGlue());
        this.livingState = new JLabel();
        this.add(this.livingState);
        this.led = new UiSignalLed();
        this.led.setTransitionTime(0);
        this.add(this.led);
        Thread t = new Thread(this);
        t.start();
    }

    public void setLeftText(String[] text) {
        this.leftText = text;
    }

    public void setLeftText(String text) {
        String[] t = new String[]{text};
        this.setLeftText(t);
    }

    public void setLeftTextImmediately(String text) {
        this.leftText = null;
        this.detailState.setText(text);
    }

    public void setCyclePeriod(int p) {
        this.cyclePeriod = p < 500 ? 500 : p;
    }

    public void run() {
        while (true) {
            if (this.leftText != null) {
                if (this.index >= this.leftText.length) {
                    this.index = 0;
                }
                this.detailState.setText(this.leftText[this.index]);
                ++this.index;
            } else {
                this.detailState.setText("");
            }
            try {
                Thread.sleep(this.cyclePeriod);
            }
            catch (Exception exception) {
            }
        }
    }

    public void setRightText(String text) {
        this.livingState.setText(text);
    }

    public void setLedState(int state) {
        switch (state) {
            case 3: {
                this.led.setBlinkPeriod(0);
                this.led.setOnColor(Color.RED);
                this.led.setData(true);
                break;
            }
            case 2: {
                this.led.setBlinkPeriod(0);
                this.led.setOnColor(Color.YELLOW);
                this.led.setData(true);
                break;
            }
            case 1: {
                this.led.setBlinkPeriod(0);
                this.led.setOnColor(Color.GREEN);
                this.led.setData(true);
                break;
            }
            case 4: {
                this.led.setData(false);
            }
        }
    }

    public UiSignalLed getLed() {
        return this.led;
    }
}

