/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.browser;

import ch.oli4.text.Language;
import ch.oli4.ui.UiPopupMenu;
import ch.oli4.ui.browser.UiHtmlEvent;
import ch.oli4.ui.browser.UiHtmlListener;
import ch.oli4.ui.browser.UiHtmlPanel;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

class UiHtmlPopupMenu
extends UiPopupMenu
implements UiHtmlListener {
    private UiHtmlPanel htmlPanel;
    protected JMenuItem back;
    protected JMenuItem forward;
    protected JMenuItem home;

    public UiHtmlPopupMenu(UiHtmlPanel htmlPanel) {
        this.htmlPanel = htmlPanel;
        htmlPanel.addHtmlListener(this);
        htmlPanel.addPopupMenu(this);
        this.addHtmlPopup();
    }

    protected void addHtmlPopup() {
        this.setLabel(Language.getInstance().translate("browser"));
        this.back = new JMenuItem(Language.getInstance().translate("back"));
        this.back.setEnabled(true);
        this.back.addActionListener(this);
        this.add(this.back);
        this.forward = new JMenuItem(Language.getInstance().translate("forward"));
        this.forward.setEnabled(true);
        this.forward.addActionListener(this);
        this.add(this.forward);
        this.add(new JSeparator());
        this.home = new JMenuItem(Language.getInstance().translate("home"));
        this.home.setEnabled(true);
        this.home.addActionListener(this);
        this.add(this.home);
    }

    public void historyChanged(UiHtmlEvent e) {
        this.back.setEnabled(this.htmlPanel.isBackwardAvailable());
        this.forward.setEnabled(this.htmlPanel.isForwardAvailable());
    }

    public void possibleLinkChanged(UiHtmlEvent e) {
    }

    protected void onPopup() {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.back) {
            this.htmlPanel.goBackward();
        } else if (e.getSource() == this.forward) {
            this.htmlPanel.goForward();
        } else if (e.getSource() == this.home) {
            this.htmlPanel.goHome();
        }
    }
}

