/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.clock;

import ch.oli4.ui.clock.UiClock;
import ch.oli4.ui.clock.UiClockEvent;
import java.awt.Color;

public abstract class UiClockAnalog
extends UiClock {
    protected Color gehaeuseColor = Color.lightGray;
    protected Color skalaColor = Color.black;
    protected Color secondZeigerColor = Color.black;
    protected Color minuteZeigerColor = Color.black;
    protected Color hourZeigerColor = Color.black;
    protected boolean gehaeuseVisible = true;
    protected boolean skalaVisible = true;
    protected int second;
    protected int minute;
    protected int hour;
    protected int dayOfMonth;
    protected int month;
    private static final int captureAngleMax = 40;

    public UiClockAnalog() {
        this.updateActualTime();
        this.repaint();
    }

    public void setGehaeuseColor(Color c) {
        this.gehaeuseColor = c;
        this.repaint();
    }

    public void setSkalaColor(Color c) {
        this.skalaColor = c;
        this.repaint();
    }

    public void setSecondZeigerColor(Color c) {
        this.secondZeigerColor = c;
        this.repaint();
    }

    public void setMinuteZeigerColor(Color c) {
        this.minuteZeigerColor = c;
        this.repaint();
    }

    public void setHourZeigerColor(Color c) {
        this.hourZeigerColor = c;
        this.repaint();
    }

    public void setGehaeuseVisible(boolean b) {
        this.gehaeuseVisible = b;
    }

    public void setSkalaVisible(boolean b) {
        this.skalaVisible = b;
    }

    protected void updateActualTime() {
        this.second = this.getTime().get(13);
        this.minute = this.getTime().get(12);
        this.hour = this.getTime().get(11);
        this.dayOfMonth = this.getTime().get(5);
        this.month = this.getTime().get(2) + 1;
    }

    protected int toMonthX(int radius) {
        return (int)(Math.cos(((double)(-this.month) + 3.0) / 6.0 * Math.PI) * (double)radius);
    }

    protected int toMonthY(int radius) {
        return (int)(-Math.sin(((double)(-this.month) + 3.0) / 6.0 * Math.PI) * (double)radius);
    }

    protected int toDayX(int radius) {
        return (int)(Math.cos(((double)(-this.dayOfMonth) + 15.0) / 30.0 * Math.PI) * (double)radius);
    }

    protected int toDayY(int radius) {
        return (int)(-Math.sin(((double)(-this.dayOfMonth) + 15.0) / 30.0 * Math.PI) * (double)radius);
    }

    protected int toHourX(int radius) {
        return (int)(Math.cos((-((double)this.hour * 60.0 + (double)this.minute) / 60.0 + 3.0) / 6.0 * Math.PI) * (double)radius);
    }

    protected int toHourY(int radius) {
        return (int)(-Math.sin((-((double)this.hour * 60.0 + (double)this.minute) / 60.0 + 3.0) / 6.0 * Math.PI) * (double)radius);
    }

    protected int toMinuteX(int radius) {
        return (int)(Math.cos(((double)(-this.minute) + 15.0) / 30.0 * Math.PI) * (double)radius);
    }

    protected int toMinuteY(int radius) {
        return (int)(-Math.sin(((double)(-this.minute) + 15.0) / 30.0 * Math.PI) * (double)radius);
    }

    protected int toSecondX(int radius) {
        return (int)(Math.cos(((double)(-this.second) + 15.0) / 30.0 * Math.PI) * (double)radius);
    }

    protected int toSecondY(int radius) {
        return (int)(-Math.sin(((double)(-this.second) + 15.0) / 30.0 * Math.PI) * (double)radius);
    }

    protected int toMonthAngle(int month) {
        return month * 30 % 360;
    }

    protected int toDayOfMonthAngle(int dayOfMonth) {
        return dayOfMonth * 6 % 360;
    }

    protected int toHourAngle(int hour) {
        return (hour % 12 * 30 + this.minute / 2) % 360;
    }

    protected int toMinuteAngle(int minute) {
        return minute * 6 % 360;
    }

    protected int toSecondAngle(int second) {
        return second * 6 % 360;
    }

    protected double XYtoRadius(int x, int y) {
        return Math.sqrt((double)x * (double)x + (double)y * (double)y);
    }

    protected int XYtoAngle(int x, int y) {
        double r = this.XYtoRadius(x, y);
        if (x > 0) {
            return ((int)(Math.asin((double)y / r) * 180.0 / Math.PI) + 450) % 360;
        }
        return ((int)(-Math.asin((double)y / r) * 180.0 / Math.PI) + 630) % 360;
    }

    protected int deltaAngle(int a1, int a2) {
        int delta = (a1 - a2) % 360;
        if (delta > 180) {
            return -360 + delta;
        }
        if (delta < -180) {
            return 360 + delta;
        }
        return delta;
    }

    protected void adjustSecondZeiger(int x, int y) {
        int delta = this.deltaAngle(this.XYtoAngle(x, y), this.toSecondAngle(this.second));
        if (delta > 5 && delta < 40) {
            this.model.addSecond(1);
        } else if (delta < -5 && delta > -40) {
            this.model.addSecond(-1);
        }
    }

    protected void adjustMinuteZeiger(int x, int y) {
        int delta = this.deltaAngle(this.XYtoAngle(x, y), this.toMinuteAngle(this.minute));
        if (delta > 5 && delta < 40) {
            this.model.addMinute(1);
        } else if (delta < -5 && delta > -40) {
            this.model.addMinute(-1);
        }
    }

    protected void adjustHourZeiger(int x, int y) {
        int delta = this.deltaAngle(this.XYtoAngle(x, y), this.toHourAngle(this.hour));
        if (delta > 20 && delta < 40) {
            this.model.addHour(1);
        } else if (delta < -20 && delta > -40) {
            this.model.addHour(-1);
        }
    }

    public void onSecond(UiClockEvent e) {
        this.updateActualTime();
        this.repaint();
    }

    public void onMinute(UiClockEvent e) {
        this.updateActualTime();
        this.repaint();
    }

    public void onHour(UiClockEvent e) {
        this.updateActualTime();
        this.repaint();
    }

    public void onTrigger(UiClockEvent e) {
        this.updateActualTime();
        this.repaint();
    }
}

