/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.clock;

import ch.oli4.ui.UiPoint;
import ch.oli4.ui.clock.UiClockAnalog;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class UiClockAnalogRect
extends UiClockAnalog
implements MouseListener,
MouseMotionListener {
    protected static final int NO_ZEIGER = 0;
    protected static final int SECOND_ZEIGER = 1;
    protected static final int MINUTE_ZEIGER = 2;
    protected static final int HOUR_ZEIGER = 3;
    protected int selectedZeiger;
    protected static final int selectedAngleMax = 10;
    private UiPoint clockCenter = new UiPoint();
    private int stundenZeigerRadius;
    private int minutenZeigerRadius;
    private int sekundenZeigerRadius;
    private int skalaMaxRadius;
    private int skalaRandAbstand;
    private int gehaeuseRadius;

    public UiClockAnalogRect() {
        this.setPreferredSize(new Dimension(33, 30));
        this.setSecondVisible(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.enabled) {
            int mouseAngle = this.XYtoAngle(e.getX() - this.clockCenter.x, e.getY() - this.clockCenter.y);
            this.selectedZeiger = this.minuteVisible && Math.abs(this.deltaAngle(this.toMinuteAngle(this.minute), mouseAngle)) < 10 ? 2 : (this.hourVisible && Math.abs(this.deltaAngle(this.toHourAngle(this.hour), mouseAngle)) < 10 ? 3 : (this.secondVisible && Math.abs(this.deltaAngle(this.toSecondAngle(this.second), mouseAngle)) < 10 ? 1 : 0));
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.selectedZeiger = 0;
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.selectedZeiger = 0;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.enabled) {
            if (this.selectedZeiger == 1) {
                this.adjustSecondZeiger(e.getX() - this.clockCenter.x, e.getY() - this.clockCenter.y);
            } else if (this.selectedZeiger == 2) {
                this.adjustMinuteZeiger(e.getX() - this.clockCenter.x, e.getY() - this.clockCenter.y);
            } else if (this.selectedZeiger == 3) {
                this.adjustHourZeiger(e.getX() - this.clockCenter.x, e.getY() - this.clockCenter.y);
            }
        }
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        super.paintComponent(g);
        this.clockCenter.x = this.getWidth() / 2;
        this.clockCenter.y = this.getHeight() / 2;
        this.gehaeuseRadius = this.getWidth() < this.getHeight() ? this.getWidth() * 5 / 11 : this.getHeight() * 5 / 11;
        if (this.skalaVisible) {
            this.skalaMaxRadius = this.getHeight() + this.getWidth();
            this.skalaRandAbstand = this.gehaeuseRadius / 6;
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 50.0f));
            int i = 0;
            while (i < 12) {
                g2d.setColor(this.skalaColor);
                g2d.drawLine(this.clockCenter.x - (int)(Math.sin((double)i / 6.0 * Math.PI) * (double)this.skalaMaxRadius), this.clockCenter.y - (int)(Math.cos((double)i / 6.0 * Math.PI) * (double)this.skalaMaxRadius), this.clockCenter.x, this.clockCenter.y);
                ++i;
            }
            g2d.setColor(this.getBackground());
            g2d.fillRect(this.skalaRandAbstand, this.skalaRandAbstand, this.getWidth() - 2 * this.skalaRandAbstand, this.getHeight() - 2 * this.skalaRandAbstand);
        }
        if (this.hourVisible) {
            this.stundenZeigerRadius = this.gehaeuseRadius * 13 / 20;
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 30.0f));
            g2d.setColor(this.hourZeigerColor);
            g2d.draw(new Line2D.Double(this.clockCenter.x, this.clockCenter.y, this.clockCenter.x + this.toHourX(this.stundenZeigerRadius), this.clockCenter.y + this.toHourY(this.stundenZeigerRadius)));
        }
        if (this.minuteVisible) {
            this.minutenZeigerRadius = this.gehaeuseRadius * 20 / 20;
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 30.0f));
            g2d.setColor(this.minuteZeigerColor);
            g2d.draw(new Line2D.Double(this.clockCenter.x, this.clockCenter.y, this.clockCenter.x + this.toMinuteX(this.minutenZeigerRadius), this.clockCenter.y + this.toMinuteY(this.minutenZeigerRadius)));
        }
        if (this.secondVisible) {
            this.sekundenZeigerRadius = this.gehaeuseRadius * 21 / 20;
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 50.0f));
            g2d.setColor(this.secondZeigerColor);
            g2d.draw(new Line2D.Double(this.clockCenter.x, this.clockCenter.y, this.clockCenter.x + this.toSecondX(this.sekundenZeigerRadius), this.clockCenter.y + this.toSecondY(this.sekundenZeigerRadius)));
        }
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        UiClockAnalogRect c = new UiClockAnalogRect();
        c.setEnabled(true);
        c.start();
        p.add((Component)c, "Center");
        f.getContentPane().add(p);
        f.setSize(new Dimension(200, 200));
        f.setVisible(true);
    }
}

