/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.clock;

import ch.oli4.ui.UiPoint;
import ch.oli4.ui.clock.UiClockAnalog;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class UiClockUniverso
extends UiClockAnalog {
    protected Color blattColor;
    protected Color dayOfMonthZeigerColor;
    protected Color monthZeigerColor;
    protected boolean dayOfMonthVisible;
    protected boolean monthVisible;
    private UiPoint clockCenter = new UiPoint();
    private int stundenZeigerRadius;
    private int minutenZeigerRadius;
    private int sekundenZeigerRadius;
    private int stundenDecoRadius;
    private int minutenDecoRadius;
    private int sekundenDecoRadius;
    private int stundenZentrumRadius;
    private int sekundenZentrumRadius;
    private int skalaRadius;
    private int skalaGroesse;
    private int gehaeuseRadius;
    private int monatsZentrumX;
    private int monatsZentrumY;
    private int monatsRadius;
    private int tagesZentrumX;
    private int tagesZentrumY;
    private int tagesRadius;

    public UiClockUniverso() {
        this.setPreferredSize(new Dimension(90, 90));
        this.setDayOfMonthVisible(true);
        this.setMonthVisible(true);
        this.setGehaeuseColor(new Color(0xCCCCEE));
        this.setBlattColor(new Color(0xCCCCEE));
        this.setSkalaColor(new Color(0x222288));
        this.setMonthZeigerColor(new Color(0x333388));
        this.setDayOfMonthZeigerColor(new Color(0xEEEE55));
        this.setHourZeigerColor(new Color(0x333388));
        this.setMinuteZeigerColor(new Color(0x333388));
        this.setSecondZeigerColor(new Color(0x333388));
    }

    public void setBlattColor(Color c) {
        this.blattColor = c;
        this.repaint();
    }

    public void setDayOfMonthZeigerColor(Color c) {
        this.dayOfMonthZeigerColor = c;
        this.repaint();
    }

    public void setMonthZeigerColor(Color c) {
        this.monthZeigerColor = c;
        this.repaint();
    }

    public void setDayOfMonthVisible(boolean b) {
        this.dayOfMonthVisible = b;
    }

    public void setMonthVisible(boolean b) {
        this.monthVisible = b;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        super.paintComponent(g);
        this.clockCenter.x = this.getWidth() / 2;
        this.clockCenter.y = this.getHeight() / 2;
        this.gehaeuseRadius = this.getWidth() < this.getHeight() ? this.getWidth() * 5 / 11 : this.getHeight() * 5 / 11;
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(this.gehaeuseColor.brighter());
        g2d.fillOval(this.clockCenter.x - this.gehaeuseRadius - 3, this.clockCenter.y - this.gehaeuseRadius - 3, this.gehaeuseRadius * 2 + 6, this.gehaeuseRadius * 2 + 6);
        g2d.setColor(this.gehaeuseColor.darker());
        g2d.fillArc(this.clockCenter.x - this.gehaeuseRadius - 3, this.clockCenter.y - this.gehaeuseRadius - 3, this.gehaeuseRadius * 2 + 6, this.gehaeuseRadius * 2 + 6, 10, 90);
        g2d.fillArc(this.clockCenter.x - this.gehaeuseRadius - 3, this.clockCenter.y - this.gehaeuseRadius - 3, this.gehaeuseRadius * 2 + 6, this.gehaeuseRadius * 2 + 6, 190, 90);
        g2d.setColor(this.blattColor);
        g2d.fillOval(this.clockCenter.x - this.gehaeuseRadius, this.clockCenter.y - this.gehaeuseRadius, this.gehaeuseRadius * 2, this.gehaeuseRadius * 2);
        g2d.setColor(Color.black);
        g2d.drawOval(this.clockCenter.x - this.gehaeuseRadius - 3, this.clockCenter.y - this.gehaeuseRadius - 3, this.gehaeuseRadius * 2 + 6, this.gehaeuseRadius * 2 + 6);
        g2d.drawOval(this.clockCenter.x - this.gehaeuseRadius, this.clockCenter.y - this.gehaeuseRadius, this.gehaeuseRadius * 2, this.gehaeuseRadius * 2);
        this.skalaRadius = this.gehaeuseRadius * 19 / 20;
        this.skalaGroesse = this.gehaeuseRadius / 11;
        g2d.setColor(this.skalaColor);
        g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 65.0f));
        int i = 0;
        while (i < 60) {
            g2d.drawLine(this.clockCenter.x - (int)(Math.sin((double)i / 30.0 * Math.PI) * (double)this.skalaRadius), this.clockCenter.y - (int)(Math.cos((double)i / 30.0 * Math.PI) * (double)this.skalaRadius), this.clockCenter.x, this.clockCenter.y);
            ++i;
        }
        g2d.setColor(this.blattColor);
        g2d.fillOval(this.clockCenter.x - this.skalaRadius + this.skalaGroesse / 2, this.clockCenter.y - this.skalaRadius + this.skalaGroesse / 2, (this.skalaRadius - this.skalaGroesse / 2) * 2, (this.skalaRadius - this.skalaGroesse / 2) * 2);
        g2d.setColor(this.skalaColor.brighter());
        g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 40.0f));
        i = 0;
        while (i < 12) {
            g2d.drawLine(this.clockCenter.x - (int)(Math.sin((double)i / 6.0 * Math.PI) * (double)this.skalaRadius), this.clockCenter.y - (int)(Math.cos((double)i / 6.0 * Math.PI) * (double)this.skalaRadius), this.clockCenter.x, this.clockCenter.y);
            ++i;
        }
        g2d.setColor(this.blattColor);
        g2d.fillOval(this.clockCenter.x - this.skalaRadius + this.skalaGroesse, this.clockCenter.y - this.skalaRadius + this.skalaGroesse, (this.skalaRadius - this.skalaGroesse) * 2, (this.skalaRadius - this.skalaGroesse) * 2);
        g2d.setColor(this.blattColor.brighter());
        g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 45.0f));
        g2d.drawOval(this.clockCenter.x - this.skalaRadius * 35 / 50, this.clockCenter.y - this.skalaRadius * 35 / 50, this.skalaRadius * 70 / 50, this.skalaRadius * 70 / 50);
        g2d.drawOval(this.clockCenter.x - this.skalaRadius * 32 / 50, this.clockCenter.y - this.skalaRadius * 32 / 50, this.skalaRadius * 64 / 50, this.skalaRadius * 64 / 50);
        g2d.drawOval(this.clockCenter.x - this.skalaRadius * 29 / 50, this.clockCenter.y - this.skalaRadius * 29 / 50, this.skalaRadius * 58 / 50, this.skalaRadius * 58 / 50);
        g2d.setFont(new Font("Times", 2, this.skalaRadius / 6));
        g2d.drawString("oli4", this.clockCenter.x - this.skalaRadius / 8, this.clockCenter.y - this.skalaRadius / 3);
        g2d.setFont(new Font("Times", 2, this.skalaRadius / 9));
        g2d.drawString("1999", this.clockCenter.x - this.skalaRadius / 6, this.clockCenter.y + this.skalaRadius * 8 / 9);
        if (this.monthVisible) {
            this.monatsZentrumX = this.clockCenter.x + this.gehaeuseRadius * 2 / 5;
            this.monatsZentrumY = this.clockCenter.y + this.gehaeuseRadius / 3;
            this.monatsRadius = this.gehaeuseRadius / 3;
            g2d.setColor(this.blattColor.brighter());
            g2d.setStroke(new BasicStroke(1.6f));
            g2d.fillOval(this.monatsZentrumX - this.monatsRadius, this.monatsZentrumY - this.monatsRadius, this.monatsRadius * 2, this.monatsRadius * 2);
            g2d.setColor(this.gehaeuseColor);
            g2d.drawOval(this.monatsZentrumX - this.monatsRadius, this.monatsZentrumY - this.monatsRadius, this.monatsRadius * 2, this.monatsRadius * 2);
            g2d.setColor(this.skalaColor);
            g2d.setStroke(new BasicStroke(1.0f));
            i = 0;
            while (i < 12) {
                g2d.drawLine(this.monatsZentrumX - (int)(Math.sin((double)i / 6.0 * Math.PI) * (double)this.monatsRadius) * 7 / 8, this.monatsZentrumY - (int)(Math.cos((double)i / 6.0 * Math.PI) * (double)this.monatsRadius) * 7 / 8, this.monatsZentrumX, this.monatsZentrumY);
                ++i;
            }
            g2d.setColor(this.blattColor.brighter());
            g2d.fillOval(this.monatsZentrumX - this.monatsRadius * 6 / 8, this.monatsZentrumY - this.monatsRadius * 6 / 8, this.monatsRadius * 12 / 8, this.monatsRadius * 12 / 8);
            g2d.setColor(this.monthZeigerColor);
            g2d.fillOval(this.monatsZentrumX - this.monatsRadius / 6, this.monatsZentrumY - this.monatsRadius / 6, this.monatsRadius / 3, this.monatsRadius / 3);
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 40.0f));
            g2d.draw(new Line2D.Double(this.monatsZentrumX - this.toMonthX(this.monatsRadius / 3), this.monatsZentrumY - this.toMonthY(this.monatsRadius / 3), this.monatsZentrumX + this.toMonthX(this.monatsRadius * 4 / 5), this.monatsZentrumY + this.toMonthY(this.monatsRadius * 4 / 5)));
            g2d.fillOval(this.monatsZentrumX - this.toMonthX(this.monatsRadius / 3) - this.monatsRadius / 8, this.monatsZentrumY - this.toMonthY(this.monatsRadius / 3) - this.monatsRadius / 8, this.monatsRadius / 4, this.monatsRadius / 4);
        }
        if (this.secondVisible) {
            this.tagesZentrumX = this.clockCenter.x - this.gehaeuseRadius * 2 / 5;
            this.tagesZentrumY = this.clockCenter.y + this.gehaeuseRadius / 3;
            this.tagesRadius = this.gehaeuseRadius / 3;
            g2d.setColor(this.blattColor.brighter());
            g2d.setStroke(new BasicStroke(1.6f));
            g2d.fillOval(this.tagesZentrumX - this.tagesRadius, this.tagesZentrumY - this.tagesRadius, this.tagesRadius * 2, this.tagesRadius * 2);
            g2d.setColor(this.gehaeuseColor);
            g2d.drawOval(this.tagesZentrumX - this.tagesRadius, this.tagesZentrumY - this.tagesRadius, this.tagesRadius * 2, this.tagesRadius * 2);
            g2d.setColor(this.skalaColor);
            g2d.setStroke(new BasicStroke(1.0f));
            i = 0;
            while (i < 12) {
                g2d.drawLine(this.tagesZentrumX - (int)(Math.sin((double)i / 6.0 * Math.PI) * (double)this.tagesRadius) * 7 / 8, this.tagesZentrumY - (int)(Math.cos((double)i / 6.0 * Math.PI) * (double)this.tagesRadius) * 7 / 8, this.tagesZentrumX, this.tagesZentrumY);
                ++i;
            }
            g2d.setColor(this.blattColor.brighter());
            g2d.fillOval(this.tagesZentrumX - this.tagesRadius * 6 / 8, this.tagesZentrumY - this.tagesRadius * 6 / 8, this.tagesRadius * 12 / 8, this.tagesRadius * 12 / 8);
            g2d.setColor(this.secondZeigerColor);
            g2d.fillOval(this.tagesZentrumX - this.tagesRadius / 6, this.tagesZentrumY - this.tagesRadius / 6, this.tagesRadius / 3, this.tagesRadius / 3);
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 40.0f));
            g2d.draw(new Line2D.Double(this.tagesZentrumX - this.toSecondX(this.tagesRadius / 3), this.tagesZentrumY - this.toSecondY(this.tagesRadius / 3), this.tagesZentrumX + this.toSecondX(this.tagesRadius * 4 / 5), this.tagesZentrumY + this.toSecondY(this.tagesRadius * 4 / 5)));
            g2d.fillOval(this.tagesZentrumX - this.toSecondX(this.tagesRadius / 3) - this.tagesRadius / 8, this.tagesZentrumY - this.toSecondY(this.tagesRadius / 3) - this.tagesRadius / 8, this.tagesRadius / 4, this.tagesRadius / 4);
        }
        if (this.hourVisible) {
            this.stundenZeigerRadius = this.gehaeuseRadius * 13 / 20;
            this.stundenZentrumRadius = this.gehaeuseRadius / 10;
            g2d.setColor(this.hourZeigerColor);
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 22.0f));
            g2d.draw(new Line2D.Double(this.clockCenter.x - this.toHourX(this.stundenZeigerRadius / 3), this.clockCenter.y - this.toHourY(this.stundenZeigerRadius / 3), this.clockCenter.x + this.toHourX(this.stundenZeigerRadius * 30 / 50), this.clockCenter.y + this.toHourY(this.stundenZeigerRadius * 30 / 50)));
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 33.0f));
            g2d.draw(new Line2D.Double(this.clockCenter.x - this.toHourX(this.stundenZeigerRadius / 3), this.clockCenter.y - this.toHourY(this.stundenZeigerRadius / 3), this.clockCenter.x + this.toHourX(this.stundenZeigerRadius), this.clockCenter.y + this.toHourY(this.stundenZeigerRadius)));
            this.stundenDecoRadius = this.gehaeuseRadius / 10;
            g2d.fillOval(this.clockCenter.x + this.toHourX(this.stundenZeigerRadius * 30 / 50) - this.stundenDecoRadius, this.clockCenter.y + this.toHourY(this.stundenZeigerRadius * 30 / 50) - this.stundenDecoRadius, this.stundenDecoRadius * 2, this.stundenDecoRadius * 2);
            g2d.setColor(this.blattColor);
            g2d.fillOval(this.clockCenter.x + this.toHourX(this.stundenZeigerRadius * 31 / 50) - this.stundenDecoRadius / 2, this.clockCenter.y + this.toHourY(this.stundenZeigerRadius * 31 / 50) - this.stundenDecoRadius / 2, this.stundenDecoRadius, this.stundenDecoRadius);
        }
        if (this.minuteVisible) {
            this.minutenZeigerRadius = this.gehaeuseRadius * 18 / 20;
            g2d.setColor(this.minuteZeigerColor);
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 22.0f));
            g2d.draw(new Line2D.Double(this.clockCenter.x - this.toMinuteX(this.minutenZeigerRadius / 3), this.clockCenter.y - this.toMinuteY(this.minutenZeigerRadius / 3), this.clockCenter.x + this.toMinuteX(this.minutenZeigerRadius * 35 / 50), this.clockCenter.y + this.toMinuteY(this.minutenZeigerRadius * 35 / 50)));
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 33.0f));
            g2d.draw(new Line2D.Double(this.clockCenter.x - this.toMinuteX(this.minutenZeigerRadius / 3), this.clockCenter.y - this.toMinuteY(this.minutenZeigerRadius / 3), this.clockCenter.x + this.toMinuteX(this.minutenZeigerRadius), this.clockCenter.y + this.toMinuteY(this.minutenZeigerRadius)));
            this.minutenDecoRadius = this.gehaeuseRadius / 12;
            g2d.fillOval(this.clockCenter.x + this.toMinuteX(this.minutenZeigerRadius * 35 / 50) - this.minutenDecoRadius, this.clockCenter.y + this.toMinuteY(this.minutenZeigerRadius * 35 / 50) - this.minutenDecoRadius, this.minutenDecoRadius * 2, this.minutenDecoRadius * 2);
            g2d.setColor(this.blattColor);
            g2d.fillOval(this.clockCenter.x + this.toMinuteX(this.minutenZeigerRadius * 36 / 50) - this.minutenDecoRadius / 2, this.clockCenter.y + this.toMinuteY(this.minutenZeigerRadius * 36 / 50) - this.minutenDecoRadius / 2, this.minutenDecoRadius, this.minutenDecoRadius);
            g2d.setColor(this.minuteZeigerColor);
            g2d.fillOval(this.clockCenter.x - this.stundenZentrumRadius, this.clockCenter.y - this.stundenZentrumRadius, this.stundenZentrumRadius * 2, this.stundenZentrumRadius * 2);
        }
        if (this.dayOfMonthVisible) {
            this.sekundenZeigerRadius = this.gehaeuseRadius * 16 / 20;
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 50.0f));
            g2d.setColor(this.dayOfMonthZeigerColor);
            g2d.draw(new Line2D.Double(this.clockCenter.x - this.toDayX(this.sekundenZeigerRadius / 3), this.clockCenter.y - this.toDayY(this.sekundenZeigerRadius / 3), this.clockCenter.x + this.toDayX(this.sekundenZeigerRadius), this.clockCenter.y + this.toDayY(this.sekundenZeigerRadius)));
            this.sekundenZentrumRadius = this.gehaeuseRadius / 20;
            g2d.fillOval(this.clockCenter.x - this.sekundenZentrumRadius, this.clockCenter.y - this.sekundenZentrumRadius, this.sekundenZentrumRadius * 2, this.sekundenZentrumRadius * 2);
            this.sekundenDecoRadius = this.gehaeuseRadius / 15;
            g2d.fillOval(this.clockCenter.x - this.toDayX(this.sekundenZeigerRadius / 3) - this.sekundenDecoRadius, this.clockCenter.y - this.toDayY(this.sekundenZeigerRadius / 3) - this.sekundenDecoRadius, this.sekundenDecoRadius * 2, this.sekundenDecoRadius * 2);
            g2d.setStroke(new BasicStroke((float)this.gehaeuseRadius / 30.0f));
            g2d.drawArc(this.clockCenter.x + this.toDayX(this.sekundenZeigerRadius + this.sekundenDecoRadius) - this.sekundenDecoRadius, this.clockCenter.y + this.toDayY(this.sekundenZeigerRadius + this.sekundenDecoRadius) - this.sekundenDecoRadius, this.sekundenDecoRadius * 2, this.sekundenDecoRadius * 2, 180 - this.dayOfMonth * 6, 180);
        }
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        UiClockUniverso c = new UiClockUniverso();
        c.start();
        p.add((Component)c, "Center");
        f.getContentPane().add(p);
        f.setSize(new Dimension(200, 200));
        f.setVisible(true);
    }
}

