/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.signal;

import ch.oli4.ui.signal.UiSignal;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public abstract class UiSignalBool
extends UiSignal {
    private boolean booleanData;
    private Timer blinkTimer;
    private boolean blinkToggle;
    private boolean blinkEnable;
    private int blinkPeriod;

    public UiSignalBool() {
        this.setDataRange(0.0, 1.0);
        this.setBlinkPeriod(0);
    }

    public void setData(boolean b) {
        this.booleanData = b;
        if (b) {
            this.setData(1.0);
        } else {
            this.setData(0.0);
        }
    }

    public boolean getBoolData() {
        return this.booleanData;
    }

    public void setBlinkPeriod(int period) {
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
        }
        this.blinkPeriod = period;
        this.blinkToggle = true;
        if (this.blinkPeriod != 0) {
            this.blinkEnable = true;
            this.blinkTimer = new Timer(this.blinkPeriod, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    UiSignalBool.this.doBlink();
                }
            });
            this.blinkTimer.setRepeats(true);
            this.blinkTimer.setCoalesce(true);
            this.blinkTimer.start();
        } else {
            this.blinkEnable = false;
            if (this.blinkTimer != null) {
                this.blinkTimer.stop();
            }
        }
    }

    private void doBlink() {
        if (this.blinkEnable && this.booleanData) {
            if (this.blinkToggle) {
                this.setData(1.0);
                this.blinkToggle = false;
            } else {
                this.setData(0.0);
                this.blinkToggle = true;
            }
        }
    }
}

