/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio;

import ch.laoe.audio.Audio;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class AudioPlotter {
    protected Audio audio;
    protected int xPlayPointer;
    protected int xLoopStartPointer;
    protected int xLoopEndPointer;

    protected AudioPlotter(Audio audio) {
        this.audio = audio;
    }

    public Audio getAudio() {
        return this.audio;
    }

    public void paintPlayPointer(Graphics2D graphics2D, Rectangle rectangle, Color color) {
        this.xPlayPointer = this.audio.getClip().getSelectedLayer().getChannel(0).getPlotter().sampleToGraphX(this.audio.getPlayPointer());
        int n = (int)rectangle.getX();
        int n2 = (int)(rectangle.getX() + rectangle.getHeight());
        graphics2D.setClip(rectangle);
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setColor(color);
        graphics2D.drawLine(this.xPlayPointer, n, this.xPlayPointer, n2);
    }

    public int getXPlayPointer() {
        return this.xPlayPointer;
    }

    public void paintLoopPointer(Graphics2D graphics2D, Rectangle rectangle, Color color) {
        int n = (int)rectangle.getX();
        int n2 = (int)(rectangle.getX() + rectangle.getHeight());
        int n3 = 5;
        graphics2D.setClip(rectangle);
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.setColor(color);
        this.xLoopStartPointer = this.audio.getClip().getSelectedLayer().getChannel(0).getPlotter().sampleToGraphX(this.audio.getLoopStartPointer());
        graphics2D.drawLine(this.xLoopStartPointer, n, this.xLoopStartPointer, n2);
        this.xLoopEndPointer = this.audio.getClip().getSelectedLayer().getChannel(0).getPlotter().sampleToGraphX(this.audio.getLoopEndPointer());
        graphics2D.drawLine(this.xLoopEndPointer, n, this.xLoopEndPointer, n2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        graphics2D.fillRect(this.xLoopStartPointer, n2 - n3, this.xLoopEndPointer - this.xLoopStartPointer, n3);
    }

    public int getXLoopStartPointer() {
        return this.xLoopStartPointer;
    }

    public int getXLoopEndPointer() {
        return this.xLoopEndPointer;
    }
}

