/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio.save;

import ch.laoe.audio.AudioException;
import ch.laoe.audio.save.ASave;
import ch.laoe.audio.save.ASavePcmSigned16BitBigEndian;
import ch.laoe.audio.save.ASavePcmSigned16BitLittleEndian;
import ch.laoe.audio.save.ASavePcmSigned8Bit;
import ch.laoe.audio.save.ASavePcmUnsigned16BitBigEndian;
import ch.laoe.audio.save.ASavePcmUnsigned16BitLittleEndian;
import ch.laoe.audio.save.ASavePcmUnsigned8Bit;
import ch.laoe.audio.save.ASaveUlaw8Bit;
import ch.laoe.clip.AClip;
import java.io.File;
import java.util.ArrayList;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;

public class ASaveFactory {
    private static ArrayList<ASave> classList;

    private static void preloadClasses() {
        classList = new ArrayList();
        classList.add(new ASavePcmUnsigned8Bit());
        classList.add(new ASavePcmSigned8Bit());
        classList.add(new ASavePcmUnsigned16BitLittleEndian());
        classList.add(new ASavePcmUnsigned16BitBigEndian());
        classList.add(new ASavePcmSigned16BitLittleEndian());
        classList.add(new ASavePcmSigned16BitBigEndian());
        classList.add(new ASaveUlaw8Bit());
    }

    public static final ASave create(AClip aClip, File file) throws AudioException {
        AudioFormat audioFormat = new AudioFormat(aClip.getAudio().getEncoding(), aClip.getSampleRate(), aClip.getSampleWidth(), aClip.getMaxNumberOfChannels(), aClip.getSampleWidth() / 8 * aClip.getMaxNumberOfChannels(), aClip.getSampleRate(), aClip.isBigEndian());
        AudioFileFormat audioFileFormat = new AudioFileFormat(aClip.getAudio().getFileType(), audioFormat, aClip.getMaxSampleLength());
        ASave aSave = ASaveFactory.create(audioFormat);
        if (aSave == null) {
            throw new AudioException("unsupportedAudioFormat");
        }
        aSave.setAudioFileFormat(audioFileFormat);
        aSave.setFile(file);
        aSave.setClip(aClip);
        return aSave;
    }

    private static final ASave create(AudioFormat audioFormat) {
        for (int i = 0; i < classList.size(); ++i) {
            ASave aSave = classList.get(i);
            if (!aSave.supports(audioFormat)) continue;
            return aSave.duplicate();
        }
        return null;
    }

    static {
        ASaveFactory.preloadClasses();
    }
}

