/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.ui.GToolkit;
import ch.laoe.ui.LProgressViewer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.WeakHashMap;

public class MMArray {
    private ArrayList<Page> pages = new ArrayList();
    private int length;
    private final float initialValue;
    private static final int MIN_NUMBER_OF_PAGES_BEFORE_BACKUP = 8;
    private static final String filePath = GToolkit.getLaoeUserHomePath() + "cache/";
    private static final String fileExtension = ".page.tmp";
    private static int uniqueId = 0;

    public MMArray(int n, float f) {
        this.length = n;
        this.initialValue = f;
        this.allocatePages(n);
    }

    public MMArray(MMArray mMArray) {
        this(mMArray.getLength(), mMArray.initialValue);
        int n = mMArray.getLength();
        for (int i = 0; i < n; ++i) {
            this.set(i, mMArray.get(i));
        }
    }

    public final void destroy() {
        LProgressViewer.getInstance().entrySubProgress(0.3, "destroy");
        for (int i = 0; i < this.pages.size(); ++i) {
            LProgressViewer.getInstance().setProgress(1.0 * (double)(i + 1) / (double)this.pages.size());
            Page page = this.pages.get(i);
            PageManager.getInstance().remove(page);
            page.destroy();
        }
        this.pages.clear();
        LProgressViewer.getInstance().exitSubProgress();
    }

    public final void finalize() {
        this.destroy();
    }

    private boolean allocatePages(int n) {
        boolean bl = false;
        while (n >= this.pages.size() * 0x200000) {
            Page page = new Page(this.initialValue);
            this.pages.add(page);
            PageManager.getInstance().add(page);
            bl = true;
        }
        return bl;
    }

    public final void cleanup() {
        for (int i = this.pages.size() - 1; i >= 0 && this.pages.get(i).hasInitialValuesOnly(); --i) {
            Page page = this.pages.get(i);
            page.destroy();
            this.pages.remove(page);
        }
        this.length = Math.min(this.length, this.pages.size() * 0x200000);
    }

    public final int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public final int getMemoryUsage() {
        int n = 0;
        for (Page page : this.pages) {
            if (page.state != 1) continue;
            n += 0x200000;
        }
        return n;
    }

    public final boolean isInRange(int n) {
        return n >= 0 && n < this.length;
    }

    public final float get(int n) {
        try {
            return this.pages.get(n >> 21).get(n & 0x1FFFFF);
        }
        catch (Exception exception) {
            return this.initialValue;
        }
    }

    public final void set(int n, float f) {
        if (n < 0) {
            return;
        }
        if (n < this.pages.size() * 0x200000 || this.allocatePages(n)) {
            // empty if block
        }
        if (n >= this.length) {
            this.length = n + 1;
        }
        this.pages.get(n >> 21).set(n & 0x1FFFFF, f);
    }

    public void clear() {
        if (this.length - 1 < this.pages.size() * 0x200000 || this.allocatePages(this.length - 1)) {
            // empty if block
        }
        for (int i = 0; i < this.length; ++i) {
            this.pages.get(i >> 21).set(i & 0x1FFFFF, this.initialValue);
        }
    }

    public final void set(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            this.set(i, fArray[i]);
        }
        this.length = fArray.length;
    }

    public final void copy(MMArray mMArray, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            this.set(n2 + i, mMArray.get(n + i));
        }
    }

    public static String getPageInfo() {
        return PageManager.getInstance().getPageInfoShort();
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3;
        System.out.println("test array with initial value of zero...");
        MMArray mMArray = new MMArray(100, 0.0f);
        if (mMArray.getLength() != 100) {
            throw new Error("failed 1");
        }
        if (!mMArray.isInRange(0)) {
            throw new Error("failed 2");
        }
        if (mMArray.isInRange(-1)) {
            throw new Error("failed 3");
        }
        if (!mMArray.isInRange(66)) {
            throw new Error("failed 4");
        }
        if (!mMArray.isInRange(99)) {
            throw new Error("failed 5");
        }
        if (mMArray.isInRange(100)) {
            throw new Error("failed 6");
        }
        if (mMArray.get(0) != 0.0f) {
            throw new Error("failed 7");
        }
        if (mMArray.get(55) != 0.0f) {
            throw new Error("failed 8");
        }
        if (mMArray.get(99) != 0.0f) {
            throw new Error("failed 9");
        }
        if (mMArray.get(333) != 0.0f) {
            throw new Error("failed 10");
        }
        mMArray.set(77, 4.0f);
        if (mMArray.get(77) != 4.0f) {
            throw new Error("failed 11");
        }
        if (mMArray.getLength() != 100) {
            throw new Error("failed 12");
        }
        mMArray.set(111, 7.0f);
        if (mMArray.get(77) != 4.0f) {
            throw new Error("failed 21");
        }
        if (mMArray.get(110) != 0.0f) {
            throw new Error("failed 22");
        }
        if (mMArray.get(111) != 7.0f) {
            throw new Error("failed 23");
        }
        if (mMArray.getLength() != 112) {
            throw new Error("failed 24");
        }
        mMArray.set(1111, 7777.0f);
        if (mMArray.get(77) != 4.0f) {
            throw new Error("failed 31");
        }
        if (mMArray.get(111) != 7.0f) {
            throw new Error("failed 32");
        }
        if (mMArray.get(1110) != 0.0f) {
            throw new Error("failed 34");
        }
        if (mMArray.get(1111) != 7777.0f) {
            throw new Error("failed 35");
        }
        if (mMArray.getLength() != 1112) {
            throw new Error("failed 36");
        }
        if (!mMArray.isInRange(0)) {
            throw new Error("failed 36a");
        }
        if (mMArray.isInRange(-1)) {
            throw new Error("failed 36b");
        }
        if (!mMArray.isInRange(66)) {
            throw new Error("failed 36c");
        }
        if (!mMArray.isInRange(99)) {
            throw new Error("failed 36d");
        }
        if (!mMArray.isInRange(100)) {
            throw new Error("failed 36e");
        }
        if (!mMArray.isInRange(1111)) {
            throw new Error("failed 36f");
        }
        if (mMArray.isInRange(1112)) {
            throw new Error("failed 36g");
        }
        if (mMArray.isInRange(999999)) {
            throw new Error("failed 36h");
        }
        System.out.println("test copied array...");
        MMArray mMArray2 = new MMArray(mMArray);
        if (mMArray2.get(77) != 4.0f) {
            throw new Error("failed 41");
        }
        if (mMArray2.get(111) != 7.0f) {
            throw new Error("failed 42");
        }
        if (mMArray2.get(1110) != 0.0f) {
            throw new Error("failed 44");
        }
        if (mMArray2.get(1111) != 7777.0f) {
            throw new Error("failed 45");
        }
        if (mMArray2.getLength() != 1112) {
            throw new Error("failed 46");
        }
        mMArray2.set(1234, 2345.0f);
        if (mMArray2.get(1234) != 2345.0f) {
            throw new Error("failed 47");
        }
        if (mMArray2.getLength() != 1235) {
            throw new Error("failed 48");
        }
        if (mMArray.get(1234) != 0.0f) {
            throw new Error("failed 49");
        }
        if (mMArray.getLength() != 1112) {
            throw new Error("failed 49b");
        }
        System.out.println("test array with initial value other than zero...");
        MMArray mMArray3 = new MMArray(100, 69.0f);
        if (mMArray3.getLength() != 100) {
            throw new Error("failed 51");
        }
        if (mMArray3.get(0) != 69.0f) {
            throw new Error("failed 52");
        }
        if (mMArray3.get(55) != 69.0f) {
            throw new Error("failed 53");
        }
        if (mMArray3.get(99) != 69.0f) {
            throw new Error("failed 54");
        }
        if (mMArray3.get(333) != 69.0f) {
            throw new Error("failed 55");
        }
        mMArray3.set(77, 4.0f);
        if (mMArray3.get(77) != 4.0f) {
            throw new Error("failed 61");
        }
        if (mMArray3.getLength() != 100) {
            throw new Error("failed 62");
        }
        mMArray3.set(111, 7.0f);
        if (mMArray3.get(77) != 4.0f) {
            throw new Error("failed 71");
        }
        if (mMArray3.get(110) != 69.0f) {
            throw new Error("failed 72");
        }
        if (mMArray3.get(111) != 7.0f) {
            throw new Error("failed 73");
        }
        if (mMArray3.getLength() != 112) {
            throw new Error("failed 74");
        }
        mMArray3.set(1111, 7777.0f);
        if (mMArray3.get(77) != 4.0f) {
            throw new Error("failed 81");
        }
        if (mMArray3.get(111) != 7.0f) {
            throw new Error("failed 82");
        }
        if (mMArray3.get(1110) != 69.0f) {
            throw new Error("failed 84");
        }
        if (mMArray3.get(1111) != 7777.0f) {
            throw new Error("failed 85");
        }
        if (mMArray3.getLength() != 1112) {
            throw new Error("failed 86");
        }
        System.out.println("test array replaced...");
        mMArray3.set(new float[]{1.0f, 2.0f, 3.0f, 4.0f});
        if (mMArray3.getLength() != 4) {
            throw new Error("failed 91");
        }
        if (mMArray3.get(0) != 1.0f) {
            throw new Error("failed 92");
        }
        if (mMArray3.get(2) != 3.0f) {
            throw new Error("failed 93");
        }
        if (mMArray3.get(3) != 4.0f) {
            throw new Error("failed 94");
        }
        if (mMArray3.get(4) != 69.0f) {
            throw new Error("failed 95");
        }
        System.out.println("test length setting..");
        MMArray mMArray4 = new MMArray(100, 69.0f);
        if (mMArray4.getLength() != 100) {
            throw new Error("failed 901");
        }
        mMArray4.set(55, 70.0f);
        if (mMArray4.get(54) != 69.0f) {
            throw new Error("failed 902");
        }
        if (mMArray4.get(55) != 70.0f) {
            throw new Error("failed 903");
        }
        if (mMArray4.get(56) != 69.0f) {
            throw new Error("failed 904");
        }
        if (mMArray4.get(99) != 69.0f) {
            throw new Error("failed 905");
        }
        mMArray4.setLength(200);
        if (mMArray4.getLength() != 200) {
            throw new Error("failed 906");
        }
        if (mMArray4.get(150) != 69.0f) {
            throw new Error("failed 907");
        }
        mMArray4.set(150, 45.0f);
        if (mMArray4.get(150) != 45.0f) {
            throw new Error("failed 908");
        }
        mMArray4.setLength(50);
        if (mMArray4.get(49) != 69.0f) {
            throw new Error("failed 909");
        }
        System.out.println("test array copy in range...");
        mMArray4 = new MMArray(100, 44.0f);
        MMArray mMArray5 = new MMArray(100, 44.0f);
        for (n3 = 0; n3 < mMArray4.getLength(); ++n3) {
            mMArray4.set(n3, n3);
        }
        mMArray5.copy(mMArray4, 40, 0, 10);
        for (n3 = 0; n3 < 10; ++n3) {
            if (mMArray5.get(n3) == (float)(40 + n3)) continue;
            throw new Error("failed " + (100 + n3));
        }
        if (mMArray5.get(39) != 44.0f) {
            throw new Error("failed 111");
        }
        if (mMArray5.get(50) != 44.0f) {
            throw new Error("failed 112");
        }
        System.out.println("test array copy extra range...");
        mMArray4 = new MMArray(70, 22.0f);
        mMArray5 = new MMArray(600, 44.0f);
        for (n3 = 0; n3 < mMArray4.getLength(); ++n3) {
            mMArray4.set(n3, n3);
        }
        mMArray5.copy(mMArray4, 40, 0, 300);
        for (n3 = 0; n3 < 20; ++n3) {
            if (mMArray5.get(n3) == (float)(40 + n3)) continue;
            throw new Error("failed " + (200 + n3));
        }
        if (mMArray5.get(299) != 22.0f) {
            throw new Error("failed 221");
        }
        if (mMArray5.get(300) != 44.0f) {
            throw new Error("failed 222");
        }
        System.out.println("test array growing...");
        mMArray4 = new MMArray(5, 0.0f);
        mMArray4.set(5000000, 99.0f);
        if (mMArray4.get(5000000) != 99.0f) {
            throw new Error("failed 921");
        }
        if (mMArray4.get(4999990) != 0.0f) {
            throw new Error("failed 922");
        }
        if (mMArray4.get(5000010) != 0.0f) {
            throw new Error("failed 923");
        }
        mMArray4.set(10000000, 66.0f);
        if (mMArray4.get(10000000) != 66.0f) {
            throw new Error("failed 924");
        }
        mMArray4.set(20000000, 77.0f);
        if (mMArray4.get(20000000) != 77.0f) {
            throw new Error("failed 925");
        }
        mMArray4.set(40000000, 77.0f);
        if (mMArray4.get(40000000) != 77.0f) {
            throw new Error("failed 926");
        }
        mMArray4.set(80000000, 77.0f);
        if (mMArray4.get(80000000) != 77.0f) {
            throw new Error("failed 927");
        }
        mMArray4.set(160000000, 77.0f);
        if (mMArray4.get(160000000) != 77.0f) {
            throw new Error("failed 928");
        }
        System.out.println("test array growing: writing all pages...");
        mMArray4 = new MMArray(5, 0.0f);
        int n4 = 0x6400000;
        for (n3 = 0; n3 < n4; ++n3) {
            mMArray4.set(n3, n3);
        }
        System.out.println("test array growing: reading all pages...");
        for (n3 = 0; n3 < n4; ++n3) {
            if (mMArray4.get(n3) == (float)n3) continue;
            throw new Error("failed 930 i=" + n3);
        }
        System.out.print("profiling calibration...            ");
        mMArray4 = new MMArray(2000000, 0.0f);
        long l = System.currentTimeMillis();
        int n5 = mMArray4.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n5; ++n) {
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray4.getLength() + " ps/element");
        System.out.print("profiling get()...                  ");
        mMArray4 = new MMArray(2000000, 0.0f);
        l = System.currentTimeMillis();
        n5 = mMArray4.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n5; ++n) {
                mMArray4.get(n);
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray4.getLength() + " ps/element");
        System.out.print("profiling set()...                  ");
        mMArray4 = new MMArray(2000000, 0.0f);
        l = System.currentTimeMillis();
        n5 = mMArray4.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n5; ++n) {
                mMArray4.set(n, n);
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray4.getLength() + " ps/element");
        System.out.print("profiling manual get() and set()... ");
        mMArray4 = new MMArray(2000000, 0.0f);
        l = System.currentTimeMillis();
        n5 = mMArray4.getLength();
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 0; n < n5; ++n) {
                mMArray4.set(n, mMArray4.get(n + 2));
            }
        }
        System.out.println("" + (System.currentTimeMillis() - l) * 10000000L / (long)mMArray4.getLength() + " ps/element");
        System.out.print("profiling copy() in range...        ");
        mMArray4 = new MMArray(2000000, 44.0f);
        MMArray mMArray6 = new MMArray(2000001, 22.0f);
        long l2 = System.currentTimeMillis();
        for (n2 = 0; n2 < 100; ++n2) {
            mMArray6.copy(mMArray4, 0, 0, mMArray4.getLength());
        }
        System.out.println("" + (System.currentTimeMillis() - l2) * 10000000L / (long)mMArray4.getLength() + " ps/element");
        System.out.print("profiling copy() extra range...     ");
        mMArray4 = new MMArray(2000000, 44.0f);
        mMArray6 = new MMArray(2000001, 22.0f);
        l2 = System.currentTimeMillis();
        for (n2 = 0; n2 < 100; ++n2) {
            mMArray6.copy(mMArray4, 0, 0, mMArray6.getLength());
        }
        System.out.println("" + (System.currentTimeMillis() - l2) * 10000000L / (long)mMArray6.getLength() + " ps/element");
        System.out.println("if not failed then passed...!");
    }

    private class Page
    implements Comparable<Page> {
        private float[] samples = null;
        private float initialValue;
        private static final int PAGE_SIZE = 0x200000;
        private static final int PAGE_PWR = 21;
        private static final int PAGE_MASK = 0x1FFFFF;
        private File file;
        private long restoreTime;
        public static final int STATE_BLANK = 0;
        public static final int STATE_IN_MEMORY = 1;
        public static final int STATE_SERIALIZED = 2;
        public static final int STATE_DESTROYED = 3;
        private int state;

        public Page(float f) {
            this.initialValue = f;
            this.file = new File(filePath + uniqueId + MMArray.fileExtension);
            this.file.deleteOnExit();
            uniqueId++;
            this.restoreTime = 0L;
            this.state = 0;
        }

        @Override
        public int compareTo(Page page) {
            if (this.restoreTime > page.restoreTime) {
                return 1;
            }
            return -1;
        }

        public void backup() {
            try {
                this.saveSamples(new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.file))));
                this.samples = null;
                this.state = 2;
                System.gc();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void restore() {
            if (this.samples == null) {
                this.samples = new float[0x200000];
                this.state = 1;
                if (this.initialValue != 0.0f) {
                    for (int i = 0; i < this.samples.length; ++i) {
                        this.samples[i] = this.initialValue;
                    }
                }
            }
            if (this.file.exists()) {
                try {
                    this.loadSamples(new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.file))));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.restoreTime = System.currentTimeMillis();
            PageManager.getInstance().backup(this);
        }

        public void destroy() {
            this.samples = null;
            this.state = 3;
            this.file.delete();
            System.gc();
        }

        public final void finalize() {
            this.destroy();
        }

        public boolean hasInitialValuesOnly() {
            if (this.state != 1) {
                this.restore();
            }
            for (int i = 0; i < this.samples.length; ++i) {
                if (this.samples[i] == this.initialValue) continue;
                return false;
            }
            return false;
        }

        public float get(int n) {
            if (this.state != 1) {
                this.restore();
            }
            return this.samples[n];
        }

        public void set(int n, float f) {
            if (this.state != 1) {
                this.restore();
            }
            this.samples[n] = f;
        }

        private void loadSamples(ObjectInputStream objectInputStream) throws IOException {
            for (int i = 0; i < this.samples.length; ++i) {
                this.samples[i] = objectInputStream.readFloat();
            }
        }

        private void saveSamples(ObjectOutputStream objectOutputStream) throws IOException {
            for (int i = 0; i < this.samples.length; ++i) {
                objectOutputStream.writeFloat(this.samples[i]);
            }
            objectOutputStream.flush();
        }
    }

    private static final class PageManager {
        private static PageManager instance = null;
        private WeakHashMap<Page, Object> allPages = new WeakHashMap();
        private int pageCounter = 0;

        private PageManager() {
        }

        public static PageManager getInstance() {
            if (instance == null) {
                instance = new PageManager();
            }
            return instance;
        }

        public synchronized String getPageInfo() {
            return "pages: blank=" + this.getPages(0) + " in-memory=" + this.getPages(1) + " serialized=" + this.getPages(2) + " destroyed=" + this.getPages(3) + " total=" + this.allPages.size() + " counter=" + this.pageCounter + " ";
        }

        public synchronized String getPageInfoShort() {
            return "" + this.getPages(0) + " / " + this.getPages(1) + " / " + this.getPages(2) + " / " + this.allPages.size();
        }

        public synchronized void add(Page page) {
            this.allPages.put(page, null);
            ++this.pageCounter;
        }

        public synchronized void remove(Page page) {
            this.allPages.remove(page);
        }

        private int getPages(int n) {
            int n2 = 0;
            for (Page page : this.allPages.keySet()) {
                if (page.state != n) continue;
                ++n2;
            }
            return n2;
        }

        public synchronized void backup(Page page) {
            if (this.getPages(1) > 8 && Runtime.getRuntime().freeMemory() < Runtime.getRuntime().totalMemory() / 6L) {
                ArrayList<Page> arrayList = new ArrayList<Page>(this.allPages.keySet());
                Collections.sort(arrayList);
                for (int i = 0; i < arrayList.size(); ++i) {
                    Page page2 = (Page)arrayList.get(i);
                    if (page2.state != 1 || page2 == page) continue;
                    page2.backup();
                    break;
                }
            }
        }
    }
}

