/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;

public class AOLowPass
extends AOperation {
    private float dry;
    private float wet;
    private float freq;

    public AOLowPass(float f, float f2, float f3) {
        this.dry = f;
        this.wet = f2;
        this.freq = f3;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        MMArray mMArray2 = new MMArray(n2, 0.0f);
        float f = AOToolkit.rmsAverage(mMArray, n, n2);
        aChannelSelection.getChannel().markChange();
        mMArray2.copy(mMArray, n, 0, n2);
        AOToolkit.setIirLowPass(mMArray2, 0, n2, this.dry, this.wet, this.freq);
        float f2 = AOToolkit.rmsAverage(mMArray2, 0, n2);
        AOToolkit.multiply(mMArray2, 0, n2, f / f2);
        for (int i = 0; i < n2; ++i) {
            mMArray.set(i + n, aChannelSelection.mixIntensity(i + n, mMArray.get(i + n), mMArray2.get(i)));
        }
        AOToolkit.applyZeroCross(mMArray, n);
        AOToolkit.applyZeroCross(mMArray, n + n2);
    }
}

