/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.Debug;

public class AOPitchShift
extends AOperation {
    private float shiftFactor;
    private int transitionLength;
    private MMArray buffer;

    public AOPitchShift(int n, float f) {
        this(1.0f, n, f);
    }

    public AOPitchShift(float f, int n, float f2) {
        this.shiftFactor = f;
        this.buffer = new MMArray(n, 0.0f);
        this.transitionLength = (int)((float)n * f2);
    }

    @Override
    public void operate(AChannelSelection aChannelSelection, AChannelSelection aChannelSelection2) {
        this.performPitchShift(aChannelSelection, aChannelSelection2);
    }

    @Override
    public final void operate(AChannelSelection aChannelSelection) {
        this.performPitchShift(aChannelSelection, null);
    }

    private void performPitchShift(AChannelSelection aChannelSelection, AChannelSelection aChannelSelection2) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        aChannelSelection.getChannel().markChange();
        try {
            MMArray mMArray2 = new MMArray(n2, 0.0f);
            mMArray2.copy(mMArray, n, 0, mMArray2.getLength());
            int n3 = this.buffer.getLength() - this.transitionLength;
            for (int i = n; i < n + n2; i += n3) {
                float f;
                int n4;
                for (n4 = 0; n4 < this.buffer.getLength(); ++n4) {
                    f = aChannelSelection2 != null ? (float)(i - n) + (float)n4 * aChannelSelection2.getChannel().getSamples().get(i) : (float)(i - n) + (float)n4 * this.shiftFactor;
                    if (f < (float)n2) {
                        this.buffer.set(n4, AOToolkit.interpolate3(mMArray2, f));
                        continue;
                    }
                    this.buffer.set(n4, AOToolkit.interpolate3(mMArray2, n4));
                }
                for (n4 = 0; n4 < this.buffer.getLength(); ++n4) {
                    if (i + n4 >= n + n2) continue;
                    if (n4 < this.transitionLength) {
                        float f2 = (float)n4 / (float)this.transitionLength;
                        f2 *= f2;
                        float f3 = (float)(this.transitionLength - n4) / (float)this.transitionLength;
                        f3 *= f3;
                        f = mMArray.get(i + n4) * f3 + this.buffer.get(n4) * f2;
                    } else {
                        f = this.buffer.get(n4);
                    }
                    mMArray.set(i + n4, aChannelSelection.mixIntensity(i + n4, mMArray.get(i + n4), f));
                }
            }
            AOToolkit.applyZeroCross(mMArray, n);
            AOToolkit.applyZeroCross(mMArray, n + n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.printStackTrace(5, arrayIndexOutOfBoundsException);
        }
    }
}

