/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOperation;

public class AOReverse
extends AOperation {
    private int mode;
    public static final int MIRROR_LEFT_SIDE = 1;
    public static final int MIRROR_RIGHT_SIDE = 2;
    public static final int REVERSE = 3;

    public AOReverse(int n) {
        this.mode = n;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        aChannelSelection.getChannel().markChange();
        switch (this.mode) {
            case 1: {
                this.mirrorLeft(aChannelSelection);
                break;
            }
            case 2: {
                this.mirrorRight(aChannelSelection);
                break;
            }
            case 3: {
                this.reverse(aChannelSelection);
            }
        }
    }

    private void mirrorLeft(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        MMArray mMArray2 = new MMArray(mMArray.getLength() + n2, 0.0f);
        try {
            mMArray2.copy(mMArray, 0, 0, n);
            for (int i = 0; i < n2; ++i) {
                mMArray2.set(i + n, mMArray.get(n + n2 - i - 1));
            }
            mMArray2.copy(mMArray, n, n + n2, mMArray.getLength() - n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        aChannelSelection.getChannel().setSamples(mMArray2);
    }

    private void mirrorRight(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        MMArray mMArray2 = new MMArray(mMArray.getLength() + n2, 0.0f);
        try {
            mMArray2.copy(mMArray, 0, 0, n + n2);
            for (int i = 0; i < n2; ++i) {
                mMArray2.set(i + n + n2 - 1, mMArray.get(n + n2 - i - 1));
            }
            mMArray2.copy(mMArray, n + n2, n + n2 + n2, mMArray.getLength() - n - n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        aChannelSelection.getChannel().setSamples(mMArray2);
    }

    private void reverse(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        MMArray mMArray2 = new MMArray(n2, 0.0f);
        try {
            mMArray2.copy(mMArray, n, 0, n2);
            for (int i = 0; i < n2; ++i) {
                mMArray.set(i + n, mMArray2.get(n2 - i - 1));
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

