/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannel2DSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.ui.Debug;
import ch.laoe.ui.LProgressViewer;

public class AOSpectrogramBlockProcessing {
    private Processor processor;
    private int fftWindowType = 6;
    private int fftBlockLength = 512;
    private float overlapFactor = 0.5f;
    private boolean rmsAdaptionEnabled = false;
    private boolean zeroCrossEnabled = false;
    private MMArray re;
    private MMArray im;
    private MMArray tmp;

    public AOSpectrogramBlockProcessing(Processor processor) {
        this.processor = processor;
    }

    public void setFftWindowType(int n) {
        this.fftWindowType = n;
    }

    public void setFftBlockLength(int n) {
        this.fftBlockLength = n;
    }

    public void setOverlapFactor(float f) {
        this.overlapFactor = f;
    }

    public void setRmsAdaptionEnabled(boolean bl) {
        this.rmsAdaptionEnabled = bl;
    }

    public void setZeroCrossEnabled(boolean bl) {
        this.zeroCrossEnabled = bl;
    }

    public final void operate(AChannel2DSelection aChannel2DSelection) {
        Debug.println(6, "block operate...");
        if (aChannel2DSelection.getArea().isSomethingSelected()) {
            MMArray mMArray = aChannel2DSelection.getChannel().getSamples();
            int n = Math.min((int)aChannel2DSelection.getArea().getXMin(), mMArray.getLength() - 1);
            int n2 = aChannel2DSelection.getArea().getXMax() < aChannel2DSelection.getArea().getXMin() ? 0 : Math.max((int)aChannel2DSelection.getArea().getXMax() - n, 1);
            Debug.println(6, "block operate o=" + n + " l=" + n2);
            float f = 0.0f;
            if (this.rmsAdaptionEnabled) {
                f = AOToolkit.rmsAverage(mMArray, n, n2);
            }
            aChannel2DSelection.getChannel().markChange();
            if (this.re == null) {
                this.re = new MMArray(this.fftBlockLength, 0.0f);
            }
            if (this.re.getLength() != this.fftBlockLength) {
                this.re.setLength(this.fftBlockLength);
            }
            if (this.im == null) {
                this.im = new MMArray(this.fftBlockLength, 0.0f);
            }
            if (this.im.getLength() != this.fftBlockLength) {
                this.im.setLength(this.fftBlockLength);
            }
            if (this.tmp == null) {
                this.tmp = new MMArray(n2, 0.0f);
            }
            if (this.tmp.getLength() != n2) {
                this.tmp.setLength(n2);
            }
            try {
                int n3;
                LProgressViewer.getInstance().entrySubProgress(0.7);
                float f2 = 1.0f - this.overlapFactor;
                int n4 = (int)((float)(n2 / this.fftBlockLength) / f2 + 1.0f);
                for (n3 = -1; n3 < n4 + 1; ++n3) {
                    int n5;
                    int n6;
                    if (LProgressViewer.getInstance().setProgress((double)(n3 + 1) * 1.0 / (double)n4)) {
                        return;
                    }
                    int n7 = (int)((float)n + (float)(n3 * this.fftBlockLength) * f2);
                    for (n6 = 0; n6 < this.fftBlockLength; ++n6) {
                        n5 = n7 + n6;
                        if (n5 >= 0 && n5 < n + n2) {
                            this.re.set(n6, mMArray.get(n5));
                        } else {
                            this.re.set(n6, 0.0f);
                        }
                        this.im.set(n6, 0.0f);
                    }
                    AOToolkit.applyFFTWindow(this.fftWindowType, this.re, this.fftBlockLength);
                    AOToolkit.complexFft(this.re, this.im);
                    n6 = this.processor.process(this.re, this.im, n7, this.fftBlockLength / 2, aChannel2DSelection) ? 1 : 0;
                    AOToolkit.complexIfft(this.re, this.im);
                    for (n5 = 0; n5 < this.fftBlockLength; ++n5) {
                        int n8 = n7 - n + n5;
                        if (n8 < 0 || n8 >= this.tmp.getLength()) continue;
                        this.tmp.set(n8, this.tmp.get(n8) + this.re.get(n5));
                    }
                    if (!this.zeroCrossEnabled) continue;
                    AOToolkit.applyZeroCross(this.tmp, n7 - n);
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    mMArray.set(n + n3, this.tmp.get(n3));
                }
                if (this.rmsAdaptionEnabled) {
                    float f3 = AOToolkit.rmsAverage(mMArray, n, n2);
                    AOToolkit.multiply(mMArray, n, n2, f / f3);
                }
                if (this.zeroCrossEnabled) {
                    AOToolkit.applyZeroCross(mMArray, n);
                    AOToolkit.applyZeroCross(mMArray, n + n2);
                }
                LProgressViewer.getInstance().exitSubProgress();
            }
            catch (Exception exception) {
                Debug.printStackTrace(5, exception);
            }
        }
    }

    public static interface Processor {
        public boolean process(MMArray var1, MMArray var2, int var3, int var4, AChannel2DSelection var5);
    }
}

