/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannel2DSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOSpectrogramBlockProcessing;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.GLanguage;

public class AOSpectrogramFilter
extends AOperation
implements AOSpectrogramBlockProcessing.Processor {
    private int filterMode;
    private float amplification;
    private float threshold;
    private int blockLength;
    private int windowType;
    private float overlap;
    private static final int MAGNITUDE = 0;
    private static final int MAGNITUDE_ABOVE_THRESHOLD = 1;
    private static final int MAGNITUDE_BELOW_THRESHOLD = 2;
    private static String[] filterModeItems = new String[]{GLanguage.translate("magnitude"), GLanguage.translate("aboveThreshold"), GLanguage.translate("belowThreshold")};

    public AOSpectrogramFilter(int n, float f, float f2, int n2, int n3, float f3) {
        this.filterMode = n;
        this.amplification = f;
        this.threshold = f2;
        this.blockLength = n2;
        this.windowType = n3;
        this.overlap = f3;
    }

    @Override
    public void operate(AChannel2DSelection aChannel2DSelection) {
        AOSpectrogramBlockProcessing aOSpectrogramBlockProcessing = new AOSpectrogramBlockProcessing(this);
        aOSpectrogramBlockProcessing.setFftBlockLength(this.blockLength);
        aOSpectrogramBlockProcessing.setFftWindowType(this.windowType);
        aOSpectrogramBlockProcessing.setOverlapFactor(this.overlap);
        aOSpectrogramBlockProcessing.setRmsAdaptionEnabled(false);
        aOSpectrogramBlockProcessing.setZeroCrossEnabled(false);
        aOSpectrogramBlockProcessing.operate(aChannel2DSelection);
    }

    public static final String[] getFilterModeItems() {
        return filterModeItems;
    }

    @Override
    public boolean process(MMArray mMArray, MMArray mMArray2, int n, int n2, AChannel2DSelection aChannel2DSelection) {
        switch (this.filterMode) {
            case 0: {
                return this.performMagnitude(mMArray, mMArray2, n, n2, aChannel2DSelection);
            }
            case 1: {
                return this.performMagnitudeAboveThreshold(mMArray, mMArray2, n, n2, aChannel2DSelection);
            }
            case 2: {
                return this.performMagnitudeBelowThreshold(mMArray, mMArray2, n, n2, aChannel2DSelection);
            }
        }
        return false;
    }

    private boolean performMagnitude(MMArray mMArray, MMArray mMArray2, int n, int n2, AChannel2DSelection aChannel2DSelection) {
        boolean bl = false;
        float f = aChannel2DSelection.getChannel().getParentClip().getSampleRate();
        for (int i = 0; i < n2; ++i) {
            if (!aChannel2DSelection.getArea().isSelected(n, (float)i * f / (float)n2 / 2.0f)) continue;
            mMArray.set(i, mMArray.get(i) * this.amplification);
            mMArray2.set(i, mMArray2.get(i) * this.amplification);
            bl = true;
        }
        return bl;
    }

    private boolean performMagnitudeAboveThreshold(MMArray mMArray, MMArray mMArray2, int n, int n2, AChannel2DSelection aChannel2DSelection) {
        boolean bl = false;
        float f = aChannel2DSelection.getChannel().getParentClip().getSampleRate();
        for (int i = 0; i < n2; ++i) {
            if (!aChannel2DSelection.getArea().isSelected(n, (float)i * f / (float)n2 / 2.0f) || !(AOToolkit.cartesianToMagnitude(mMArray.get(i), mMArray2.get(i)) > this.threshold)) continue;
            mMArray.set(i, mMArray.get(i) * this.amplification);
            mMArray2.set(i, mMArray2.get(i) * this.amplification);
            bl = true;
        }
        return bl;
    }

    private boolean performMagnitudeBelowThreshold(MMArray mMArray, MMArray mMArray2, int n, int n2, AChannel2DSelection aChannel2DSelection) {
        boolean bl = false;
        float f = aChannel2DSelection.getChannel().getParentClip().getSampleRate();
        for (int i = 0; i < n2; ++i) {
            if (!aChannel2DSelection.getArea().isSelected(n, (float)i * f / (float)n2 / 2.0f) || !(AOToolkit.cartesianToMagnitude(mMArray.get(i), mMArray2.get(i)) < this.threshold)) continue;
            mMArray.set(i, mMArray.get(i) * this.amplification);
            mMArray2.set(i, mMArray2.get(i) * this.amplification);
            bl = true;
        }
        return bl;
    }
}

