/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannel2DSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOSpectrogramBlockProcessing;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.GLanguage;

public class AOSpectrogramOrthogonalFilter
extends AOperation
implements AOSpectrogramBlockProcessing.Processor {
    private int filterMode;
    private float amplification;
    private float decay;
    private int blockLength;
    private int windowType;
    private float overlap;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private static String[] filterModeItems = new String[]{GLanguage.translate("vertical"), GLanguage.translate("horizontal")};
    private float avv;
    private float[] avh;

    public AOSpectrogramOrthogonalFilter(int n, float f, float f2, int n2, int n3, float f3) {
        this.filterMode = n;
        this.amplification = f;
        this.decay = f2;
        this.blockLength = n2;
        this.windowType = n3;
        this.overlap = f3;
    }

    @Override
    public void operate(AChannel2DSelection aChannel2DSelection) {
        AOSpectrogramBlockProcessing aOSpectrogramBlockProcessing = new AOSpectrogramBlockProcessing(this);
        aOSpectrogramBlockProcessing.setFftBlockLength(this.blockLength);
        aOSpectrogramBlockProcessing.setFftWindowType(this.windowType);
        aOSpectrogramBlockProcessing.setOverlapFactor(this.overlap);
        aOSpectrogramBlockProcessing.setRmsAdaptionEnabled(false);
        aOSpectrogramBlockProcessing.setZeroCrossEnabled(false);
        aOSpectrogramBlockProcessing.operate(aChannel2DSelection);
    }

    public static final String[] getModeItems() {
        return filterModeItems;
    }

    @Override
    public boolean process(MMArray mMArray, MMArray mMArray2, int n, int n2, AChannel2DSelection aChannel2DSelection) {
        switch (this.filterMode) {
            case 0: {
                return this.performVertical(this.amplification, mMArray, mMArray2, n, n2, aChannel2DSelection);
            }
            case 1: {
                return this.performHorizontal(this.amplification, mMArray, mMArray2, n, n2, aChannel2DSelection);
            }
        }
        return false;
    }

    private boolean performVertical(float f, MMArray mMArray, MMArray mMArray2, int n, int n2, AChannel2DSelection aChannel2DSelection) {
        boolean bl = false;
        float f2 = aChannel2DSelection.getChannel().getParentClip().getSampleRate();
        float f3 = 1 << aChannel2DSelection.getChannel().getParentClip().getSampleWidth() - 1;
        float[] fArray = new float[n2];
        for (int i = 0; i < n2; ++i) {
            fArray[i] = AOToolkit.cartesianToMagnitude(mMArray.get(i), mMArray2.get(i));
        }
        float f4 = AOToolkit.average(fArray, 0, n2) / f3;
        this.avv = Math.abs(f4) > Math.abs(this.avv) ? f4 : Math.max(f4, f4 * this.decay);
        System.out.println("avv=" + this.avv);
        float f5 = (float)Math.pow(this.avv, f);
        for (int i = 0; i < n2; ++i) {
            if (!aChannel2DSelection.getArea().isSelected(n, (float)i * f2 / (float)n2 / 2.0f)) continue;
            mMArray.set(i, mMArray.get(i) * f5);
            mMArray2.set(i, mMArray2.get(i) * f5);
            bl = true;
        }
        return bl;
    }

    @Override
    public void startOperation() {
        this.avh = null;
        this.avv = 0.0f;
    }

    private boolean performHorizontal(float f, MMArray mMArray, MMArray mMArray2, int n, int n2, AChannel2DSelection aChannel2DSelection) {
        int n3;
        boolean bl = false;
        float f2 = aChannel2DSelection.getChannel().getParentClip().getSampleRate();
        float f3 = 1 << aChannel2DSelection.getChannel().getParentClip().getSampleWidth() - 1;
        if (this.avh == null) {
            this.avh = new float[n2];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            this.avh[n3] = AOToolkit.movingAverage(this.avh[n3], AOToolkit.cartesianToMagnitude(mMArray.get(n3), mMArray2.get(n3)) / f3, 100.0f);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if (!aChannel2DSelection.getArea().isSelected(n, (float)n3 * f2 / (float)n2 / 2.0f)) continue;
            float f4 = (float)Math.pow(this.avh[n3], f);
            mMArray.set(n3, mMArray.get(n3) * f4);
            mMArray2.set(n3, mMArray2.get(n3) * f4);
            bl = true;
        }
        return bl;
    }
}

