/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannelMask;
import ch.laoe.clip.ALayer;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GToolkit;
import ch.laoe.ui.LProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class GPMask
extends GPluginFrame {
    private AChannelMask actualMask;
    private JButton clear;
    private JButton complementary;
    private JButton applyDefinitely;
    private EventDispatcher eventDispatcher;

    public GPMask(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "mask";
    }

    @Override
    public JMenuItem createMenuItem() {
        return super.createMenuItem(77);
    }

    @Override
    protected boolean isFocussingMouseEvents() {
        return true;
    }

    private void wideMaskCopy(boolean bl, AChannelMask aChannelMask) {
        if (bl) {
            this.getFocussedClip().getSelectedLayer().wideCopyMask(aChannelMask);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.actualMask = this.getSelectedLayer().getChannel(mouseEvent.getPoint()).getMask();
        this.actualMask.getSegments().mousePressed(mouseEvent);
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 0) {
            this.repaintFocussedClipEditor();
            this.updateHistory(GLanguage.translate(this.getName()));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.actualMask.getSegments().mouseClicked(mouseEvent);
        this.wideMaskCopy(GToolkit.isCtrlKey(mouseEvent), this.actualMask);
        this.repaintFocussedClipEditor();
        this.updateHistory(GLanguage.translate(this.getName()));
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.actualMask.getSegments() != null) {
            this.actualMask.getSegments().mouseEntered(mouseEvent);
        }
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        try {
            this.actualMask = this.getSelectedLayer().getChannel(mouseEvent.getPoint()).getMask();
            if (this.actualMask.getSegments() != null) {
                this.actualMask.getSegments().mouseMoved(mouseEvent);
            }
            this.repaintFocussedClipEditor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.actualMask.getSegments().mouseDragged(mouseEvent);
        this.wideMaskCopy(GToolkit.isCtrlKey(mouseEvent), this.actualMask);
        this.repaintFocussedClipEditor();
    }

    public void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 8, 2);
        uiCartesianLayout.setPreferredCellSize(new Dimension(30, 35));
        jPanel.setLayout(uiCartesianLayout);
        this.clear = new JButton(GLanguage.translate("clear"));
        uiCartesianLayout.add(this.clear, 0, 0, 4, 1);
        this.complementary = new JButton(GLanguage.translate("complement"));
        uiCartesianLayout.add(this.complementary, 4, 0, 4, 1);
        this.applyDefinitely = new JButton(GLanguage.translate("applyDefinitely"));
        uiCartesianLayout.add(this.applyDefinitely, 0, 1, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.clear.addActionListener(this.eventDispatcher);
        this.complementary.addActionListener(this.eventDispatcher);
        this.applyDefinitely.addActionListener(this.eventDispatcher);
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AChannelMask aChannelMask = GPMask.this.getFocussedClip().getSelectedLayer().getSelectedChannel().getMask();
            if (actionEvent.getSource() == GPMask.this.clear) {
                Debug.println(1, "plugin " + GPMask.this.getName() + " [clear] clicked");
                aChannelMask.clear();
                GPMask.this.wideMaskCopy(GToolkit.isCtrlKey(actionEvent), aChannelMask);
                GPMask.this.repaintFocussedClipEditor();
            } else if (actionEvent.getSource() == GPMask.this.complementary) {
                Debug.println(1, "plugin " + GPMask.this.getName() + " [complementary] clicked");
                aChannelMask.setComplementary();
                GPMask.this.wideMaskCopy(GToolkit.isCtrlKey(actionEvent), aChannelMask);
                GPMask.this.repaintFocussedClipEditor();
            } else if (actionEvent.getSource() == GPMask.this.applyDefinitely) {
                LProgressViewer.getInstance().entrySubProgress(GPMask.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPMask.this.getName() + " [apply definitely] clicked");
                if (GToolkit.isCtrlKey(actionEvent)) {
                    ALayer aLayer = GPMask.this.getFocussedClip().getSelectedLayer();
                    for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                        aLayer.getChannel(i).getMask().applyDefinitely();
                    }
                } else {
                    aChannelMask.applyDefinitely();
                }
                GPMask.this.updateHistory(GLanguage.translate(GPMask.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPMask.this.reloadFocussedClipEditor();
            }
            GPMask.this.updateHistory(GLanguage.translate(GPMask.this.getName()));
        }
    }
}

