/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipSelection;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOMath;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipLayerChooser;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPMath
extends GPluginFrame {
    private String[] operationItemConst = new String[]{GLanguage.translate("add"), GLanguage.translate("subtract"), GLanguage.translate("multiply"), GLanguage.translate("divide"), GLanguage.translate("invers"), GLanguage.translate("neg"), GLanguage.translate("pow"), GLanguage.translate("sqrt"), GLanguage.translate("derivate"), GLanguage.translate("integral"), GLanguage.translate("exp"), GLanguage.translate("log"), GLanguage.translate("toDb"), GLanguage.translate("fromDb"), GLanguage.translate("mean"), GLanguage.translate("RMS"), GLanguage.translate("complement")};
    private String[] operationItemVar = new String[]{GLanguage.translate("add"), GLanguage.translate("subtract"), GLanguage.translate("multiply"), GLanguage.translate("divide")};
    private JComboBox operationConst;
    private JComboBox operationVar;
    private UiControlText operand1;
    private UiControlText operand2;
    private GClipLayerChooser layerChooser;
    private JButton applyConst;
    private JButton applyVar;
    private EventDispatcher eventDispatcher;

    public GPMath(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "math";
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 5);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("operation")), 0, 0, 4, 1);
        this.operationConst = new JComboBox<String>(this.operationItemConst);
        uiCartesianLayout.add(this.operationConst, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("operand") + " 1"), 0, 1, 4, 1);
        this.operand1 = new GControlTextA(10, true, true);
        this.operand1.setDataRange(-1.0E9, 1.0E9);
        this.operand1.setData(0.0);
        uiCartesianLayout.add(this.operand1, 4, 1, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("operand") + " 2"), 0, 2, 4, 1);
        this.operand2 = new GControlTextA(10, true, true);
        this.operand2.setDataRange(-1.0E9, 1.0E9);
        this.operand2.setData(0.0);
        uiCartesianLayout.add(this.operand2, 4, 2, 6, 1);
        this.applyConst = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.applyConst, 3, 4, 4, 1);
        jTabbedPane.add(GLanguage.translate("simple"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 5);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("operation")), 0, 0, 4, 1);
        this.operationVar = new JComboBox<String>(this.operationItemVar);
        uiCartesianLayout2.add(this.operationVar, 4, 0, 6, 1);
        this.layerChooser = new GClipLayerChooser(Laoe.getInstance(), "operandCurve");
        uiCartesianLayout2.add(this.layerChooser, 0, 1, 10, 3);
        this.applyVar = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout2.add(this.applyVar, 3, 4, 4, 1);
        jTabbedPane.add(GLanguage.translate("f(time)"), jPanel2);
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.applyConst.addActionListener(new LWorker(this.eventDispatcher));
        this.applyVar.addActionListener(new LWorker(this.eventDispatcher));
        this.operationConst.addActionListener(this.eventDispatcher);
        this.updateActiveComponents();
    }

    private void updateActiveComponents() {
        switch (this.operationConst.getSelectedIndex()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 14: 
            case 15: {
                this.operand1.setEnabled(true);
                this.operand2.setEnabled(false);
                break;
            }
            default: {
                this.operand1.setEnabled(false);
                this.operand2.setEnabled(false);
            }
        }
    }

    @Override
    public void reload() {
        super.reload();
        this.layerChooser.reload();
        this.operand1.refresh();
        this.operand2.refresh();
    }

    private void onApplyConst() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        float[] fArray = new float[]{(float)this.operand1.getData(), (float)this.operand2.getData()};
        switch (this.operationConst.getSelectedIndex()) {
            case 0: {
                aLayerSelection.operateEachChannel(new AOMath(1, fArray));
                break;
            }
            case 1: {
                aLayerSelection.operateEachChannel(new AOMath(2, fArray));
                break;
            }
            case 2: {
                aLayerSelection.operateEachChannel(new AOMath(3, fArray));
                break;
            }
            case 3: {
                aLayerSelection.operateEachChannel(new AOMath(4, fArray));
                break;
            }
            case 4: {
                aLayerSelection.operateEachChannel(new AOMath(5, fArray));
                break;
            }
            case 5: {
                aLayerSelection.operateEachChannel(new AOMath(6, fArray));
                break;
            }
            case 6: {
                aLayerSelection.operateEachChannel(new AOMath(7, fArray));
                break;
            }
            case 7: {
                aLayerSelection.operateEachChannel(new AOMath(8, fArray));
                break;
            }
            case 8: {
                aLayerSelection.operateEachChannel(new AOMath(9, fArray));
                break;
            }
            case 9: {
                aLayerSelection.operateEachChannel(new AOMath(10, fArray));
                break;
            }
            case 10: {
                aLayerSelection.operateEachChannel(new AOMath(11, fArray));
                break;
            }
            case 11: {
                aLayerSelection.operateEachChannel(new AOMath(12, fArray));
                break;
            }
            case 12: {
                aLayerSelection.operateEachChannel(new AOMath(13, fArray));
                break;
            }
            case 13: {
                aLayerSelection.operateEachChannel(new AOMath(14, fArray));
                break;
            }
            case 14: {
                aLayerSelection.operateEachChannel(new AOMath(15, fArray));
                break;
            }
            case 15: {
                aLayerSelection.operateEachChannel(new AOMath(16, fArray));
                break;
            }
            case 16: {
                fArray[0] = -1.0f;
                fArray[1] = 0.0f;
                aLayerSelection.operateEachChannel(new AOMath(3, fArray));
                fArray[0] = 1.0f;
                aLayerSelection.operateEachChannel(new AOMath(1, fArray));
            }
        }
        this.updateHistory(GLanguage.translate(this.getName()));
        this.reloadFocussedClipEditor();
    }

    private void onApplyVar() {
        AClipSelection aClipSelection = new AClipSelection(new AClip());
        aClipSelection.addLayerSelection(this.getFocussedClip().getSelectedLayer().getSelection());
        aClipSelection.addLayerSelection(this.layerChooser.getSelectedLayer().createSelection());
        switch (this.operationVar.getSelectedIndex()) {
            case 0: {
                aClipSelection.operateLayer0WithLayer1(new AOMath(1));
                break;
            }
            case 1: {
                aClipSelection.operateLayer0WithLayer1(new AOMath(2));
                break;
            }
            case 2: {
                aClipSelection.operateLayer0WithLayer1(new AOMath(3));
                break;
            }
            case 3: {
                aClipSelection.operateLayer0WithLayer1(new AOMath(4));
            }
        }
        this.updateHistory(GLanguage.translate(this.getName()));
        this.reloadFocussedClipEditor();
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPMath.this.operationConst) {
                Debug.println(1, "plugin " + GPMath.this.getName() + " [operation const] clicked");
                GPMath.this.updateActiveComponents();
            } else if (actionEvent.getSource() == GPMath.this.applyConst) {
                LProgressViewer.getInstance().entrySubProgress(GPMath.this.getName());
                Debug.println(1, "plugin " + GPMath.this.getName() + " [apply const] clicked");
                GPMath.this.onApplyConst();
                LProgressViewer.getInstance().exitSubProgress();
                GPMath.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPMath.this.applyVar) {
                LProgressViewer.getInstance().entrySubProgress(GPMath.this.getName());
                Debug.println(1, "plugin " + GPMath.this.getName() + " [apply var] clicked");
                GPMath.this.onApplyVar();
                LProgressViewer.getInstance().exitSubProgress();
                GPMath.this.autoCloseNow();
            }
            GPMath.this.reloadFocussedClipEditor();
        }
    }
}

